/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.message.token.Login7;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.mssql.util.StringUtils;
import java.util.UUID;
import reactor.util.annotation.Nullable;

final class LoginConfiguration {
    @Nullable
    private final String applicationName;
    @Nullable
    private final UUID connectionId;
    private final String database;
    private final String hostname;
    private final CharSequence password;
    private final String serverName;
    private final boolean useSsl;
    private final String username;

    LoginConfiguration(@Nullable String applicationName, @Nullable UUID connectionId, String database, String hostname, CharSequence password, String serverName, boolean useSsl, String username) {
        this.username = Assert.requireNonNull(username, "Username must not be null");
        this.password = Assert.requireNonNull(password, "Password must not be null");
        this.database = Assert.requireNonNull(database, "Database must not be null");
        this.hostname = Assert.requireNonNull(hostname, "Hostname must not be null");
        this.applicationName = applicationName;
        this.serverName = Assert.requireNonNull(serverName, "Server name must not be null");
        this.connectionId = connectionId;
        this.useSsl = useSsl;
    }

    @Nullable
    UUID getConnectionId() {
        return this.connectionId;
    }

    boolean useSsl() {
        return this.useSsl;
    }

    Login7.Builder asBuilder() {
        Login7.Builder builder = Login7.builder().username(this.username).password(this.password).database(this.database).hostName(this.hostname).serverName(this.serverName);
        if (StringUtils.hasText(this.applicationName)) {
            builder.applicationName(this.applicationName);
        }
        return builder;
    }
}

