/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.Binding;
import io.r2dbc.mssql.ConnectionOptions;
import io.r2dbc.mssql.DefaultMssqlResult;
import io.r2dbc.mssql.GeneratedValues;
import io.r2dbc.mssql.MssqlResult;
import io.r2dbc.mssql.MssqlStatement;
import io.r2dbc.mssql.MssqlStatementSupport;
import io.r2dbc.mssql.PreparedStatementCache;
import io.r2dbc.mssql.QueryMessageFlow;
import io.r2dbc.mssql.RpcQueryMessageFlow;
import io.r2dbc.mssql.client.Client;
import io.r2dbc.mssql.client.ConnectionContext;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.message.token.DoneInProcToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

final class ParametrizedMssqlStatement
extends MssqlStatementSupport
implements MssqlStatement {
    private static final Logger LOGGER = Loggers.getLogger(ParametrizedMssqlStatement.class);
    private static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final Pattern PARAMETER_MATCHER = Pattern.compile("@([\\p{Alpha}@][@$\\d\\w_]{0,127})");
    private final PreparedStatementCache statementCache;
    private final Client client;
    private final ConnectionOptions connectionOptions;
    private final ConnectionContext context;
    private final Codecs codecs;
    private final ParsedQuery parsedQuery;
    private final Bindings bindings = new Bindings();
    private final boolean sendStringParametersAsUnicode;
    private volatile boolean executed = false;

    ParametrizedMssqlStatement(Client client, ConnectionOptions connectionOptions, String sql) {
        super(connectionOptions.prefersCursors(sql));
        this.connectionOptions = connectionOptions;
        Assert.requireNonNull(client, "Client must not be null");
        Assert.requireNonNull(connectionOptions, "ConnectionOptions must not be null");
        Assert.requireNonNull(sql, "SQL must not be null");
        this.statementCache = connectionOptions.getPreparedStatementCache();
        this.client = client;
        this.context = client.getContext();
        this.codecs = connectionOptions.getCodecs();
        this.parsedQuery = this.statementCache.getParsedSql(sql, ParsedQuery::parse);
        this.sendStringParametersAsUnicode = connectionOptions.isSendStringParametersAsUnicode();
    }

    @Override
    public ParametrizedMssqlStatement add() {
        this.assertNotExecuted();
        this.bindings.finish();
        this.bindings.getCurrent();
        return this;
    }

    @Override
    public Flux<MssqlResult> execute() {
        int effectiveFetchSize = this.getEffectiveFetchSize();
        return Flux.defer(() -> {
            String sql;
            this.assertNotExecuted();
            this.executed = true;
            boolean useGeneratedKeysClause = GeneratedValues.shouldExpectGeneratedKeys(this.getGeneratedColumns());
            String string = sql = useGeneratedKeysClause ? GeneratedValues.augmentQuery(this.parsedQuery.sql, this.getGeneratedColumns()) : this.parsedQuery.sql;
            if (this.bindings.bindings.isEmpty()) {
                Flux<Message> exchange = this.potentiallyAttachTimeout(QueryMessageFlow.exchange(this.client, sql), this.connectionOptions, this.client, sql);
                return exchange.windowUntil(AbstractDoneToken.class::isInstance).map(it -> DefaultMssqlResult.toResult(this.parsedQuery.getSql(), this.context, this.codecs, (Flux<Message>)it, false));
            }
            if (this.bindings.bindings.size() == 1) {
                Binding binding2 = (Binding)this.bindings.bindings.get(0);
                Flux<Message> exchange = this.exchange(effectiveFetchSize, useGeneratedKeysClause, sql, binding2);
                return exchange.windowUntil(DoneInProcToken.class::isInstance).map(it -> DefaultMssqlResult.toResult(this.parsedQuery.getSql(), this.context, this.codecs, (Flux<Message>)it, binding2.hasOutParameters()));
            }
            Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
            Iterator iterator = this.bindings.bindings.iterator();
            AtomicBoolean cancelled = new AtomicBoolean();
            return sink.asFlux().flatMap(binding -> {
                Flux<Message> exchange = this.exchange(effectiveFetchSize, useGeneratedKeysClause, sql, (Binding)binding);
                return exchange.doOnComplete(() -> ParametrizedMssqlStatement.tryNextBinding(iterator, (Sinks.Many<Binding>)sink, cancelled)).windowUntil(DoneInProcToken.class::isInstance).map(it -> DefaultMssqlResult.toResult(this.parsedQuery.getSql(), this.context, this.codecs, (Flux<Message>)it, binding.hasOutParameters()));
            }).doOnSubscribe(it -> {
                Binding initial = (Binding)iterator.next();
                sink.emitNext((Object)initial, Sinks.EmitFailureHandler.FAIL_FAST);
            }).doOnCancel(() -> {
                cancelled.set(true);
                this.clearBindings(iterator);
            }).doOnError(e -> this.clearBindings(iterator));
        });
    }

    private Flux<Message> exchange(int effectiveFetchSize, boolean useGeneratedKeysClause, String sql, Binding it) {
        Flux exchange;
        if (effectiveFetchSize > 0) {
            if (DEBUG_ENABLED) {
                LOGGER.debug(this.context.getMessage("Start cursored exchange for {} with fetch size {}"), new Object[]{sql, effectiveFetchSize});
            }
            exchange = RpcQueryMessageFlow.exchange(this.statementCache, this.client, this.codecs, sql, it, effectiveFetchSize);
        } else {
            if (DEBUG_ENABLED) {
                LOGGER.debug(this.context.getMessage("Start direct exchange for {}"), new Object[]{sql});
            }
            exchange = RpcQueryMessageFlow.exchange(this.client, sql, it);
        }
        if (useGeneratedKeysClause) {
            exchange = exchange.transform(GeneratedValues::reduceToSingleCountDoneToken);
        }
        return this.potentiallyAttachTimeout((Flux<Message>)exchange, this.connectionOptions, this.client, sql);
    }

    private void clearBindings(Iterator<Binding> iterator) {
        while (iterator.hasNext()) {
            iterator.next();
        }
        this.bindings.clear();
    }

    @Override
    public ParametrizedMssqlStatement returnGeneratedValues(String ... columns) {
        super.returnGeneratedValues(columns);
        return this;
    }

    @Override
    public ParametrizedMssqlStatement fetchSize(int fetchSize) {
        super.fetchSize(fetchSize);
        return this;
    }

    private static void tryNextBinding(Iterator<Binding> iterator, Sinks.Many<Binding> boundRequests, AtomicBoolean cancelled) {
        if (cancelled.get()) {
            return;
        }
        try {
            if (iterator.hasNext()) {
                boundRequests.emitNext((Object)iterator.next(), Sinks.EmitFailureHandler.FAIL_FAST);
            } else {
                boundRequests.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
            }
        }
        catch (Exception e) {
            boundRequests.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
        }
    }

    @Override
    public ParametrizedMssqlStatement bind(String identifier, Object value) {
        Assert.requireNonNull(identifier, "identifier must not be null");
        Assert.isInstanceOf(String.class, (Object)identifier, "identifier must be a String");
        boolean isIn = !(value instanceof Parameter.Out);
        RpcParameterContext parameterContext = ParametrizedMssqlStatement.createContext(isIn, null);
        if (ParametrizedMssqlStatement.isTextual(value) || value instanceof Parameter && ParametrizedMssqlStatement.isTextual(((Parameter)value).getValue())) {
            parameterContext = ParametrizedMssqlStatement.createContext(isIn, new RpcParameterContext.CharacterValueContext(this.client.getRequiredCollation(), this.sendStringParametersAsUnicode));
        }
        Encoded encoded = this.codecs.encode(this.client.getByteBufAllocator(), parameterContext, value);
        this.addBinding(this.getParameterName(identifier), isIn ? RpcDirection.IN : RpcDirection.OUT, encoded);
        return this;
    }

    @Override
    public ParametrizedMssqlStatement bind(int index, Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.bind(this.getParameterName(index), value);
    }

    @Override
    public ParametrizedMssqlStatement bindNull(String identifier, Class<?> type) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        Assert.isInstanceOf(String.class, (Object)identifier, "Identifier must be a String");
        Assert.requireNonNull(type, "type must not be null");
        if (this.executed) {
            throw new IllegalStateException("Statement was already executed");
        }
        Encoded encoded = this.codecs.encodeNull(this.client.getByteBufAllocator(), type);
        this.addBinding(this.getParameterName(identifier), RpcDirection.IN, encoded);
        return this;
    }

    @Override
    public ParametrizedMssqlStatement bindNull(int index, Class<?> type) {
        Assert.requireNonNull(type, "Type must not be null");
        return this.bindNull(this.getParameterName(index), (Class)type);
    }

    private static RpcParameterContext createContext(boolean in, @Nullable RpcParameterContext.ValueContext value) {
        if (in) {
            return value != null ? RpcParameterContext.in(value) : RpcParameterContext.in();
        }
        return value != null ? RpcParameterContext.out(value) : RpcParameterContext.out();
    }

    private void addBinding(String name, RpcDirection rpcDirection, Encoded parameter) {
        this.assertNotExecuted();
        this.bindings.getCurrent().add(name, rpcDirection, parameter);
    }

    private void assertNotExecuted() {
        if (this.executed) {
            throw new IllegalStateException("Statement was already executed");
        }
    }

    Bindings getBindings() {
        return this.bindings;
    }

    private String getParameterName(int index) {
        return this.parsedQuery.getParameterName(index);
    }

    private String getParameterName(String name) {
        return this.parsedQuery.getParameterName(name);
    }

    public static boolean supports(String sql) {
        Assert.requireNonNull(sql, "SQL must not be null");
        return sql.lastIndexOf(64) != -1;
    }

    private static boolean isTextual(@Nullable Object value) {
        return value instanceof CharSequence || value instanceof Clob;
    }

    private static int findCharacter(char needle, CharSequence sql, int offset) {
        int length = sql.length();
        block6: while (offset < length && offset != -1) {
            char character = sql.charAt(offset++);
            switch (character) {
                case '/': {
                    if (offset == length) continue block6;
                    if (sql.charAt(offset) == '*') {
                        while (++offset < length) {
                            if (sql.charAt(offset) != '*' || offset + 1 >= length || sql.charAt(offset + 1) != '/') continue;
                            offset += 2;
                            continue block6;
                        }
                        continue block6;
                    }
                    if (sql.charAt(offset) == '-') continue block6;
                }
                case '-': {
                    if (sql.charAt(offset) == '-') {
                        while (++offset < length) {
                            if (sql.charAt(offset) != '\n' && sql.charAt(offset) != '\r') continue;
                            ++offset;
                            continue block6;
                        }
                        continue block6;
                    }
                }
                default: {
                    if (needle != character) continue block6;
                    return offset - 1;
                }
                case '[': {
                    character = ']';
                }
                case '\"': 
                case '\'': 
            }
            char chQuote = character;
            while (offset < length) {
                if (sql.charAt(offset++) != chQuote) continue;
                if (length == offset || sql.charAt(offset) != chQuote) continue block6;
                ++offset;
            }
        }
        return -1;
    }

    static final class Bindings {
        private final List<Binding> bindings = new ArrayList<Binding>();
        private Binding current;

        Bindings() {
        }

        private void finish() {
            this.current = null;
        }

        Binding first() {
            return (Binding)this.bindings.stream().findFirst().orElseThrow(() -> new IllegalStateException("No parameters have been bound"));
        }

        Binding getCurrent() {
            if (this.current == null) {
                this.current = new Binding();
                this.bindings.add(this.current);
            }
            return this.current;
        }

        void clear() {
            this.bindings.forEach(Binding::clear);
        }
    }

    static class ParsedParameter {
        private final String name;
        private final int position;

        ParsedParameter(String name, int position) {
            this.name = name;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParsedParameter)) {
                return false;
            }
            ParsedParameter that = (ParsedParameter)o;
            return this.position == that.position && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.position);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [name='").append(this.name).append('\'');
            sb.append(", position=").append(this.position);
            sb.append(']');
            return sb.toString();
        }
    }

    static class ParsedQuery {
        private final String sql;
        private final List<ParsedParameter> parameters;
        private final Map<String, ParsedParameter> parametersByName = new LinkedHashMap<String, ParsedParameter>();

        ParsedQuery(String sql, List<ParsedParameter> parameters) {
            this.sql = sql;
            this.parameters = parameters;
            for (ParsedParameter parameter : parameters) {
                this.parametersByName.put(parameter.getName(), parameter);
            }
        }

        static ParsedQuery parse(String sql) {
            Assert.requireNonNull(sql, "SQL must not be null");
            ArrayList<ParsedParameter> variables = new ArrayList<ParsedParameter>();
            int offset = 0;
            while (offset != -1) {
                if ((offset = ParametrizedMssqlStatement.findCharacter('@', sql, offset)) == -1) continue;
                Matcher matcher = PARAMETER_MATCHER.matcher(sql.substring(offset));
                ++offset;
                if (!matcher.find()) continue;
                String name = matcher.group(1);
                variables.add(new ParsedParameter(name, offset));
            }
            return new ParsedQuery(sql, variables);
        }

        String getParameterName(String name) {
            ParsedParameter parsedParameter = this.parametersByName.get(name);
            if (name.startsWith("@")) {
                parsedParameter = this.parametersByName.get(name.substring(1));
            }
            if (parsedParameter == null) {
                throw new NoSuchElementException(String.format("Parameter [%s] does not exist in query [%s]", name, this.sql));
            }
            return parsedParameter.getName();
        }

        public String getParameterName(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index must be greater or equal to zero");
            }
            if (index >= this.getParameterCount()) {
                throw new IndexOutOfBoundsException(String.format("No such parameter with index [%d]  in query [%s]", index, this.sql));
            }
            return this.parameters.get(index).getName();
        }

        public String getSql() {
            return this.sql;
        }

        public int getParameterCount() {
            return this.parameters.size();
        }

        public List<ParsedParameter> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParsedQuery)) {
                return false;
            }
            ParsedQuery that = (ParsedQuery)o;
            return Objects.equals(this.sql, that.sql) && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.sql, this.parameters);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [sql='").append(this.sql).append('\'');
            sb.append(", variables=").append(this.parameters);
            sb.append(']');
            return sb.toString();
        }
    }
}

