/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.r2dbc.mssql.client.Client;
import io.r2dbc.mssql.client.MessageDecoder;
import io.r2dbc.mssql.client.ssl.SslState;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.header.Header;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.message.token.DoneToken;
import io.r2dbc.mssql.message.token.Prelogin;
import io.r2dbc.mssql.message.token.Tabular;
import io.r2dbc.mssql.util.Assert;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.SynchronousSink;
import reactor.netty.Connection;

public enum ConnectionState {
    PRELOGIN{

        @Override
        MessageDecoder decoder(Client client) {
            return (header, byteBuf) -> {
                Assert.isTrue(header.getType() == Type.TABULAR_RESULT, () -> "Expected tabular message, header type is: " + (Object)((Object)header.getType()));
                Assert.isTrue(header.is(Status.StatusBit.EOM), "Prelogin response packet must not be chunked");
                return Collections.singletonList(Prelogin.decode(byteBuf));
            };
        }

        @Override
        public boolean canAdvance(Message message) {
            Prelogin prelogin = (Prelogin)message;
            Prelogin.Version version = prelogin.getRequiredToken(Prelogin.Version.class);
            if (version.getVersion() >= 9) {
                return true;
            }
            throw ProtocolException.unsupported("Unsupported SQL server version: " + version.getVersion());
        }

        @Override
        public ConnectionState next(Message message, Connection connection) {
            Prelogin prelogin = (Prelogin)message;
            Prelogin.Encryption encryption = prelogin.getRequiredToken(Prelogin.Encryption.class);
            if (encryption.requiresLoginSslHandshake()) {
                Channel channel = connection.channel();
                channel.pipeline().fireUserEventTriggered((Object)SslState.LOGIN_ONLY);
                return PRELOGIN_SSL_NEGOTIATION;
            }
            if (encryption.requiresConnectionSslHandshake()) {
                Channel channel = connection.channel();
                channel.pipeline().fireUserEventTriggered((Object)SslState.CONNECTION);
                return PRELOGIN_SSL_NEGOTIATION;
            }
            return PRELOGIN;
        }
    }
    ,
    PRELOGIN_SSL_NEGOTIATION{

        @Override
        public boolean canAdvance(Message message) {
            return message == SslState.NEGOTIATED;
        }

        @Override
        public ConnectionState next(Message message, Connection connection) {
            return LOGIN;
        }

        @Override
        MessageDecoder decoder(Client client) {
            return (header, byteBuf) -> {
                throw ProtocolException.invalidTds("Nothing to decode during SSL negotiation");
            };
        }
    }
    ,
    LOGIN{

        @Override
        public boolean canAdvance(Message message) {
            return message instanceof DoneToken;
        }

        @Override
        public ConnectionState next(Message message, Connection connection) {
            if (AbstractDoneToken.isDone(message)) {
                return POST_LOGIN;
            }
            return LOGIN_FAILED;
        }

        @Override
        MessageDecoder decoder(Client client) {
            return (header, byteBuf) -> {
                Assert.isTrue(header.getType() == Type.TABULAR_RESULT, () -> "Expected tabular message, header type is: " + (Object)((Object)header.getType()));
                Assert.isTrue(header.is(Status.StatusBit.EOM), "Login response packet must not be chunked");
                Tabular tabular = Tabular.decode(byteBuf, client.isColumnEncryptionSupported());
                return tabular.getTokens();
            };
        }
    }
    ,
    POST_LOGIN{

        @Override
        public boolean canAdvance(Message message) {
            return false;
        }

        @Override
        public ConnectionState next(Message message, Connection connection) {
            return null;
        }

        @Override
        MessageDecoder decoder(Client client) {
            final Tabular.TabularDecoder decoder = Tabular.createDecoder(client.isColumnEncryptionSupported());
            return new MessageDecoder(){

                @Override
                public List<? extends Message> apply(Header header, ByteBuf byteBuf) {
                    Assert.isTrue(header.getType() == Type.TABULAR_RESULT, () -> "Expected tabular message, header type is: " + (Object)((Object)header.getType()));
                    return decoder.decode(byteBuf);
                }

                @Override
                public boolean decode(Header header, ByteBuf buffer, SynchronousSink<Message> sink) {
                    return decoder.decode(buffer, sink);
                }
            };
        }
    }
    ,
    LOGIN_FAILED{

        @Override
        public boolean canAdvance(Message message) {
            return false;
        }

        @Override
        public ConnectionState next(Message message, Connection connection) {
            return null;
        }

        @Override
        MessageDecoder decoder(Client client) {
            return null;
        }
    };


    public abstract boolean canAdvance(Message var1);

    public abstract ConnectionState next(Message var1, Connection var2);

    abstract MessageDecoder decoder(Client var1);
}

