/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client.ssl;

import java.net.IDN;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import reactor.util.annotation.Nullable;

final class X509CertificateUtil {
    X509CertificateUtil() {
    }

    @Nullable
    static String getHostName(X509Certificate cert) {
        return X509CertificateUtil.extractCommonName(cert.getSubjectX500Principal().getName("canonical"));
    }

    @Nullable
    private static String extractCommonName(String distinguishedName) {
        int index = distinguishedName.indexOf("cn=");
        if (index == -1) {
            return null;
        }
        distinguishedName = distinguishedName.substring(index + 3);
        for (index = 0; index < distinguishedName.length() && distinguishedName.charAt(index) != ','; ++index) {
        }
        String commonName = distinguishedName.substring(0, index);
        if (commonName.length() > 1 && '\"' == commonName.charAt(0)) {
            commonName = '\"' == commonName.charAt(commonName.length() - 1) ? commonName.substring(1, commonName.length() - 1) : null;
        }
        return commonName;
    }

    static List<String> getSubjectAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        ArrayList<String> san = new ArrayList<String>();
        Collection<List<?>> sanCollection = cert.getSubjectAlternativeNames();
        if (sanCollection == null) {
            return san;
        }
        for (List<?> sanEntry : sanCollection) {
            if (sanEntry == null || sanEntry.size() < 2) continue;
            Object key = sanEntry.get(0);
            Object value = sanEntry.get(1);
            if (!(key instanceof Integer) || (Integer)key != 2 || !(value instanceof String)) continue;
            String dnsNameInSANCert = (String)value;
            dnsNameInSANCert = dnsNameInSANCert.toLowerCase(Locale.ENGLISH);
            san.add(IDN.toUnicode(dnsNameInSANCert));
        }
        return san;
    }
}

