/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.util.Assert;
import java.util.function.Function;

abstract class ByteArray {
    static byte[] fromEncoded(Function<ByteBufAllocator, Encoded> encodeFunction) {
        Assert.notNull(encodeFunction, "Encode Function must not be null");
        Encoded encoded = encodeFunction.apply(ByteBufAllocator.DEFAULT);
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)encoded.getValue());
            return byArray;
        }
        finally {
            encoded.dispose();
        }
    }

    static byte[] fromBuffer(Function<ByteBufAllocator, ByteBuf> encodeFunction) {
        ByteBuf buffer = encodeFunction.apply(ByteBufAllocator.DEFAULT);
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)buffer);
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    private ByteArray() {
    }
}

