/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Result;
import java.util.Objects;

public abstract class AbstractDoneToken
extends AbstractDataToken
implements Result.UpdateCount {
    public static final int LENGTH = 13;
    static final int DONE_FINAL = 0;
    static final int DONE_MORE = 1;
    static final int DONE_ERROR = 2;
    static final int DONE_INXACT = 4;
    static final int DONE_COUNT = 16;
    static final int DONE_ATTN = 32;
    static final int DONE_RPCINBATCH = 128;
    static final int DONE_SRVERROR = 256;
    static final int CACHE_SIZE = 48;
    private final int status;
    private final int currentCommand;
    private final long rowCount;

    protected AbstractDoneToken(byte type, int status, int currentCommand, long rowCount) {
        super(type);
        this.status = status;
        this.currentCommand = currentCommand;
        this.rowCount = rowCount;
    }

    public static boolean isAttentionAck(Message message) {
        if (message instanceof AbstractDoneToken) {
            return ((AbstractDoneToken)message).isAttentionAck();
        }
        return false;
    }

    public static boolean isDone(Message message) {
        if (message instanceof AbstractDoneToken) {
            return ((AbstractDoneToken)message).isDone();
        }
        return false;
    }

    public static boolean hasCount(Message message) {
        if (message instanceof AbstractDoneToken) {
            return ((AbstractDoneToken)message).hasCount();
        }
        return false;
    }

    public static boolean canDecode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        return buffer.readableBytes() >= 12;
    }

    public void encode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        buffer.writeByte((int)this.getType());
        Encode.uShort(buffer, this.getStatus());
        Encode.uShort(buffer, this.getCurrentCommand());
        Encode.uLongLong(buffer, this.getRowCount());
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isAttentionAck() {
        return (this.getStatus() & 0x20) != 0;
    }

    public boolean isDone() {
        return (this.getStatus() & 1) == 0;
    }

    public boolean isError() {
        return (this.getStatus() & 2) != 0;
    }

    public boolean hasMore() {
        return (this.getStatus() & 1) != 0;
    }

    public boolean hasCount() {
        return (this.getStatus() & 0x10) != 0;
    }

    public int getCurrentCommand() {
        return this.currentCommand;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDoneToken)) {
            return false;
        }
        AbstractDoneToken doneToken = (AbstractDoneToken)o;
        return this.status == doneToken.status && this.currentCommand == doneToken.currentCommand && this.rowCount == doneToken.rowCount;
    }

    public int hashCode() {
        return Objects.hash(this.status, this.currentCommand, this.rowCount);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [done=").append(this.isDone());
        sb.append(", hasCount=").append(this.hasCount());
        sb.append(", rowCount=").append(this.getRowCount());
        sb.append(", hasMore=").append(this.hasMore());
        sb.append(", attnAck=").append(this.isAttentionAck());
        sb.append(", currentCommand=").append(this.getCurrentCommand());
        sb.append(']');
        return sb.toString();
    }

    public long value() {
        return this.hasCount() ? this.getRowCount() : 0L;
    }
}

