/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.message.ClientMessage;
import io.r2dbc.mssql.message.TransactionDescriptor;
import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;
import io.r2dbc.mssql.message.tds.TdsFragment;
import io.r2dbc.mssql.message.tds.TdsPackets;
import io.r2dbc.mssql.message.token.AllHeaders;
import io.r2dbc.mssql.message.token.TokenStream;
import io.r2dbc.mssql.util.Assert;
import java.util.Objects;

public final class Attention
implements ClientMessage,
TokenStream {
    private static final HeaderOptions header = HeaderOptions.create(Type.ATTENTION, Status.empty());
    private final AllHeaders allHeaders;

    private Attention(int outstandingRequests, byte[] transactionDescriptor) {
        Assert.requireNonNull(transactionDescriptor, "Transaction descriptor must not be null");
        this.allHeaders = AllHeaders.transactional(transactionDescriptor, outstandingRequests);
    }

    public static Attention create(int outstandingRequests, TransactionDescriptor transactionDescriptor) {
        Assert.requireNonNull(transactionDescriptor, "Transaction descriptor must not be null");
        return new Attention(outstandingRequests, transactionDescriptor.toBytes());
    }

    @Override
    public TdsFragment encode(ByteBufAllocator allocator, int packetSize) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        int length = this.allHeaders.getLength();
        ByteBuf buffer = allocator.buffer(length);
        this.encode(buffer);
        return TdsPackets.create(header, Unpooled.EMPTY_BUFFER);
    }

    void encode(ByteBuf buffer) {
        this.allHeaders.encode(buffer);
    }

    @Override
    public String getName() {
        return "ATTN";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attention)) {
            return false;
        }
        Attention attn = (Attention)o;
        return Objects.equals(this.allHeaders, attn.allHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.allHeaders);
    }

    public String toString() {
        return this.getName();
    }
}

