/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.util.annotation.Nullable;

public class ColInfoToken
extends AbstractDataToken {
    public static final byte TYPE = -91;
    public static final int STATUS_EXPRESSION = 4;
    public static final int STATUS_KEY = 8;
    public static final int STATUS_HIDDEN = 16;
    public static final int STATUS_DIFFERENT_NAME = 32;
    private static final ColInfoToken EMPTY = new ColInfoToken(Collections.emptyList());
    private final List<ColInfo> columns;

    private ColInfoToken(List<ColInfo> columns) {
        super((byte)-91);
        this.columns = columns;
    }

    public static ColInfoToken skip(ByteBuf buffer) {
        int length = Decode.uShort(buffer);
        buffer.skipBytes(length);
        return EMPTY;
    }

    public static ColInfoToken decode(ByteBuf buffer) {
        int length = Decode.uShort(buffer);
        int readerIndex = buffer.readerIndex();
        ArrayList<ColInfo> columns = new ArrayList<ColInfo>();
        while (buffer.readerIndex() - readerIndex < length) {
            byte column = Decode.asByte(buffer);
            byte table = Decode.asByte(buffer);
            byte status = Decode.asByte(buffer);
            String columnName = (status & 0x20) != 0 ? Decode.unicodeBString(buffer) : null;
            columns.add(new ColInfo(column, table, status, columnName));
        }
        return new ColInfoToken(columns);
    }

    public static boolean canDecode(ByteBuf buffer) {
        if (buffer.readableBytes() >= 5) {
            Integer requiredLength = Decode.peekUShort(buffer);
            return requiredLength != null && buffer.readableBytes() >= requiredLength + 2;
        }
        return false;
    }

    public List<ColInfo> getColumns() {
        return this.columns;
    }

    @Override
    public String getName() {
        return "COLINFO";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [columns=").append(this.columns);
        sb.append(']');
        return sb.toString();
    }

    static final class ColInfo {
        private final byte column;
        private final byte table;
        private final byte status;
        @Nullable
        private final String name;

        private ColInfo(byte column, byte table, byte status, @Nullable String name) {
            this.column = column;
            this.table = table;
            this.status = status;
            this.name = name;
        }

        public byte getColumn() {
            return this.column;
        }

        public byte getTable() {
            return this.table;
        }

        public byte getStatus() {
            return this.status;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [column=").append(this.column);
            sb.append(", table=").append(this.table);
            sb.append(", status=").append(this.status);
            sb.append(", columnName=\"").append(this.name).append('\"');
            sb.append(']');
            return sb.toString();
        }
    }
}

