/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.token.Identifier;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ColumnMetadataToken
extends AbstractDataToken {
    public static final byte TYPE = -127;
    public static final int NO_COLUMNS = 65535;
    private static final byte TYPE_SQLDATACLASSIFICATION = -93;
    private static final ColumnMetadataToken EMPTY = new ColumnMetadataToken(new Column[0]);
    private final Column[] columns;
    private final Map<String, Column> namedColumns;

    private ColumnMetadataToken(Column[] columns) {
        super((byte)-127);
        this.columns = columns;
        if (columns.length == 1) {
            this.namedColumns = Collections.singletonMap(columns[0].getName(), columns[0]);
        } else {
            HashMap<String, Column> byName = new HashMap<String, Column>(this.columns.length, 1.0f);
            for (Column column : columns) {
                Column old = byName.put(column.getName(), column);
                if (old == null) continue;
                byName.put(column.getName(), old);
            }
            this.namedColumns = byName;
        }
    }

    public static ColumnMetadataToken create(Column[] columns) {
        return new ColumnMetadataToken(columns);
    }

    public static ColumnMetadataToken decode(ByteBuf buffer, boolean encryptionSupported) {
        int tableSize;
        int columnCount = Decode.uShort(buffer);
        if (columnCount == 65535) {
            return EMPTY;
        }
        if (encryptionSupported && (tableSize = Decode.uShort(buffer)) != 0) {
            throw new UnsupportedOperationException("Driver does not support encryption");
        }
        Column[] columns = new Column[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columns[i] = ColumnMetadataToken.decodeColumn(buffer, encryptionSupported, i);
            ColumnMetadataToken.decodeDataClassification(buffer);
        }
        return new ColumnMetadataToken(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ByteBuf buffer, boolean encryptionSupported) {
        if (buffer.readableBytes() < 2) {
            return false;
        }
        int readerIndex = buffer.readerIndex();
        try {
            int columnCount = Decode.uShort(buffer);
            if (columnCount == 65535) {
                boolean bl = true;
                return bl;
            }
            if (encryptionSupported) {
                if (buffer.readableBytes() < 2) {
                    boolean bl = false;
                    return bl;
                }
                buffer.skipBytes(2);
            }
            for (int i = 0; i < columnCount; ++i) {
                if (!TypeInformation.canDecode(buffer, true)) {
                    boolean bl = false;
                    return bl;
                }
                if (ColumnMetadataToken.canDecodeColumn(buffer, encryptionSupported)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
        return true;
    }

    private static boolean canDecodeColumn(ByteBuf buffer, boolean encryptionSupported) {
        TypeInformation typeInfo = TypeInformation.decode(buffer, true);
        if (!(typeInfo.getServerType() != SqlServerType.TEXT && typeInfo.getServerType() != SqlServerType.NTEXT && typeInfo.getServerType() != SqlServerType.IMAGE || Identifier.canDecodeAndSkipBytes(buffer))) {
            return false;
        }
        if (encryptionSupported && typeInfo.isEncrypted()) {
            throw new UnsupportedOperationException("Driver does not support encryption");
        }
        if (!buffer.isReadable()) {
            return false;
        }
        int length = buffer.readByte() * 2;
        if (length > buffer.readableBytes()) {
            return false;
        }
        buffer.skipBytes(length);
        ColumnMetadataToken.decodeDataClassification(buffer);
        return true;
    }

    private static void decodeDataClassification(ByteBuf buffer) {
        if (buffer.readableBytes() > 1) {
            buffer.markReaderIndex();
            byte nextToken = Decode.asByte(buffer);
            buffer.resetReaderIndex();
            if (nextToken == -93) {
                throw new UnsupportedOperationException("Driver does not support SQL Data Classification");
            }
        }
    }

    private static Column decodeColumn(ByteBuf buffer, boolean encryptionSupported, int columnIndex) {
        TypeInformation typeInfo = TypeInformation.decode(buffer, true);
        Identifier tableName = null;
        if (typeInfo.getServerType() == SqlServerType.TEXT || typeInfo.getServerType() == SqlServerType.NTEXT || typeInfo.getServerType() == SqlServerType.IMAGE) {
            tableName = Identifier.decode(buffer);
        }
        if (encryptionSupported && typeInfo.isEncrypted()) {
            throw new UnsupportedOperationException("Driver does not support encryption");
        }
        String name = Decode.unicodeBString(buffer);
        return new Column(columnIndex, name, typeInfo, tableName);
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public boolean hasColumns() {
        return this.columns.length != 0;
    }

    @Override
    public String getName() {
        return "COLMETADATA";
    }

    public Map<String, Column> toMap() {
        return this.namedColumns;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [columns=").append(Arrays.toString(this.columns));
        sb.append(']');
        return sb.toString();
    }
}

