/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.token.ColInfoToken;
import io.r2dbc.mssql.message.token.ColumnMetadataToken;
import io.r2dbc.mssql.message.token.DataToken;
import io.r2dbc.mssql.message.token.DoneInProcToken;
import io.r2dbc.mssql.message.token.DoneProcToken;
import io.r2dbc.mssql.message.token.DoneToken;
import io.r2dbc.mssql.message.token.EnvChangeToken;
import io.r2dbc.mssql.message.token.ErrorToken;
import io.r2dbc.mssql.message.token.FeatureExtAckToken;
import io.r2dbc.mssql.message.token.InfoToken;
import io.r2dbc.mssql.message.token.LoginAckToken;
import io.r2dbc.mssql.message.token.NbcRowToken;
import io.r2dbc.mssql.message.token.OrderToken;
import io.r2dbc.mssql.message.token.ReturnStatus;
import io.r2dbc.mssql.message.token.ReturnValue;
import io.r2dbc.mssql.message.token.RowToken;
import io.r2dbc.mssql.message.token.TabnameToken;
import io.r2dbc.mssql.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

public final class Tabular
implements Message {
    private final List<? extends DataToken> tokens;

    private Tabular(List<? extends DataToken> tokens) {
        this.tokens = tokens;
    }

    public static Tabular create(DataToken ... tokens) {
        Assert.requireNonNull(tokens, "Data tokens must not be null");
        return new Tabular(Arrays.asList(tokens));
    }

    public static Tabular decode(ByteBuf buffer, boolean encryptionSupported) {
        Assert.requireNonNull(buffer, "Buffer must not be null");
        return new Tabular(new TabularDecoder(encryptionSupported).decode(buffer));
    }

    public static TabularDecoder createDecoder(boolean encryptionSupported) {
        return new TabularDecoder(encryptionSupported);
    }

    private static DecodeFunction decodeFunction(boolean encryptionSupported) {
        AtomicReference columns = new AtomicReference();
        return (type, buffer) -> {
            if (type == -29) {
                return EnvChangeToken.canDecode(buffer) ? EnvChangeToken.decode(buffer) : DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -82) {
                return FeatureExtAckToken.decode(buffer);
            }
            if (type == -85) {
                return InfoToken.canDecode(buffer) ? InfoToken.decode(buffer) : DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -86) {
                return ErrorToken.canDecode(buffer) ? ErrorToken.decode(buffer) : DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -83) {
                return LoginAckToken.decode(buffer);
            }
            if (type == -127) {
                if (!ColumnMetadataToken.canDecode(buffer, encryptionSupported)) {
                    return DecodeFinished.UNABLE_TO_DECODE;
                }
                ColumnMetadataToken colMetadataToken = ColumnMetadataToken.decode(buffer, encryptionSupported);
                if (columns.get() == null || colMetadataToken.hasColumns()) {
                    columns.set(colMetadataToken);
                }
                return colMetadataToken;
            }
            if (type == -91) {
                return ColInfoToken.canDecode(buffer) ? ColInfoToken.decode(buffer) : DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -92) {
                return TabnameToken.canDecode(buffer) ? TabnameToken.decode(buffer) : DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -3) {
                if (DoneToken.canDecode(buffer)) {
                    DoneToken decode = DoneToken.decode(buffer);
                    if (!decode.hasMore()) {
                        columns.set(null);
                    }
                    return decode;
                }
                return DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -1) {
                if (DoneInProcToken.canDecode(buffer)) {
                    return DoneInProcToken.decode(buffer);
                }
                return DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -2) {
                if (DoneProcToken.canDecode(buffer)) {
                    return DoneProcToken.decode(buffer);
                }
                return DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -87) {
                if (!OrderToken.canDecode(buffer)) {
                    return DecodeFinished.UNABLE_TO_DECODE;
                }
                return OrderToken.decode(buffer);
            }
            if (type == -47) {
                ColumnMetadataToken colMetadataToken = (ColumnMetadataToken)columns.get();
                if (!RowToken.canDecode(buffer, colMetadataToken.getColumns())) {
                    return DecodeFinished.UNABLE_TO_DECODE;
                }
                return RowToken.decode(buffer, colMetadataToken.getColumns());
            }
            if (type == -46) {
                ColumnMetadataToken colMetadataToken = (ColumnMetadataToken)columns.get();
                if (!NbcRowToken.canDecode(buffer, colMetadataToken.getColumns())) {
                    return DecodeFinished.UNABLE_TO_DECODE;
                }
                return NbcRowToken.decode(buffer, colMetadataToken.getColumns());
            }
            if (type == 121) {
                return ReturnStatus.canDecode(buffer) ? ReturnStatus.decode(buffer) : DecodeFinished.UNABLE_TO_DECODE;
            }
            if (type == -84) {
                return ReturnValue.canDecode(buffer, encryptionSupported) ? ReturnValue.decode(buffer, encryptionSupported) : DecodeFinished.UNABLE_TO_DECODE;
            }
            throw ProtocolException.invalidTds(String.format("Unable to decode unknown token type 0x%02X", type));
        };
    }

    public List<? extends DataToken> getTokens() {
        return this.tokens;
    }

    @Nullable
    private DataToken findToken(Predicate<DataToken> filter) {
        Assert.requireNonNull(filter, "Filter must not be null");
        for (DataToken dataToken : this.tokens) {
            if (!filter.test(dataToken)) continue;
            return dataToken;
        }
        return null;
    }

    <T extends DataToken> Optional<T> getToken(Class<? extends T> tokenType) {
        Assert.requireNonNull(tokenType, "Token type must not be null");
        return Optional.ofNullable(this.findToken(tokenType::isInstance)).map(tokenType::cast);
    }

    <T extends DataToken> Optional<T> getToken(Class<? extends T> tokenType, Predicate<T> filter) {
        Assert.requireNonNull(tokenType, "Token type must not be null");
        Assert.requireNonNull(filter, "Filter must not be null");
        Predicate<DataToken> predicate = tokenType::isInstance;
        return Optional.ofNullable(this.findToken(predicate.and(dataToken -> filter.test(tokenType.cast(dataToken))))).map(tokenType::cast);
    }

    <T extends DataToken> T getRequiredToken(Class<? extends T> tokenType) {
        return (T)((DataToken)this.getToken(tokenType).orElseThrow(() -> new IllegalArgumentException(String.format("No token of type [%s] available", tokenType.getName()))));
    }

    <T extends DataToken> T getRequiredToken(Class<? extends T> tokenType, Predicate<T> filter) {
        return (T)((DataToken)this.getToken(tokenType, filter).orElseThrow(() -> new IllegalArgumentException(String.format("No token of type [%s] available", tokenType.getName()))));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [tokens=").append(this.tokens);
        sb.append(']');
        return sb.toString();
    }

    @FunctionalInterface
    static interface DecodeFunction {
        public DataToken tryDecode(byte var1, ByteBuf var2);
    }

    public static class TabularDecoder {
        private final DecodeFunction decodeFunction;

        TabularDecoder(boolean encryptionSupported) {
            this.decodeFunction = Tabular.decodeFunction(encryptionSupported);
        }

        public List<DataToken> decode(ByteBuf buffer) {
            Assert.requireNonNull(buffer, "Buffer must not be null");
            ArrayList<DataToken> tokens = new ArrayList<DataToken>();
            while (buffer.readableBytes() != 0) {
                int readerIndex = buffer.readerIndex();
                byte type = Decode.asByte(buffer);
                DataToken message = this.decodeFunction.tryDecode(type, buffer);
                if (message == DecodeFinished.UNABLE_TO_DECODE) {
                    buffer.readerIndex(readerIndex);
                    break;
                }
                if (message == DecodeFinished.FINISHED) break;
                tokens.add(message);
            }
            return tokens;
        }

        public boolean decode(ByteBuf buffer, SynchronousSink<Message> messageConsumer) {
            Assert.requireNonNull(buffer, "Buffer must not be null");
            boolean hasMessages = false;
            while (buffer.readableBytes() != 0) {
                int readerIndex = buffer.readerIndex();
                byte type = Decode.asByte(buffer);
                DataToken message = this.decodeFunction.tryDecode(type, buffer);
                if (message == DecodeFinished.UNABLE_TO_DECODE) {
                    buffer.readerIndex(readerIndex);
                    break;
                }
                if (message == DecodeFinished.FINISHED) break;
                messageConsumer.next((Object)message);
                hasMessages = true;
            }
            return hasMessages;
        }
    }

    static enum DecodeFinished implements DataToken
    {
        FINISHED,
        UNABLE_TO_DECODE;


        @Override
        public byte getType() {
            return -1;
        }

        @Override
        public String getName() {
            return "DECODE_FINISHED";
        }
    }
}

