/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.MutableTypeInformation;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeBuilder;
import io.r2dbc.mssql.util.Assert;
import java.nio.charset.Charset;
import reactor.util.annotation.Nullable;

public interface TypeInformation {
    public static TypeInformation decode(ByteBuf buffer, boolean readFlags) {
        return TypeBuilder.decode(buffer, readFlags);
    }

    public static boolean canDecode(ByteBuf buffer, boolean readFlags) {
        return TypeBuilder.canDecode(buffer, readFlags);
    }

    public int getMaxLength();

    public LengthStrategy getLengthStrategy();

    public int getPrecision();

    public int getDisplaySize();

    public int getScale();

    public SqlServerType getServerType();

    public int getUserType();

    @Nullable
    public String getUdtTypeName();

    @Nullable
    public Collation getCollation();

    @Nullable
    public Charset getCharset();

    public String getServerTypeName();

    public boolean isNullable();

    public boolean isCaseSensitive();

    public boolean isSparseColumnSet();

    public boolean isEncrypted();

    public Updatability getUpdatability();

    public boolean isIdentity();

    public static Builder builder() {
        return new Builder();
    }

    public static enum Updatability {
        READ_ONLY(0),
        READ_WRITE(1),
        UNKNOWN(2);

        private final byte value;

        private Updatability(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static final class Builder {
        private Charset charset;
        private Collation collation;
        private int displaySize;
        private int flags;
        private LengthStrategy lengthStrategy;
        private int maxLength;
        private int precision;
        private int scale;
        private SqlServerType serverType;
        private String udtTypeName;
        private int userType;

        private Builder() {
        }

        public Builder withCharset(Charset charset) {
            this.charset = Assert.requireNonNull(charset, "Charset must not be null");
            return this;
        }

        public Builder withCollation(Collation collation) {
            this.collation = Assert.requireNonNull(collation, "Collation must not be null");
            return this;
        }

        public Builder withDisplaySize(int displaySize) {
            this.displaySize = displaySize;
            return this;
        }

        public Builder withFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder withLengthStrategy(LengthStrategy lengthStrategy) {
            this.lengthStrategy = Assert.requireNonNull(lengthStrategy, "LengthStrategy must not be null");
            return this;
        }

        public Builder withMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder withPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder withScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder withServerType(SqlServerType serverType) {
            this.serverType = Assert.requireNonNull(serverType, "SqlServerType must not be null");
            return this;
        }

        public TypeInformation build() {
            MutableTypeInformation mutableTypeInformation = new MutableTypeInformation();
            mutableTypeInformation.lengthStrategy = this.lengthStrategy;
            mutableTypeInformation.serverType = this.serverType;
            mutableTypeInformation.flags = this.flags;
            mutableTypeInformation.maxLength = this.maxLength;
            mutableTypeInformation.charset = this.charset;
            mutableTypeInformation.scale = this.scale;
            mutableTypeInformation.userType = this.userType;
            mutableTypeInformation.precision = this.precision;
            mutableTypeInformation.displaySize = this.displaySize;
            mutableTypeInformation.udtTypeName = this.udtTypeName;
            mutableTypeInformation.collation = this.collation;
            return mutableTypeInformation;
        }
    }
}

