/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.r2dbc.mssql.util.Assert;

public final class TypeUtils {
    static final int UDT_TIMESTAMP = 80;
    static final int SHORT_VARTYPE_MAX_CHARS = 4000;
    public static final int SHORT_VARTYPE_MAX_BYTES = 8000;
    static final int SQL_USHORTVARMAXLEN = 65535;
    static final int NTEXT_MAX_CHARS = 0x3FFFFFFF;
    public static final int IMAGE_TEXT_MAX_BYTES = Integer.MAX_VALUE;
    static final int MAX_VARTYPE_MAX_CHARS = 0x3FFFFFFF;
    static final int MAX_VARTYPE_MAX_BYTES = Integer.MAX_VALUE;
    static final int MAXTYPE_LENGTH = 65535;
    public static final int UNKNOWN_STREAM_LENGTH = -1;
    public static final int MAX_FRACTIONAL_SECONDS_SCALE = 7;
    public static final int DAYS_INTO_CE_LENGTH = 3;
    public static final int MINUTES_OFFSET_LENGTH = 2;
    static final int DAYS_PER_YEAR = 365;
    private static final int[] SCALED_TIME_LENGTHS = new int[]{3, 3, 3, 4, 4, 5, 5, 5};

    public static int getTimeValueLength(int scale) {
        return TypeUtils.getNanosSinceMidnightLength(scale);
    }

    public static int getDateTimeValueLength(int scale) {
        return 3 + TypeUtils.getNanosSinceMidnightLength(scale);
    }

    static int getDatetimeoffsetValueLength(int scale) {
        return 5 + TypeUtils.getNanosSinceMidnightLength(scale);
    }

    private static int getNanosSinceMidnightLength(int scale) {
        Assert.isTrue(scale >= 0 && scale <= 7, "Scale must be between 0 and 7");
        return SCALED_TIME_LENGTHS[scale];
    }
}

