/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

class MonoDiscardOnCancel<T>
extends MonoOperator<T, T> {
    private static final Logger logger = Loggers.getLogger(MonoDiscardOnCancel.class);
    private final BooleanSupplier cancelConsumer;

    MonoDiscardOnCancel(Mono<? extends T> source, BooleanSupplier cancelConsumer) {
        super(source);
        this.cancelConsumer = cancelConsumer;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new MonoDiscardOnCancelSubscriber<T>(actual, this.cancelConsumer));
    }

    static class MonoDiscardOnCancelSubscriber<T>
    extends AtomicBoolean
    implements CoreSubscriber<T>,
    Subscription {
        final CoreSubscriber<T> actual;
        final Context ctx;
        final BooleanSupplier cancelConsumer;
        Subscription s;

        MonoDiscardOnCancelSubscriber(CoreSubscriber<T> actual, BooleanSupplier cancelConsumer) {
            this.actual = actual;
            this.ctx = actual.currentContext();
            this.cancelConsumer = cancelConsumer;
        }

        public Context currentContext() {
            return this.ctx;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.get()) {
                Operators.onDiscard(t, (Context)this.ctx);
                return;
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (!this.get()) {
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            if (!this.get()) {
                this.actual.onComplete();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (this.compareAndSet(false, true)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("received cancel signal");
                }
                try {
                    boolean mayCancelUpstream = this.cancelConsumer.getAsBoolean();
                    if (mayCancelUpstream) {
                        this.s.cancel();
                        return;
                    }
                }
                catch (Exception e) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.ctx);
                }
                this.s.request(Long.MAX_VALUE);
            }
        }
    }
}

