/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandler;
import io.r2dbc.proxy.callback.MethodInvocationSubscriber;
import io.r2dbc.proxy.callback.MutableMethodExecutionInfo;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.ProxyConfigHolder;
import io.r2dbc.proxy.callback.ProxyFactory;
import io.r2dbc.proxy.callback.QueriesExecutionContext;
import io.r2dbc.proxy.callback.QueryInvocationSubscriber;
import io.r2dbc.proxy.callback.StopWatch;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.MethodExecutionInfo;
import io.r2dbc.proxy.core.ProxyEventType;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Wrapped;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

abstract class CallbackHandlerSupport
implements CallbackHandler {
    protected static final MethodInvocationStrategy DEFAULT_INVOCATION_STRATEGY = (method, target, args) -> {
        Object result;
        try {
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        return result;
    };
    private static final Set<String> COMMON_METHODS = new HashSet<String>(Arrays.asList("toString", "equals", "hashCode", "unwrap", "getProxyConfig", "unwrapConnection"));
    protected final ProxyConfig proxyConfig;
    protected MethodInvocationStrategy methodInvocationStrategy = DEFAULT_INVOCATION_STRATEGY;

    public CallbackHandlerSupport(ProxyConfig proxyConfig) {
        this.proxyConfig = Assert.requireNonNull(proxyConfig, "proxyConfig must not be null");
    }

    protected boolean isCommonMethod(String methodName) {
        return COMMON_METHODS.contains(methodName);
    }

    @Nullable
    protected Object handleCommonMethod(String methodName, Object original, @Nullable Object[] args, @Nullable Connection originalConnection) {
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(original.getClass().getSimpleName());
            sb.append("-proxy [");
            sb.append(original);
            sb.append("]");
            return sb.toString();
        }
        if ("equals".equals(methodName)) {
            return original.equals(args[0]) || args[0] instanceof Wrapped && args[0] instanceof ProxyConfigHolder && original.equals(((Wrapped)args[0]).unwrap());
        }
        if ("hashCode".equals(methodName)) {
            return original.hashCode();
        }
        if ("getProxyConfig".equals(methodName)) {
            return this.proxyConfig;
        }
        if ("unwrapConnection".equals(methodName)) {
            return originalConnection;
        }
        if ("unwrap".equals(methodName)) {
            if (args == null) {
                return original;
            }
            Class targetClass = (Class)args[0];
            if (original instanceof Wrapped) {
                return ((Wrapped)original).unwrap(targetClass);
            }
            if (targetClass.isInstance(original)) {
                return original;
            }
            return null;
        }
        throw new IllegalStateException(methodName + " does not match to the common method names.");
    }

    protected Object proceedExecution(Method method, Object target, @Nullable Object[] args, ProxyExecutionListener listener, @Nullable ConnectionInfo connectionInfo, @Nullable Consumer<MethodExecutionInfo> onComplete) throws Throwable {
        Assert.requireNonNull(method, "method must not be null");
        Assert.requireNonNull(target, "target must not be null");
        Assert.requireNonNull(listener, "listener must not be null");
        StopWatch stopWatch = new StopWatch(this.proxyConfig.getClock());
        MutableMethodExecutionInfo executionInfo = new MutableMethodExecutionInfo();
        executionInfo.setMethod(method);
        executionInfo.setMethodArgs(args);
        executionInfo.setTarget(target);
        executionInfo.setConnectionInfo(connectionInfo);
        Class<?> returnType = method.getReturnType();
        if (Publisher.class.isAssignableFrom(returnType)) {
            Publisher result = (Publisher)this.methodInvocationStrategy.invoke(method, target, args);
            Function transformer = Operators.liftPublisher((publisher, subscriber) -> new MethodInvocationSubscriber((CoreSubscriber<Object>)subscriber, executionInfo, this.proxyConfig, onComplete));
            if (result instanceof Mono) {
                return ((Mono)result).cast(Object.class).transform(transformer);
            }
            return Flux.from((Publisher)result).cast(Object.class).transform(transformer);
        }
        executionInfo.setThreadName(Thread.currentThread().getName());
        executionInfo.setThreadId(Thread.currentThread().getId());
        executionInfo.setProxyEventType(ProxyEventType.BEFORE_METHOD);
        listener.beforeMethod(executionInfo);
        stopWatch.start();
        Object result = null;
        Throwable thrown = null;
        try {
            result = this.methodInvocationStrategy.invoke(method, target, args);
            executionInfo.setResult(result);
            executionInfo.setThrown(thrown);
            executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
            executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
            listener.afterMethod(executionInfo);
        }
        catch (Throwable ex) {
            try {
                thrown = ex;
                throw thrown;
            }
            catch (Throwable throwable) {
                executionInfo.setResult(result);
                executionInfo.setThrown(thrown);
                executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
                executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
                listener.afterMethod(executionInfo);
                throw throwable;
            }
        }
        return result;
    }

    protected Flux<? extends Result> interceptQueryExecution(Publisher<? extends Result> publisher, MutableQueryExecutionInfo executionInfo) {
        Assert.requireNonNull(publisher, "flux must not be null");
        Assert.requireNonNull(executionInfo, "executionInfo must not be null");
        QueriesExecutionContext queriesExecutionContext = new QueriesExecutionContext(this.proxyConfig.getClock());
        ProxyFactory proxyFactory = this.proxyConfig.getProxyFactory();
        Function transformer = Operators.liftPublisher((pub, subscriber) -> new QueryInvocationSubscriber((CoreSubscriber<? super Result>)subscriber, executionInfo, this.proxyConfig, queriesExecutionContext));
        return Flux.from(publisher).cast(Result.class).transform(transformer).map(queryResult -> proxyFactory.wrapResult((Result)queryResult, executionInfo, queriesExecutionContext));
    }

    public void setMethodInvocationStrategy(MethodInvocationStrategy methodInvocationStrategy) {
        this.methodInvocationStrategy = Assert.requireNonNull(methodInvocationStrategy, "methodInvocationStrategy must not be null");
    }

    @FunctionalInterface
    public static interface MethodInvocationStrategy {
        public Object invoke(Method var1, Object var2, @Nullable Object[] var3) throws Throwable;
    }
}

