/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.components.ManifestCustomizerService;
import io.reactiverse.vertx.maven.plugin.components.ServiceUtils;
import io.reactiverse.vertx.maven.plugin.mojos.Archive;
import io.reactiverse.vertx.maven.plugin.mojos.DependencySet;
import io.reactiverse.vertx.maven.plugin.utils.WebJars;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.ScmManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractVertxMojo
extends AbstractMojo
implements Contextualizable {
    public static final String IO_VERTX_CORE_LAUNCHER = "io.vertx.core.Launcher";
    protected static final String[] WILDCARD_CONFIG_FILES = new String[]{"*.yml", "*.yaml", "*.json"};
    protected static final String VERTX_ARG_CONF = "-conf";
    protected static final String VERTX_ARG_LAUNCHER_CLASS = "--launcher-class";
    protected static final String DEFAULT_CONF_DIR = "src/main/conf";
    protected static final String VERTX_ARG_JAVA_OPT = "--java-opts";
    protected static final String VERTX_ARG_REDEPLOY = "--redeploy=";
    protected static final String VERTX_ARG_REDEPLOY_SCAN_PERIOD = "--redeploy-scan-period=";
    protected static final String VERTX_ARG_REDEPLOY_GRACE_PERIOD = "--redeploy-grace-period=";
    protected static final String VERTX_ARG_REDEPLOY_TERMINATION_PERIOD = "redeploy-termination-period=";
    protected static final String VERTX_CONFIG_FILE_JSON = "application.json";
    protected static final String VERTX_COMMAND_STOP = "stop";
    protected static final String VERTX_COMMAND_START = "start";
    protected static final String VERTX_PACKAGING = "jar";
    protected static final String VERTX_PID_FILE = "vertx-start-process.id";
    protected static final String VERTX_RUN_MODE_JAR = "jar";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(alias="remoteRepositories", defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    protected BuildPluginManager buildPluginManager;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected LifecycleExecutor lifecycleExecutor;
    @Component
    protected ScmManager scmManager;
    @Parameter
    protected Archive archive;
    @Parameter(alias="verticle", property="vertx.verticle")
    protected String verticle;
    @Parameter(defaultValue="io.vertx.core.Launcher", property="vertx.launcher")
    protected String launcher;
    @Parameter(property="vertx.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(alias="skipScmMetadata", property="vertx.skipScmMetadata", defaultValue="false")
    protected boolean skipScmMetadata;
    protected PlexusContainer container;

    public MavenProject getProject() {
        return this.project;
    }

    protected Optional<File> resolveArtifact(String artifact) {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)new DefaultArtifact(artifact));
        try {
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, artifactRequest);
            if (artifactResult.isResolved()) {
                this.getLog().debug((CharSequence)("Resolved :" + artifactResult.getArtifact().getArtifactId()));
                return Optional.of(artifactResult.getArtifact().getFile());
            }
            this.getLog().error((CharSequence)("Unable to resolve:" + artifact));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)("Unable to resolve:" + artifact));
        }
        return Optional.empty();
    }

    protected Set<Optional<File>> extractArtifactPaths(Set<org.apache.maven.artifact.Artifact> artifacts) {
        return artifacts.stream().filter(e -> e.getScope().equals("compile") || e.getScope().equals("runtime")).filter(e -> e.getType().equalsIgnoreCase("jar")).filter(e -> !WebJars.isWebJar(this.getLog(), e.getFile())).map(this::asMavenCoordinates).distinct().map(this::resolveArtifact).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected String asMavenCoordinates(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder artifactCords = new StringBuilder().append(artifact.getGroupId()).append(":").append(artifact.getArtifactId());
        if (!"jar".equals(artifact.getType()) || artifact.hasClassifier()) {
            artifactCords.append(":").append(artifact.getType());
        }
        if (artifact.hasClassifier()) {
            artifactCords.append(":").append(artifact.getClassifier());
        }
        artifactCords.append(":").append(artifact.getVersion());
        return artifactCords.toString();
    }

    protected Optional<File> getArtifactFile(org.apache.maven.artifact.Artifact artifact) {
        String finalName = this.project.getName();
        if (artifact == null) {
            Path finalNameArtifact = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
            if (Files.exists(finalNameArtifact, new LinkOption[0])) {
                return Optional.of(finalNameArtifact.toFile());
            }
        } else {
            return Optional.ofNullable(artifact.getFile());
        }
        return Optional.empty();
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public ScmManager getScmManager() {
        return this.scmManager;
    }

    protected Archive computeArchive() throws MojoExecutionException {
        if (this.archive == null) {
            this.archive = ServiceUtils.getDefaultFatJar();
        }
        if (this.archive.getDependencySets().isEmpty()) {
            this.archive.addDependencySet(DependencySet.ALL);
        }
        if (this.launcher != null && !this.launcher.trim().isEmpty()) {
            this.archive.getManifest().putIfAbsent("Main-Class", this.launcher);
        }
        if (this.verticle != null && !this.verticle.trim().isEmpty()) {
            this.archive.getManifest().putIfAbsent("Main-Verticle", this.verticle);
        }
        List<ManifestCustomizerService> customizers = this.getManifestCustomizers();
        customizers.forEach(customizer -> this.archive.getManifest().putAll(customizer.getEntries(this, this.project)));
        if (this.archive.getFileCombinationPatterns().isEmpty()) {
            this.archive.addFileCombinationPattern("META-INF/services/*");
            this.archive.addFileCombinationPattern("META-INF/spring.*");
        }
        return this.archive;
    }

    private List<ManifestCustomizerService> getManifestCustomizers() throws MojoExecutionException {
        List customizers;
        try {
            customizers = this.container.lookupList(ManifestCustomizerService.class);
        }
        catch (ComponentLookupException e) {
            this.getLog().debug((CharSequence)"ManifestCustomerService lookup failed", (Throwable)e);
            throw new MojoExecutionException("Unable to retrieve the " + ManifestCustomizerService.class.getName() + " components");
        }
        return customizers;
    }

    public boolean skipScmMetadata() {
        return this.skipScmMetadata;
    }
}

