/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import io.reactiverse.vertx.maven.plugin.utils.ExecUtils;
import io.reactiverse.vertx.maven.plugin.utils.StreamToLogConsumer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamPumper;

public class JavaProcessExecutor {
    private List<String> argsList = new ArrayList<String>();
    private Log logger;
    private boolean waitFor = true;
    private File workingDirectory;
    protected List<String> jvmArgs;
    private final File java = this.findJava();
    private Collection<URL> classPathUrls;

    public Process execute() throws Exception {
        Commandline commandLine = this.buildCommandLine();
        Process process = null;
        try {
            this.logger.debug((CharSequence)("Executing command :" + commandLine));
            Process reference = process = commandLine.execute();
            Thread watchdog = new Thread(() -> {
                if (reference != null && reference.isAlive()) {
                    reference.destroy();
                }
            });
            Runtime.getRuntime().addShutdownHook(watchdog);
            if (this.waitFor) {
                this.redirectOutput(process, this.logger);
                process.waitFor();
                if (!process.isAlive()) {
                    Runtime.getRuntime().removeShutdownHook(watchdog);
                }
            }
            return process;
        }
        catch (InterruptedException e) {
            if (process.isAlive()) {
                process.destroy();
            }
            Thread.currentThread().interrupt();
            return process;
        }
        catch (Exception e) {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            throw new Exception("Error running java command : " + e.getMessage(), e);
        }
    }

    private Commandline buildCommandLine() throws Exception {
        Commandline cli = new Commandline();
        cli.getShell().setQuotedArgumentsEnabled(false);
        cli.setExecutable(this.java.getAbsolutePath());
        cli.setWorkingDirectory(this.workingDirectory);
        this.addClasspath(this.argsList);
        this.argsLine(cli);
        return cli;
    }

    private void argsLine(Commandline commandline) {
        if (this.jvmArgs == null) {
            return;
        }
        ArrayList<String> full = new ArrayList<String>(this.jvmArgs);
        full.addAll(this.argsList);
        full.forEach(arg -> {
            Arg cliArg = commandline.createArg();
            cliArg.setValue(arg);
        });
    }

    public JavaProcessExecutor withArgs(List<String> argsList) {
        this.argsList = argsList;
        return this;
    }

    public JavaProcessExecutor withLogger(Log logger) {
        this.logger = logger;
        return this;
    }

    public JavaProcessExecutor withClassPath(Collection<URL> classPathUrls) {
        this.classPathUrls = classPathUrls;
        return this;
    }

    public JavaProcessExecutor withWaitFor(boolean waitFor) {
        this.waitFor = waitFor;
        return this;
    }

    public JavaProcessExecutor withJvmOpts(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs == null ? Collections.emptyList() : jvmArgs;
        return this;
    }

    public JavaProcessExecutor withWorkDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("The working directory " + directory.getAbsolutePath() + " is not a directory");
        }
        this.workingDirectory = directory;
        return this;
    }

    private void redirectOutput(Process process, Log logger) {
        StreamToLogConsumer logConsumer = arg_0 -> ((Log)logger).info(arg_0);
        StreamPumper outPumper = new StreamPumper(process.getInputStream(), (StreamConsumer)logConsumer);
        StreamPumper errPumper = new StreamPumper(process.getErrorStream(), (StreamConsumer)logConsumer);
        outPumper.setPriority(2);
        errPumper.setPriority(2);
        outPumper.start();
        errPumper.start();
    }

    private void addClasspath(List<String> argsList) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.classPathUrls) {
                classpath = classpath.append(classpath.length() > 0 ? File.pathSeparator : "").append(new File(ele.toURI()));
            }
            String oldClasspath = System.getProperty("java.class.path");
            if (oldClasspath != null) {
                classpath.append(File.pathSeparator);
                classpath.append(oldClasspath);
            }
            argsList.add(0, "-cp");
            argsList.add(1, classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    private File findJava() {
        File found;
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            found = ExecUtils.findExecutableInSystemPath("java");
        } else {
            File bin = new File(javaHome, "bin");
            found = ExecUtils.find("java", bin);
        }
        if (found == null || !found.isFile()) {
            throw new IllegalStateException("Unable to find the java executable in JAVA_HOME or in the system path");
        }
        return found;
    }
}

