/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;

public class OperatorOnBackpressureBlock<T>
implements Observable.Operator<T, T> {
    final int max;

    public OperatorOnBackpressureBlock(int max) {
        this.max = max;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        BlockingSubscriber<T> s = new BlockingSubscriber<T>(this.max, child);
        s.init();
        return s;
    }

    static final class BlockingSubscriber<T>
    extends Subscriber<T> {
        final NotificationLite<T> nl = NotificationLite.instance();
        final BlockingQueue<Object> queue;
        final Subscriber<? super T> child;
        long requestedCount;
        boolean emitting;
        volatile boolean terminated;
        Throwable exception;

        public BlockingSubscriber(int max, Subscriber<? super T> child) {
            this.queue = new ArrayBlockingQueue<Object>(max);
            this.child = child;
        }

        void init() {
            this.child.add(this);
            this.child.setProducer(new Producer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void request(long n) {
                    BlockingSubscriber blockingSubscriber = BlockingSubscriber.this;
                    synchronized (blockingSubscriber) {
                        BlockingSubscriber.this.requestedCount = n == Long.MAX_VALUE || BlockingSubscriber.this.requestedCount == Long.MAX_VALUE ? Long.MAX_VALUE : (BlockingSubscriber.this.requestedCount += n);
                    }
                    BlockingSubscriber.this.drain();
                }
            });
        }

        @Override
        public void onNext(T t) {
            block2: {
                try {
                    this.queue.put(this.nl.next(t));
                    this.drain();
                }
                catch (InterruptedException ex) {
                    if (this.isUnsubscribed()) break block2;
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.terminated) {
                this.exception = e;
                this.terminated = true;
                this.drain();
            }
        }

        @Override
        public void onCompleted() {
            this.terminated = true;
            this.drain();
        }

        /*
         * Exception decompiling
         */
        void drain() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

