/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

final class LocalDuplexConnection
implements DuplexConnection {
    private final Flux<Frame> in;
    private final MonoProcessor<Void> onClose;
    private final Subscriber<Frame> out;

    LocalDuplexConnection(Flux<Frame> in, Subscriber<Frame> out, MonoProcessor<Void> onClose) {
        this.in = Objects.requireNonNull(in, "in must not be null");
        this.out = Objects.requireNonNull(out, "out must not be null");
        this.onClose = Objects.requireNonNull(onClose, "onClose must not be null");
    }

    public void dispose() {
        this.out.onComplete();
        this.onClose.onComplete();
    }

    public boolean isDisposed() {
        return this.onClose.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.onClose;
    }

    public Flux<Frame> receive() {
        return this.in;
    }

    public Mono<Void> send(Publisher<Frame> frames) {
        Objects.requireNonNull(frames, "frames must not be null");
        return Flux.from(frames).doOnNext(arg_0 -> this.out.onNext(arg_0)).then();
    }
}

