/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.TransportHeaderAware;
import io.rsocket.transport.netty.server.NettyContextCloseable;
import io.rsocket.transport.netty.server.WebsocketRouteTransport;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.http.server.HttpServerResponse;

public class WebsocketServerTransport
implements ServerTransport<NettyContextCloseable>,
TransportHeaderAware {
    HttpServer server;
    private Supplier<Map<String, String>> transportHeaders = Collections::emptyMap;

    private WebsocketServerTransport(HttpServer server) {
        this.server = server;
    }

    public static WebsocketServerTransport create(String bindAddress, int port) {
        HttpServer httpServer = HttpServer.create((String)bindAddress, (int)port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(int port) {
        HttpServer httpServer = HttpServer.create((int)port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(HttpServer server) {
        return new WebsocketServerTransport(server);
    }

    public Mono<NettyContextCloseable> start(ServerTransport.ConnectionAcceptor acceptor) {
        return this.server.newHandler((request, response) -> {
            this.transportHeaders.get().forEach((arg_0, arg_1) -> ((HttpServerResponse)response).addHeader(arg_0, arg_1));
            return response.sendWebsocket(WebsocketRouteTransport.newHandler(acceptor));
        }).map(NettyContextCloseable::new);
    }

    public void setTransportHeaders(Supplier<Map<String, String>> transportHeaders) {
        this.transportHeaders = transportHeaders;
    }
}

