/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.auth.BasicAuthDefinition;
import io.serverlessworkflow.api.auth.BearerAuthDefinition;
import io.serverlessworkflow.api.auth.OauthDefinition;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "scheme", "basicauth", "bearerauth", "oauth"})
public class AuthDefinition
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Unique auth definition name")
    @Size(min=1)
    private @Size(min=1) String name;
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="Defines the auth type")
    private Scheme scheme = Scheme.fromValue("basic");
    @JsonProperty(value="basicauth")
    @Valid
    private BasicAuthDefinition basicauth;
    @JsonProperty(value="bearerauth")
    @Valid
    private BearerAuthDefinition bearerauth;
    @JsonProperty(value="oauth")
    @Valid
    private OauthDefinition oauth;
    private static final long serialVersionUID = -4911386589870110559L;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public AuthDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="scheme")
    public Scheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public AuthDefinition withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="basicauth")
    public BasicAuthDefinition getBasicauth() {
        return this.basicauth;
    }

    @JsonProperty(value="basicauth")
    public void setBasicauth(BasicAuthDefinition basicauth) {
        this.basicauth = basicauth;
    }

    public AuthDefinition withBasicauth(BasicAuthDefinition basicauth) {
        this.basicauth = basicauth;
        return this;
    }

    @JsonProperty(value="bearerauth")
    public BearerAuthDefinition getBearerauth() {
        return this.bearerauth;
    }

    @JsonProperty(value="bearerauth")
    public void setBearerauth(BearerAuthDefinition bearerauth) {
        this.bearerauth = bearerauth;
    }

    public AuthDefinition withBearerauth(BearerAuthDefinition bearerauth) {
        this.bearerauth = bearerauth;
        return this;
    }

    @JsonProperty(value="oauth")
    public OauthDefinition getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="oauth")
    public void setOauth(OauthDefinition oauth) {
        this.oauth = oauth;
    }

    public AuthDefinition withOauth(OauthDefinition oauth) {
        this.oauth = oauth;
        return this;
    }

    public static enum Scheme {
        BASIC("basic"),
        BEARER("bearer"),
        OAUTH_2("oauth2");

        private final String value;
        private static final Map<String, Scheme> CONSTANTS;

        private Scheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Scheme fromValue(String value) {
            Scheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Scheme>();
            for (Scheme c : Scheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

