/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleDeclaration;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.SelectorMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSStylableElement
extends DOMElement
implements CSSElement {
    private static final long serialVersionUID = 3L;
    private SelectorMatcher selectorMatcher = null;
    private Map<String, DOM4JCSSStyleDeclaration> overrideStyleSet = null;

    public CSSStylableElement(String name) {
        super(name);
    }

    public CSSStylableElement(QName qname) {
        super(qname);
    }

    public CSSStylableElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    public CSSDocument getOwnerDocument() {
        return (CSSDocument)super.getDocument();
    }

    public String getId() {
        String id = this.attributeValue("id");
        if (id == null) {
            id = this.attributeValue("ID");
        }
        return id != null ? id : "";
    }

    protected String elementID(Element element) {
        String idAttr = element.attributeValue("id");
        if (idAttr == null) {
            idAttr = element.attributeValue("ID");
        }
        return idAttr;
    }

    public void setAttribute(String name, String value) throws DOMException {
        if ("id".equals(name) && !this.hasAttribute("id") && this.hasAttribute("ID")) {
            name = "ID";
        }
        super.setAttribute(name, value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if ("id".equals(qualifiedName) && !this.hasAttributeNS(namespaceURI, "id") && this.hasAttributeNS(namespaceURI, "ID")) {
            qualifiedName = "ID";
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    protected String inlineStyle() {
        String style = this.attributeValue("style");
        if (style == null) {
            style = this.attributeValue("STYLE");
        }
        return style;
    }

    public CSSStyleDeclaration getStyle() {
        DOM4JCSSStyleDeclaration styledecl = new DOM4JCSSStyleDeclaration();
        styledecl.setOwnerNode((org.w3c.dom.Node)((Object)this));
        String st = this.inlineStyle();
        if (st != null && st.length() > 0) {
            try {
                styledecl.setCssText(st);
            }
            catch (DOMException e) {
                ((XHTMLDocumentFactory)this.getDocumentFactory()).getStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
            }
        }
        return styledecl;
    }

    boolean hasOverrideStyle(String pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
        DOM4JCSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<String, DOM4JCSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = new DOM4JCSSStyleDeclaration();
            overrideStyle.setOwnerNode((org.w3c.dom.Node)((Object)this));
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    public CSSStyleDeclaration getComputedStyle(String pseudoElt) {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            DOM4JCSSStyleDeclaration styledecl = (DOM4JCSSStyleDeclaration)css.getComputedStyle((CSSElement)this, pseudoElt);
            return styledecl;
        }
        return null;
    }

    public CSSComputedProperties getComputedStyle() {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            CSSComputedProperties styledecl = css.getComputedStyle((CSSElement)this, null);
            return styledecl;
        }
        return null;
    }

    public SelectorMatcher getSelectorMatcher() {
        if (this.selectorMatcher == null) {
            this.selectorMatcher = new DOM4JSelectorMatcher();
        }
        return this.selectorMatcher;
    }

    class DOM4JSelectorMatcher
    extends SelectorMatcher {
        private String idAttr = null;

        DOM4JSelectorMatcher() {
            String classAttr;
            this.setTagname(CSSStylableElement.this.getName().toLowerCase(Locale.US).intern());
            Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                this.setParentTagname(parent.getName().toLowerCase(Locale.US).intern());
            }
            if ((classAttr = CSSStylableElement.this.attributeValue("class")) == null) {
                classAttr = CSSStylableElement.this.attributeValue("CLASS");
            }
            classAttr = classAttr != null ? classAttr.toLowerCase(Locale.US) : "";
            this.setClassAttribute(classAttr);
            this.idAttr = CSSStylableElement.this.getId();
        }

        public SelectorMatcher getParentSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent instanceof CSSStylableElement) {
                return ((CSSStylableElement)parent).getSelectorMatcher();
            }
            return null;
        }

        public SelectorMatcher getPreviousSiblingSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return null;
            }
            List elements = parent.elements();
            Object sibling = elements.get(elements.indexOf((Object)CSSStylableElement.this) - 1);
            if (sibling instanceof CSSStylableElement) {
                return ((CSSStylableElement)((Object)sibling)).getSelectorMatcher();
            }
            return null;
        }

        public boolean isFirstChild() {
            return CSSStylableElement.this.getParent().indexOf((Node)CSSStylableElement.this) == 0;
        }

        public String getAttributeValue(String attrName) {
            String value = CSSStylableElement.this.attributeValue(attrName);
            return value != null ? value : "";
        }

        public boolean hasAttribute(String attrName) {
            return CSSStylableElement.this.attribute(attrName) != null;
        }

        public String getId() {
            return this.idAttr;
        }

        public String getLanguage() {
            String lang = CSSStylableElement.this.attributeValue("lang");
            if (lang == null) {
                lang = CSSStylableElement.this.attributeValue("LANG");
            }
            CSSStylableElement parent = CSSStylableElement.this;
            while ((lang == null || lang.length() == 0) && (parent = parent.getParent()) != null) {
                lang = parent.attributeValue("lang");
                if (lang != null) continue;
                lang = CSSStylableElement.this.attributeValue("LANG");
            }
            if (lang == null) {
                lang = "";
            }
            return lang;
        }
    }
}

