/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.CSSRuleArrayList;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import java.util.Iterator;
import org.w3c.dom.css.CSSRule;

public abstract class DOM4JCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    CSSElement ownerElement;

    public DOM4JCSSStyleSheet(String title, CSSElement ownerElement, DOMMediaList media, CSSRule ownerRule, short origin) {
        super(title, media, ownerRule, origin);
        this.ownerElement = ownerElement;
    }

    public String getHref() {
        String href = super.getHref();
        if (href == null) {
            return this.ownerElement.getOwnerDocument().getBaseURL().toExternalForm();
        }
        return href;
    }

    public CSSElement getOwnerNode() {
        return this.ownerElement;
    }

    protected String getTargetMedium() {
        if (this.ownerElement != null) {
            return this.ownerElement.getOwnerDocument().getStyleSheet().getTargetMedium();
        }
        return null;
    }

    public DOM4JCSSStyleSheet clone() {
        DOM4JCSSStyleSheet myClone = ((XHTMLDocumentFactory.DOM4JCSSStyleSheetFactory)this.getStyleSheetFactory()).createCSSStyleSheet(this.getTitle(), this.getOwnerNode(), this.getMedia(), this.getOwnerRule(), this.getOrigin());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone((AbstractCSSStyleSheet)myClone, i++));
        }
        return myClone;
    }
}

