/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import org.dom4j.QName;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.css.CSSStyleSheet;

class LinkElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    LinkElement(String name) {
        super(name);
    }

    LinkElement(QName qname) {
        super(qname);
    }

    LinkElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public DOM4JCSSStyleSheet getSheet() {
        if (this.linkedSheet == null) {
            String type = this.attributeValue("type");
            if (!"text/css".equals(type)) {
                return null;
            }
            String rel = this.attributeValue("rel");
            if (rel != null) {
                String href;
                String title = this.attributeValue("title");
                if (rel.equalsIgnoreCase("stylesheet")) {
                    String href2 = this.attributeValue("href");
                    if (href2 != null) {
                        this.loadStyleSheet(href2, title);
                    }
                } else if (rel.equalsIgnoreCase("alternate stylesheet") && (href = this.attributeValue("href")) != null) {
                    this.loadStyleSheet(href, title);
                    if (this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                }
            }
        }
        return this.linkedSheet;
    }

    private void loadStyleSheet(String href, String title) {
        String media = this.attributeValue("media");
        DOMMediaList mediaList = media == null || media.trim().length() == 0 ? DOMMediaList.create() : DOMMediaList.create((String)media);
        DOM4JCSSStyleSheet sheet = this.getDocumentFactory().getStyleSheetFactory().createLinkedStyleSheet(this, title, mediaList);
        try {
            sheet.loadStyleSheet(this.getOwnerDocument().getURL(href));
            this.linkedSheet = sheet;
        }
        catch (CSSException e) {
            this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)((Object)e), (CSSStyleSheet)((Object)sheet));
        }
        catch (IOException e) {
            this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)e, (CSSStyleSheet)((Object)sheet));
        }
    }
}

