/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleDeclaration;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.om.AbstractSelectorMatcher;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class CSSStylableElement
extends DOMElement
implements CSSElement {
    private static final long serialVersionUID = 7L;
    private SelectorMatcher selectorMatcher = null;
    private Map<String, CSSStyleDeclaration> overrideStyleSet = null;

    protected CSSStylableElement(String name) {
        super(name);
    }

    protected CSSStylableElement(QName qname) {
        super(qname);
    }

    protected CSSStylableElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    public XHTMLDocument getOwnerDocument() {
        return (XHTMLDocument)super.getDocument();
    }

    public XHTMLDocument getDocument() {
        return (XHTMLDocument)super.getDocument();
    }

    protected XHTMLDocumentFactory getDocumentFactory() {
        return (XHTMLDocumentFactory)super.getDocumentFactory();
    }

    public String getBaseURI() {
        URL baseURL = this.getOwnerDocument().getBaseURL();
        if (baseURL != null) {
            return baseURL.toExternalForm();
        }
        return null;
    }

    public abstract String getId();

    protected String elementID(Element element) {
        String idAttr = element.attributeValue("id");
        if (idAttr == null) {
            idAttr = element.attributeValue("ID");
        }
        return idAttr;
    }

    public void setAttribute(String name, String value) throws DOMException {
        if ("id".equals(name) && !this.hasAttribute("id") && this.hasAttribute("ID")) {
            name = "ID";
        }
        super.setAttribute(name, value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if ("id".equals(qualifiedName) && !this.hasAttributeNS(namespaceURI, "id") && this.hasAttributeNS(namespaceURI, "ID")) {
            qualifiedName = "ID";
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    protected String inlineStyle() {
        String style = this.attributeValue("style");
        if (style == null) {
            style = this.attributeValue("STYLE");
        }
        return style;
    }

    public CSSStyleDeclaration getStyle() {
        InlineStyle styledecl = this.getDocumentFactory().getStyleSheetFactory().createInlineStyle((Node)((Object)this));
        String st = this.inlineStyle();
        if (st != null && st.length() > 0) {
            try {
                styledecl.setCssText(st);
            }
            catch (DOMException e) {
                this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
            }
        }
        return styledecl;
    }

    public boolean hasPresentationalHints() {
        return false;
    }

    public void exportHintsToStyle(CSSStyleDeclaration style) {
    }

    boolean hasOverrideStyle(String pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
        CSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<String, CSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = this.getDocumentFactory().getStyleSheetFactory().createInlineStyle((Node)((Object)this));
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    public ComputedCSSStyle getComputedStyle(String pseudoElt) {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            DOM4JCSSStyleDeclaration styledecl = (DOM4JCSSStyleDeclaration)css.getComputedStyle((CSSElement)this, pseudoElt);
            return styledecl;
        }
        return null;
    }

    public ComputedCSSStyle getComputedStyle() {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            ComputedCSSStyle styledecl = (ComputedCSSStyle)css.getComputedStyle((CSSElement)this, null);
            return styledecl;
        }
        return null;
    }

    public SelectorMatcher getSelectorMatcher() {
        if (this.selectorMatcher == null) {
            this.selectorMatcher = new DOM4JSelectorMatcher();
        }
        return this.selectorMatcher;
    }

    public boolean matches(String selectorString, String pseudoElement) throws DOMException {
        SelectorList list;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectorString));
        try {
            list = parser.parseSelectors(source);
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectorString);
        }
        return this.matches(list, pseudoElement);
    }

    public boolean matches(SelectorList selist, String pseudoElement) {
        SelectorMatcher matcher = this.getSelectorMatcher();
        matcher.setPseudoElement(pseudoElement);
        return matcher.matches(selist) != -1;
    }

    class DOM4JSelectorMatcher
    extends AbstractSelectorMatcher {
        DOM4JSelectorMatcher() {
            this.setLocalName(CSSStylableElement.this.getName().toLowerCase(Locale.US).intern());
        }

        protected AbstractSelectorMatcher getParentSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent instanceof CSSStylableElement) {
                return (AbstractSelectorMatcher)((CSSStylableElement)parent).getSelectorMatcher();
            }
            return null;
        }

        protected AbstractSelectorMatcher getPreviousSiblingSelectorMatcher() {
            Object sibling;
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return null;
            }
            List elements = parent.elements();
            int sibindex = elements.indexOf((Object)CSSStylableElement.this) - 1;
            if (sibindex != -1 && (sibling = elements.get(sibindex)) instanceof CSSStylableElement) {
                return (AbstractSelectorMatcher)((CSSStylableElement)((Object)sibling)).getSelectorMatcher();
            }
            return null;
        }

        protected int indexOf(SelectorList selectors) {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return 1;
            }
            NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
            int sz = list.getLength();
            int idx = 0;
            for (int i = 0; i < sz; ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (CSSStylableElement)((Object)node))) continue;
                ++idx;
                if (node == CSSStylableElement.this) break;
            }
            return idx == sz ? -1 : idx;
        }

        protected int reverseIndexOf(SelectorList selectors) {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return 1;
            }
            NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
            int sz = list.getLength();
            int idx = 0;
            for (int i = sz - 1; i >= 0; --i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (CSSStylableElement)((Object)node))) continue;
                ++idx;
                if (node == CSSStylableElement.this) break;
            }
            return idx;
        }

        private boolean matchSelectors(SelectorList selectors, CSSStylableElement node) {
            if (selectors == null) {
                return true;
            }
            int sz = selectors.getLength();
            for (int i = 0; i < sz; ++i) {
                if (!node.getSelectorMatcher().matches(selectors.item(i))) continue;
                return true;
            }
            return false;
        }

        protected boolean isActivePseudoClass(String pseudoclassName) {
            CSSCanvas canvas;
            XHTMLDocument doc = CSSStylableElement.this.getOwnerDocument();
            if (doc != null && (canvas = doc.getCanvas()) != null) {
                return canvas.isActivePseudoClass((CSSElement)CSSStylableElement.this, pseudoclassName);
            }
            return false;
        }

        protected boolean isFirstChild() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return true;
            }
            return parent.elements().indexOf((Object)CSSStylableElement.this) == 0;
        }

        protected boolean isLastChild() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return true;
            }
            List elems = parent.elements();
            return elems.indexOf((Object)CSSStylableElement.this) == elems.size() - 1;
        }

        protected boolean isFirstOfType() {
            for (Node sibling = CSSStylableElement.this.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
                if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
                return false;
            }
            return true;
        }

        protected boolean isLastOfType() {
            for (Node sibling = CSSStylableElement.this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
                return false;
            }
            return true;
        }

        protected boolean isNthOfType(int step, int offset) {
            int idx = 0;
            Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
                    ++idx;
                    if (node != CSSStylableElement.this) {
                        continue;
                    }
                    break;
                }
            } else {
                idx = 1;
            }
            return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
        }

        protected boolean isNthLastOfType(int step, int offset) {
            int idx = 0;
            Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
                int sz = list.getLength();
                for (int i = sz - 1; i >= 0; --i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
                    ++idx;
                    if (node != CSSStylableElement.this) {
                        continue;
                    }
                    break;
                }
            } else {
                idx = 1;
            }
            return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
        }

        protected boolean isNotVisitedLink() {
            String href = CSSStylableElement.this.getAttribute("href");
            if (href != null && href.length() != 0) {
                return !CSSStylableElement.this.getOwnerDocument().isVisitedURI(href);
            }
            return false;
        }

        protected boolean isVisitedLink() {
            String href = CSSStylableElement.this.getAttribute("href");
            if (href != null && href.length() != 0) {
                return CSSStylableElement.this.getOwnerDocument().isVisitedURI(href);
            }
            return false;
        }

        protected boolean isTarget() {
            return false;
        }

        protected boolean isRoot() {
            return CSSStylableElement.this.getOwnerDocument().getDocumentElement() == CSSStylableElement.this;
        }

        protected boolean isEmpty() {
            if (CSSStylableElement.this.hasChildNodes()) {
                NodeList list = CSSStylableElement.this.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    String value;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1) {
                        return false;
                    }
                    if (!(type == 3 ? (value = node.getNodeValue()) != null && value.length() > 0 : type == 5 && node.hasChildNodes())) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean isBlank() {
            if (CSSStylableElement.this.hasChildNodes()) {
                NodeList list = CSSStylableElement.this.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    String value;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1) {
                        return false;
                    }
                    if (!(type == 3 ? (value = node.getNodeValue()) != null && value.trim().length() > 0 : type == 5 && node.hasChildNodes())) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean isDisabled() {
            if (this.hasAttribute("disabled")) {
                return true;
            }
            Element parent = CSSStylableElement.this.getParent();
            if (parent != null && "fieldset".equalsIgnoreCase(parent.getName()) && !"legend".equals(this.getLocalName())) {
                return parent.attribute("disabled") != null;
            }
            return false;
        }

        protected boolean isDefaultButton() {
            CSSStylableElement parent = (CSSStylableElement)CSSStylableElement.this.getParent();
            if (parent == null) {
                return false;
            }
            while (parent != null && !"form".equals(parent.getTagName())) {
                parent = (CSSStylableElement)parent.getParent();
            }
            String formid = parent == null ? null : parent.getId();
            Node sibling = CSSStylableElement.this.getPreviousSibling();
            while (sibling != null) {
                if (sibling.getNodeType() != 1) continue;
                CSSStylableElement element = (CSSStylableElement)((Object)sibling);
                if (!this.defaultButtonCheck(element, formid)) {
                    return false;
                }
                if (element.hasChildNodes()) {
                    NodeList list = element.getChildNodes();
                    int sz = list.getLength();
                    for (int i = 0; i < sz; ++i) {
                        Node node = list.item(i);
                        if (node.getNodeType() != 1 || this.defaultButtonCheck((CSSStylableElement)((Object)node), formid)) continue;
                        return false;
                    }
                }
                sibling = sibling.getPreviousSibling();
            }
            return true;
        }

        private boolean defaultButtonCheck(CSSElement element, String formid) {
            String type;
            String tagname;
            String form;
            return element.hasAttribute("disabled") || (form = element.getAttribute("form")) != null && !form.equals(formid) || !((tagname = element.getTagName().toLowerCase(Locale.US)).equals("input") ? "submit".equals(type = element.getAttribute("type")) || "image".equals(type) : tagname.equals("button") && "submit".equals(element.getAttribute("type")));
        }

        protected String getNamespaceURI() {
            return CSSStylableElement.this.getNamespaceURI();
        }

        protected String getAttributeValue(String attrName) {
            String value = CSSStylableElement.this.attributeValue(attrName);
            return value != null ? value : "";
        }

        protected boolean hasAttribute(String attrName) {
            return CSSStylableElement.this.attribute(attrName) != null;
        }

        protected String getId() {
            return CSSStylableElement.this.getId();
        }

        protected String getLanguage() {
            String lang = CSSStylableElement.this.attributeValue("lang");
            if (lang == null) {
                lang = CSSStylableElement.this.attributeValue("LANG");
            }
            CSSStylableElement parent = CSSStylableElement.this;
            while ((lang == null || lang.length() == 0) && (parent = parent.getParent()) != null) {
                lang = parent.attributeValue("lang");
                if (lang != null) continue;
                lang = CSSStylableElement.this.attributeValue("LANG");
            }
            if (lang == null) {
                lang = "";
            }
            return lang;
        }

        protected boolean scopeMatchChild(DescendantSelector selector) {
            SimpleSelector desc = selector.getSimpleSelector();
            NodeList list = CSSStylableElement.this.getChildNodes();
            int sz = list.getLength();
            for (int i = 0; i < sz; ++i) {
                SelectorMatcher childSM;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !(childSM = ((CSSStylableElement)((Object)node)).getSelectorMatcher()).matches((Selector)desc)) continue;
                return true;
            }
            return false;
        }

        protected boolean scopeMatchDirectAdjacent(SiblingSelector selector) {
            SelectorMatcher siblingSM = null;
            for (Node sibling = CSSStylableElement.this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getNodeType() != 1) continue;
                siblingSM = ((CSSStylableElement)((Object)sibling)).getSelectorMatcher();
                break;
            }
            if (siblingSM != null) {
                return siblingSM.matches((Selector)selector.getSiblingSelector());
            }
            return false;
        }
    }
}

