/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.DocumentException;
import io.sf.carte.doc.agent.AbstractUserAgent;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XPP3Reader;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xmlpull.v1.XmlPullParserException;

public class DOM4JUserAgent
extends AbstractUserAgent {
    protected EntityResolver resolver = this.createEntityResolver();
    private boolean useXPP3;
    private XHTMLDocumentFactory factory;

    protected DOM4JUserAgent() {
        this(false);
    }

    protected DOM4JUserAgent(boolean useXPP3) {
        this.useXPP3 = useXPP3;
        this.factory = new AgentXHTMLDocumentFactory();
    }

    public static AbstractUserAgent createUserAgent(boolean useXPP3) {
        return new DOM4JUserAgent(useXPP3);
    }

    protected EntityResolver createEntityResolver() {
        return new DefaultEntityResolver();
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public XHTMLDocument readURL(URL url) throws IOException, DocumentException {
        String referrerPolicy;
        long time = System.currentTimeMillis();
        URLConnection con = this.openConnection(url, time);
        con.connect();
        String conType = con.getContentType();
        InputStream is = null;
        AgentXHTMLDocumentFactory.AgentXHTMLDocument xdoc = null;
        try {
            is = this.openInputStream(con);
            xdoc = this.parseDocument(this.inputStreamToReader(is, conType));
            xdoc.setLoadingTime(time);
            if (xdoc.getBaseURL() == null) {
                xdoc.setBaseURL(url);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (DocumentException e) {
            throw new DocumentException("Error parsing document " + url.toExternalForm(), e.getCause());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String defStyle = con.getHeaderField("Default-Style");
        NodeList list = xdoc.getElementsByTagName("meta");
        int listL = list.getLength();
        for (int i = listL - 1; i >= 0; --i) {
            String metaDefStyle;
            if (!"Default-Style".equalsIgnoreCase(((DOMElement)list.item(i)).attributeValue("http-equiv")) || (metaDefStyle = ((DOMElement)list.item(i)).attributeValue("content")) == null) continue;
            defStyle = metaDefStyle;
        }
        if (defStyle != null) {
            xdoc.setSelectedStyleSheetSet(defStyle);
        }
        if ((referrerPolicy = con.getHeaderField("Referrer-Policy")) != null) {
            xdoc.setReferrerPolicyHeader(referrerPolicy);
        }
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            this.readCookies(hcon, time);
            hcon.disconnect();
        }
        return xdoc;
    }

    protected InputStream openInputStream(URLConnection con) throws IOException {
        return con.getInputStream();
    }

    protected AgentXHTMLDocumentFactory.AgentXHTMLDocument parseDocument(Reader re) throws DocumentException, IOException {
        try {
            if (this.useXPP3) {
                return this.parseWithXPP3(re);
            }
            return this.parseWithSAX(re);
        }
        catch (org.dom4j.DocumentException e) {
            throw new DocumentException("Error parsing document", (Throwable)e);
        }
    }

    private AgentXHTMLDocumentFactory.AgentXHTMLDocument parseWithSAX(Reader re) throws org.dom4j.DocumentException {
        InputSource isrc = new InputSource(re);
        XHTMLDocumentFactory factory = this.getXHTMLDocumentFactory();
        SAXReader reader = new SAXReader((DocumentFactory)factory);
        reader.setEntityResolver(this.resolver);
        return (AgentXHTMLDocumentFactory.AgentXHTMLDocument)reader.read(isrc);
    }

    private AgentXHTMLDocumentFactory.AgentXHTMLDocument parseWithXPP3(Reader re) throws org.dom4j.DocumentException, IOException {
        XHTMLDocumentFactory factory = this.getXHTMLDocumentFactory();
        XPP3Reader reader = new XPP3Reader((DocumentFactory)factory);
        try {
            return (AgentXHTMLDocumentFactory.AgentXHTMLDocument)reader.read(re);
        }
        catch (XmlPullParserException e) {
            throw new org.dom4j.DocumentException((Throwable)e);
        }
    }

    public XHTMLDocumentFactory getXHTMLDocumentFactory() {
        return this.factory;
    }

    public class AgentXHTMLDocumentFactory
    extends XHTMLDocumentFactory {
        private static final long serialVersionUID = 2L;

        protected AgentXHTMLDocumentFactory() {
        }

        @Override
        public XHTMLDocument createDocument() {
            AgentXHTMLDocument mydoc = new AgentXHTMLDocument();
            mydoc.setDocumentFactory((DocumentFactory)this);
            return mydoc;
        }

        @Override
        public XHTMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType docType) throws DOMException {
            AgentXHTMLDocument document;
            if (docType != null) {
                DOMDocumentType documentType = this.asDocumentType(docType);
                document = new AgentXHTMLDocument(documentType);
            } else {
                document = new AgentXHTMLDocument();
            }
            document.setDocumentFactory((DocumentFactory)this);
            if (qualifiedName != null) {
                document.add((Element)this.createElement(this.createQName(qualifiedName, namespaceURI)));
            }
            return document;
        }

        public class AgentXHTMLDocument
        extends XHTMLDocument {
            private static final long serialVersionUID = 2L;
            private long loadingTime;

            AgentXHTMLDocument() {
            }

            AgentXHTMLDocument(String name) {
                super(name);
            }

            AgentXHTMLDocument(DOMElement rootElement) {
                super(rootElement);
            }

            AgentXHTMLDocument(DOMDocumentType docType) {
                super(docType);
            }

            AgentXHTMLDocument(DOMElement rootElement, DOMDocumentType docType) {
                super(rootElement, docType);
            }

            AgentXHTMLDocument(String name, DOMElement rootElement, DOMDocumentType docType) {
                super(name, rootElement, docType);
            }

            @Override
            public URLConnection openConnection(URL url) throws IOException {
                return DOM4JUserAgent.this.openConnection(url, this.loadingTime);
            }

            @Override
            public boolean isVisitedURI(String href) {
                try {
                    return DOM4JUserAgent.this.isVisitedURL(this.getURL(href));
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }

            public void setLoadingTime(long time) {
                this.loadingTime = time;
            }

            @Override
            protected void setReferrerPolicyHeader(String policy) {
                super.setReferrerPolicyHeader(policy);
            }
        }
    }
}

