/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Element;
import org.dom4j.QName;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleSheet;

class StyleElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    StyleElement(String name) {
        super(name);
    }

    StyleElement(QName qname) {
        super(qname);
    }

    StyleElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public DOM4JCSSStyleSheet getSheet() {
        if (this.needsUpdate) {
            String nsuri = this.getNamespaceURI();
            if (nsuri.length() != 0 && !nsuri.equals("http://www.w3.org/1999/xhtml")) {
                return null;
            }
            String type = this.attributeValue("type");
            if (!"text/css".equals(type)) {
                return null;
            }
            String media = this.attributeValue("media");
            if (this.linkedSheet == null) {
                OMMediaList mediaList;
                if (media == null || media.trim().length() == 0) {
                    mediaList = OMMediaList.createMediaList();
                } else {
                    mediaList = MediaQueryFactory.createMediaList((String)media);
                    if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                        this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                    }
                }
                this.linkedSheet = this.getDocumentFactory().getStyleSheetFactory().createLinkedStyleSheet(this, this.attributeValue("title"), (MediaQueryList)mediaList);
            } else {
                this.linkedSheet.setDestinationMedia(media);
            }
            String styleText = this.getText();
            if (styleText.length() != 0) {
                this.linkedSheet.setHref(this.getBaseURI());
                InputSource source = new InputSource();
                StringReader re = new StringReader(styleText);
                source.setCharacterStream((Reader)re);
                try {
                    this.linkedSheet.parseCSSStyleSheet(source);
                }
                catch (DOMException e) {
                    this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)e, (CSSStyleSheet)((Object)this.linkedSheet));
                }
                catch (IOException e) {
                    this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)e, (CSSStyleSheet)((Object)this.linkedSheet));
                }
            }
            this.needsUpdate = false;
        }
        return this.linkedSheet;
    }

    public Element addText(String text) {
        this.getOwnerDocument().onStyleModify();
        return super.addText(text);
    }
}

