/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.BaseHrefAttribute;
import io.sf.carte.doc.dom4j.BaseURLElement;
import io.sf.carte.doc.dom4j.CSSStylableElement;
import io.sf.carte.doc.dom4j.CachedTableCellElement;
import io.sf.carte.doc.dom4j.CachedTableElement;
import io.sf.carte.doc.dom4j.CachedTableRowElement;
import io.sf.carte.doc.dom4j.CachedXHTMLElement;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleDeclaration;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.DOM4JDocumentCSSStyleSheet;
import io.sf.carte.doc.dom4j.DocumentStyleEventAttribute;
import io.sf.carte.doc.dom4j.FontElement;
import io.sf.carte.doc.dom4j.HeadElement;
import io.sf.carte.doc.dom4j.ImgElement;
import io.sf.carte.doc.dom4j.LinkElement;
import io.sf.carte.doc.dom4j.StyleAttribute;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.dom4j.StyleElement;
import io.sf.carte.doc.dom4j.TableCellElement;
import io.sf.carte.doc.dom4j.TableElement;
import io.sf.carte.doc.dom4j.TableRowElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLElement;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LogErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.IOException;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMDocumentType;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;

public class XHTMLDocumentFactory
extends DOMDocumentFactory {
    private static final long serialVersionUID = 6L;
    private DOM4JDocumentCSSStyleSheet defStyleSheet = null;
    private DOM4JDocumentCSSStyleSheet uaStyleSheet = null;
    private DOM4JCSSStyleSheetFactory cssFactory = null;
    private boolean styleCacheOn = false;
    private CSSStyleSheetFactory.ComplianceMode complianceMode = CSSStyleSheetFactory.ComplianceMode.LENIENT;
    private static transient XHTMLDocumentFactory singleton = new XHTMLDocumentFactory();

    protected XHTMLDocumentFactory() {
    }

    public static XHTMLDocumentFactory getInstance() {
        return singleton;
    }

    public DOM4JCSSStyleSheetFactory getStyleSheetFactory() {
        if (this.cssFactory == null) {
            this.cssFactory = new DOM4JCSSStyleSheetFactory(this.complianceMode);
        }
        return this.cssFactory;
    }

    public void setComplianceMode(CSSStyleSheetFactory.ComplianceMode complianceMode) {
        if (this.cssFactory != null) {
            throw new IllegalStateException("Style sheet factory already has a mode.");
        }
        if (complianceMode != CSSStyleSheetFactory.ComplianceMode.LENIENT && complianceMode != CSSStyleSheetFactory.ComplianceMode.QUIRKS) {
            throw new IllegalArgumentException("Unsupported operaton mode.");
        }
        this.complianceMode = complianceMode;
    }

    public DOM4JDocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            try {
                this.uaStyleSheet = (DOM4JDocumentCSSStyleSheet)this.getStyleSheetFactory().htmlDefaultSheet();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load default User Agent style sheet.", e);
            }
        }
        return this.uaStyleSheet;
    }

    protected DOM4JDocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    public void setUserAgentStyleSheet(DOM4JDocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.getStyleSheetFactory().getUserNormalStyleSheet() != null) {
            this.defStyleSheet.addStyleSheet(this.getStyleSheetFactory().getUserNormalStyleSheet());
        }
    }

    public boolean isStyleCacheOn() {
        return this.styleCacheOn;
    }

    public void setStyleCache(boolean onOff) {
        this.styleCacheOn = onOff;
    }

    public CSSStylableElement createElement(String name) {
        return (CSSStylableElement)super.createElement(name);
    }

    public CSSStylableElement createElement(QName qname) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname);
        }
        if ("img".equals(name)) {
            return new ImgElement(qname);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname);
            }
            return new CachedXHTMLElement(qname);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname);
        }
        if ("table".equals(name)) {
            return new TableElement(qname);
        }
        return new XHTMLElement(qname);
    }

    public CSSStylableElement createElement(QName qname, int attributeCount) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname, attributeCount);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname, attributeCount);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname, attributeCount);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname, attributeCount);
        }
        if ("img".equals(name)) {
            return new ImgElement(qname, attributeCount);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname, attributeCount);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname, attributeCount);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname, attributeCount);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname, attributeCount);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname, attributeCount);
            }
            return new CachedXHTMLElement(qname, attributeCount);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname, attributeCount);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname, attributeCount);
        }
        if ("table".equals(name)) {
            return new TableElement(qname, attributeCount);
        }
        return new XHTMLElement(qname, attributeCount);
    }

    public XHTMLDocument createDocument() {
        XHTMLDocument mydoc = new XHTMLDocument();
        mydoc.setDocumentFactory((DocumentFactory)this);
        return mydoc;
    }

    public XHTMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType docType) throws DOMException {
        XHTMLDocument document;
        if (docType != null) {
            DOMDocumentType documentType = this.asDocumentType(docType);
            document = new XHTMLDocument(documentType);
        } else {
            document = new XHTMLDocument();
        }
        document.setDocumentFactory((DocumentFactory)this);
        if (qualifiedName != null) {
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            document.add((Element)this.createElement(this.createQName(qualifiedName, namespaceURI)));
        }
        return document;
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        if (owner instanceof StyleDefinerElement) {
            return new DocumentStyleEventAttribute(qname, value);
        }
        if (owner instanceof BaseURLElement && qname.getName().equals("href")) {
            return new BaseHrefAttribute(qname, value);
        }
        if (owner instanceof CachedXHTMLElement && qname.getName().equals("style")) {
            return new StyleAttribute(qname, value);
        }
        return super.createAttribute(owner, qname, value);
    }

    public class DOM4JCSSStyleSheetFactory
    extends BaseCSSStyleSheetFactory {
        private ErrorHandler errorHandler;

        DOM4JCSSStyleSheetFactory(CSSStyleSheetFactory.ComplianceMode complianceMode) {
            super(complianceMode);
            this.errorHandler = this.createErrorHandler();
        }

        protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
            return super.getUserImportantStyleSheet();
        }

        protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
            return super.getUserNormalStyleSheet();
        }

        public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node, CSSElement parent) {
            return this.createInlineStyle(node);
        }

        public DOM4JDocumentCSSStyleSheet createDocumentStyleSheet(byte origin) {
            return new MyDOM4JDocumentCSSStyleSheet(null, origin);
        }

        public DOM4JCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, MediaQueryList mediaList) {
            return new MyDOM4JCSSStyleSheet(title, null, mediaList, (CSSRule)ownerRule, ownerRule.getOrigin());
        }

        public DOM4JCSSStyleSheet createLinkedStyleSheet(CSSElement ownerElement, String title, MediaQueryList mediaList) {
            return new MyDOM4JCSSStyleSheet(title, ownerElement, mediaList, null, 8);
        }

        DOM4JCSSStyleSheet createCSSStyleSheet(String title, CSSElement ownerElement, MediaQueryList media, CSSRule ownerRule, byte origin) {
            return new MyDOM4JCSSStyleSheet(title, ownerElement, media, ownerRule, origin);
        }

        DOM4JDocumentCSSStyleSheet createDocumentStyleSheet(String targetMedium, byte origin) {
            return new MyDOM4JDocumentCSSStyleSheet(targetMedium, origin);
        }

        protected InlineStyle createInlineStyle(Node owner) {
            MyInlineStyle style = new MyInlineStyle();
            style.setOwnerNode(owner);
            return style;
        }

        DOM4JCSSStyleDeclaration createComputedStyle() {
            return new MyDOM4JCSSStyleDeclaration();
        }

        public DOM4JDocumentCSSStyleSheet getUserAgentStyleSheet() {
            return XHTMLDocumentFactory.this.getUserAgentStyleSheet();
        }

        protected BaseDocumentCSSStyleSheet getDefaultStyleSheet() {
            return XHTMLDocumentFactory.this.getDefaultStyleSheet();
        }

        public void setDefaultHTMLUserAgentSheet() {
            try {
                XHTMLDocumentFactory.this.setUserAgentStyleSheet((DOM4JDocumentCSSStyleSheet)this.htmlDefaultSheet());
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read the default style sheet", e);
            }
        }

        protected ErrorHandler createErrorHandler() {
            return new LogErrorHandler();
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        class MyDOM4JCSSStyleDeclaration
        extends DOM4JCSSStyleDeclaration {
            public MyDOM4JCSSStyleDeclaration() {
            }

            public MyDOM4JCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
                super(copiedObject);
            }

            protected CSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }

            @Override
            public DOM4JCSSStyleDeclaration clone() {
                MyDOM4JCSSStyleDeclaration styleClone = new MyDOM4JCSSStyleDeclaration((BaseCSSStyleDeclaration)this);
                styleClone.setOwnerNode(this.getOwnerNode());
                return styleClone;
            }
        }

        class MyInlineStyle
        extends InlineStyle {
            public MyInlineStyle() {
            }

            public MyInlineStyle(InlineStyle copiedObject) {
                super(copiedObject);
            }

            protected void setOwnerNode(Node node) {
                super.setOwnerNode(node);
            }

            public boolean hasOverrideStyle(String pseudoElt) {
                Node node = this.getOwnerNode();
                if (node != null) {
                    return ((CSSStylableElement)((Object)node)).hasOverrideStyle(pseudoElt);
                }
                return false;
            }

            protected CSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }

            public InlineStyle clone() {
                MyInlineStyle styleClone = new MyInlineStyle(this);
                styleClone.setOwnerNode(this.getOwnerNode());
                return styleClone;
            }
        }

        private class MyDOM4JCSSStyleSheet
        extends DOM4JCSSStyleSheet {
            public MyDOM4JCSSStyleSheet(String title, CSSElement ownerElement, MediaQueryList media, CSSRule ownerRule, byte origin) {
                super(title, ownerElement, media, ownerRule, origin);
            }

            public BaseCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }
        }

        private class MyDOM4JDocumentCSSStyleSheet
        extends DOM4JDocumentCSSStyleSheet {
            public MyDOM4JDocumentCSSStyleSheet(String targetMedium, byte origin) {
                super(targetMedium, origin);
            }

            @Override
            public DOM4JCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }
        }
    }
}

