/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.HTMLDocument;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class DocumentTypeImpl
extends DOMNode
implements DocumentType {
    String qualifiedName;
    String publicId;
    String systemId;
    HTMLDocument ownerDocument = null;
    DOMNode.MyNamedNodeMap<Entity> entityMap;
    DOMNode.MyNamedNodeMap<Notation> notationMap;

    public DocumentTypeImpl(String qualifiedName, String publicId, String systemId) {
        super((short)10);
        this.qualifiedName = qualifiedName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.entityMap = new DOMNode.MyNamedNodeMap(this, 6);
        this.notationMap = new DOMNode.MyNamedNodeMap(this, 12);
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public NamedNodeMap getNotations() {
        return this.notationMap;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return new DocumentTypeImpl(this.qualifiedName, this.publicId, this.systemId);
    }

    @Override
    public String getBaseURI() {
        HTMLDocument doc = this.getOwnerDocument();
        if (doc != null) {
            return doc.getBaseURI();
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public HTMLDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public NamedNodeMap getEntities() {
        return this.entityMap;
    }

    @Override
    public String getInternalSubset() {
        return null;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    Node cloneNode(HTMLDocument ownerDocument) {
        return ownerDocument.getImplementation().createDocumentType(this.qualifiedName, this.publicId, this.systemId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<!DOCTYPE ").append(this.qualifiedName);
        if (this.publicId != null) {
            buf.append(" PUBLIC \"").append(this.publicId).append('\"');
        }
        if (this.systemId != null) {
            buf.append(" \"").append(this.systemId).append('\"');
        }
        buf.append('>');
        return buf.toString();
    }
}

