/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.NodeStyleDeclaration;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.CSSShorthandValue;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.om.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSInheritedValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.Diff;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class BaseCSSStyleDeclaration
extends AbstractCSSStyleDeclaration
implements CSS2Properties,
Cloneable {
    private BaseCSSDeclarationRule parentRule;
    private HashMap<String, AbstractCSSValue> propValue = null;
    private ArrayList<String> propertyList = null;
    private ArrayList<String> priorities = null;
    private LinkedList<String> shorthandSet = null;
    private StyleDatabase styleDb = null;

    protected BaseCSSStyleDeclaration(BaseCSSDeclarationRule parentRule) {
        this.parentRule = parentRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new LinkedList();
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new LinkedList();
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        this.parentRule = copiedObject.getParentRule();
        this.setProperties(copiedObject);
    }

    void setProperties(BaseCSSStyleDeclaration other) {
        this.priorities = (ArrayList)other.priorities.clone();
        this.propertyList = (ArrayList)other.propertyList.clone();
        this.propValue = (HashMap)other.propValue.clone();
        this.shorthandSet = (LinkedList)other.shorthandSet.clone();
    }

    @Override
    public String getMinifiedCssText() {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandSet);
        int sz = this.propertyList.size();
        int szm1 = sz - 1;
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        block0: for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            AbstractCSSValue cssVal = this.propValue.get(ptyname);
            if (cssVal.getCssValueType() == 1 || cssVal.getCssValueType() == 2) {
                if (cssVal.isSubproperty()) {
                    Iterator it = unusedShorthands.iterator();
                    while (it.hasNext()) {
                        String sh = (String)it.next();
                        if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                        it.remove();
                        CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(sh);
                        sb.append(sh).append(':').append(shval.getCssText());
                        if (shval.isImportant()) {
                            sb.append("!important");
                        }
                        sb.append(';');
                    }
                    continue;
                }
            } else if (cssVal.getCssValueType() == 0) {
                block2: for (String sh : this.shorthandSet) {
                    if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                    if (!unusedShorthands.contains(sh)) continue block0;
                    String[] subpa = pdb.getShorthandSubproperties(sh);
                    for (int j = 0; j < subpa.length; ++j) {
                        if (!ptyname.equals(subpa[j]) && this.propValue.get(subpa[j]).getCssValueType() != 0) break block2;
                    }
                    unusedShorthands.remove(sh);
                    this.appendShorthandMinifiedCssText(sb, sh);
                    continue block0;
                }
            }
            String prio = this.priorities.get(i);
            sb.append(ptyname).append(':').append(this.propValue.get(ptyname).getMinifiedCssText(ptyname).trim());
            if (prio != null && "important".equals(prio)) {
                sb.append("!important");
            }
            if (i == szm1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public String getCssText() {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandSet);
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            short type = cssVal.getCssValueType();
            if ((type == 1 || type == 2 || type == 0) && ((AbstractCSSValue)cssVal).isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                    it.remove();
                    this.appendShorthandCssText(sb, sh);
                }
                continue;
            }
            String prio = this.priorities.get(i);
            sb.append(ptyname).append(':').append(' ').append(this.propValue.get(ptyname).getCssText());
            if (prio != null && "important".equals(prio)) {
                sb.append(" ! important");
            }
            sb.append(';').append(' ');
        }
        return sb.toString();
    }

    private void appendShorthandCssText(StringBuilder sb, String shorthandName) {
        CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthandName);
        sb.append(shorthandName).append(':').append(' ').append(shval.getCssText());
        if (shval.isImportant()) {
            sb.append(" ! important");
        }
        sb.append(';').append(' ');
    }

    private void appendShorthandMinifiedCssText(StringBuilder sb, String shorthandName) {
        CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthandName);
        sb.append(shorthandName).append(':').append(shval.getCssText());
        if (shval.isImportant()) {
            sb.append("!important");
        }
        sb.append(';');
    }

    private StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null) {
            return prule.getStyleDeclarationErrorHandler();
        }
        return null;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        Parser parser = this.createSACParser();
        StyleDeclarationDocumentHandler handler = this.getStyleDeclarationDocumentHandler();
        StyleDeclarationErrorHandler eh = this.getStyleDeclarationErrorHandler();
        if (eh != null) {
            parser.setErrorHandler((ErrorHandler)handler);
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        this.clear();
        handler.setLexicalPropertyListener(this);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
    }

    private Parser createSACParser() throws DOMException {
        return SACParserFactory.createSACParser();
    }

    @Override
    public String getPropertyValue(String propertyName) {
        AbstractCSSValue value = this.getCSSValue(propertyName = this.getCanonicalPropertyName(propertyName));
        if (value != null) {
            if (value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 19) {
                return ((CSSPrimitiveValue)((Object)value)).getStringValue();
            }
            try {
                return value.getCssText();
            }
            catch (StyleDatabaseRequiredException e) {
                e.setValueText(propertyName);
                throw e;
            }
        }
        return "";
    }

    @Override
    public AbstractCSSValue getPropertyCSSValue(String propertyName) {
        propertyName = this.getCanonicalPropertyName(propertyName);
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    private String getCanonicalPropertyName(String propertyName) {
        if (propertyName.length() > 2 && (propertyName.charAt(0) != '-' || propertyName.charAt(1) != '-')) {
            propertyName = propertyName.toLowerCase(Locale.US);
        }
        return propertyName;
    }

    protected AbstractCSSValue getCSSValue(String propertyName) {
        return this.getDeclaredCSSValue(propertyName);
    }

    protected AbstractCSSValue getDeclaredCSSValue(String propertyName) {
        return this.propValue.get(propertyName);
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        int idx = this.propertyList.indexOf(propertyName = this.getCanonicalPropertyName(propertyName));
        if (idx >= 0 && !this.propValue.get(propertyName).isSubproperty()) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            CSSValue oldvalue = this.propValue.remove(propertyName);
            PropertyDatabase pdb = PropertyDatabase.getInstance();
            if (!this.shorthandSet.isEmpty() && pdb.isShorthandSubproperty(propertyName)) {
                String shorthand = propertyName;
                boolean hasShorthand = false;
                while (!(hasShorthand = this.shorthandSet.contains(shorthand = pdb.getShorthand(shorthand))) && pdb.isShorthandSubproperty(shorthand)) {
                }
                if (hasShorthand) {
                    CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthand);
                    this.setSubproperties(shorthand, shval.getLexicalUnit(), shval.isImportant() ? "important" : null);
                }
            }
            return oldvalue.getCssText();
        }
        if (this.shorthandSet.contains(propertyName)) {
            String text = this.propValue.get(propertyName).getCssText();
            this.removeSubproperties(PropertyDatabase.getInstance(), propertyName);
            return text;
        }
        return "";
    }

    private void removeSubproperties(PropertyDatabase pdb, String shorthandName) {
        this.shorthandSet.remove(shorthandName);
        String[] subp = pdb.getShorthandSubproperties(shorthandName);
        for (int i = 0; i < subp.length; ++i) {
            int idx = this.propertyList.indexOf(subp[i]);
            if (idx == -1) {
                this.removeSubproperties(pdb, subp[i]);
                continue;
            }
            if (!this.propValue.get(subp[i]).isSubproperty()) continue;
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.propValue.remove(subp[i]);
        }
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx < 0) {
            if (this.shorthandSet.contains(propertyName) && ((CSSShorthandValue)this.propValue.get(propertyName)).isImportant()) {
                return "important";
            }
            return "";
        }
        String prio = this.priorities.get(idx);
        if (prio != null) {
            return prio;
        }
        return "";
    }

    @Override
    public void setProperty(String propertyName, LexicalUnit value, String priority) throws DOMException {
        propertyName = this.getCanonicalPropertyName(propertyName);
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            boolean important = priority == "important";
            CSSShorthandValue shVal = (CSSShorthandValue)this.propValue.get(propertyName);
            if (shVal == null || important || !shVal.isImportant()) {
                if (!this.shorthandSet.isEmpty()) {
                    if (this.shorthandSet.contains(propertyName)) {
                        this.shorthandSet.remove(propertyName);
                    }
                    Iterator it = this.shorthandSet.iterator();
                    while (it.hasNext()) {
                        String sh = (String)it.next();
                        if (pdb.isShorthandSubpropertyOf(propertyName, sh)) {
                            if (!important && ((CSSShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                            it.remove();
                            this.propValue.remove(sh);
                            continue;
                        }
                        if (!pdb.isShorthandSubpropertyOf(sh, propertyName) || important || !((CSSShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                        return;
                    }
                }
                shVal = new CSSShorthandValue(value, important);
                try {
                    shVal.setShorthandText(this.setSubproperties(propertyName, value, priority));
                    this.propValue.put(propertyName, shVal);
                    this.shorthandSet.add(propertyName);
                }
                catch (DOMException e) {
                    StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName);
                        ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(value));
                        errHandler.wrongValue(propertyName, ex);
                    }
                }
            }
        } else {
            StyleDeclarationErrorHandler errHandler;
            AbstractCSSValue cssvalue;
            ValueFactory factory = new ValueFactory();
            try {
                cssvalue = factory.createCSSValue(value);
            }
            catch (DOMException e) {
                StyleDeclarationErrorHandler errHandler2 = this.getStyleDeclarationErrorHandler();
                if (errHandler2 != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName);
                    ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(value));
                    errHandler2.wrongValue(propertyName, ex);
                }
                throw e;
            }
            if (factory.hasWarnings() && (errHandler = this.getStyleDeclarationErrorHandler()) != null) {
                factory.handleSyntaxWarnings(errHandler);
            }
            if (propertyName.equals("font-family") || propertyName.equals("content")) {
                if (cssvalue.getCssValueType() == 2) {
                    OMCSSValueList list = (OMCSSValueList)cssvalue;
                    if (list.isCommaSeparated()) {
                        int sz = list.getLength();
                        for (int i = 0; i < sz; ++i) {
                            if (list.item(i).getCssValueType() != 2) continue;
                            list.set(i, this.listToString((OMCSSValueList)list.item(i)));
                        }
                    } else {
                        cssvalue = this.listToString(list);
                    }
                }
            } else if (propertyName.equals("background-position") && cssvalue.getCssValueType() == 2) {
                OMCSSValueList list = (OMCSSValueList)cssvalue;
                if (list.isCommaSeparated()) {
                    int sz = list.getLength();
                    for (int i = 0; i < sz; ++i) {
                        AbstractCSSValue item = list.item(i);
                        if (item.getCssValueType() != 2 || BaseCSSStyleDeclaration.checkBackgroundPosition((OMCSSValueList)item)) continue;
                        list.remove(i--);
                        errHandler = this.getStyleDeclarationErrorHandler();
                        if (errHandler == null) continue;
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                        ex.setValueText(item.getCssText());
                        errHandler.wrongValue("background-position", ex);
                    }
                    if (list.getLength() == 0) {
                        return;
                    }
                } else if (!BaseCSSStyleDeclaration.checkBackgroundPosition(list)) {
                    errHandler = this.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                        ex.setValueText(list.getCssText());
                        errHandler.wrongValue("background-position", ex);
                    }
                    return;
                }
            }
            this.setProperty(propertyName, cssvalue, priority);
        }
    }

    private CSSStringValue listToString(OMCSSValueList cssvalue) {
        int len = cssvalue.getLength();
        StringBuilder buf = new StringBuilder(cssvalue.getLength() * 7 + 8);
        buf.append(cssvalue.item(0).getCssText());
        for (int i = 1; i < len; ++i) {
            buf.append(' ').append(cssvalue.item(i).getCssText());
        }
        CSSStringValue csstr = new CSSStringValue();
        csstr.setStringValue((short)19, buf.toString());
        return csstr;
    }

    private static boolean checkBackgroundPosition(OMCSSValueList list) {
        int count = list.getLength();
        if (count < 3) {
            return true;
        }
        if (count == 4) {
            return ((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(3))).getPrimitiveType() != 21;
        }
        if (((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() != 21) {
            return false;
        }
        if (((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() != 21) {
            return true;
        }
        return ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21;
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        LexicalUnit lunit;
        Parser parser;
        if (value.length() == 0) {
            this.removeProperty(propertyName);
            return;
        }
        try {
            parser = this.createSACParser();
        }
        catch (DOMException e) {
            throw new DOMException(7, e.getMessage());
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        if (priority != null) {
            priority = priority.toLowerCase(Locale.US).intern();
        }
        this.setProperty(propertyName, lunit, priority);
    }

    boolean setProperty(String propertyName, AbstractCSSValue cssValue, String priority) {
        if (!this.propertyList.contains(propertyName = propertyName.intern())) {
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        int idx = this.propertyList.indexOf(propertyName);
        if (!"important".equals(this.priorities.get(idx)) || "important".equals(priority)) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        return false;
    }

    @Override
    void addProperty(String propertyName, AbstractCSSValue cssValue, String priority) {
        if (cssValue instanceof CSSShorthandValue) {
            this.addShorthandName(propertyName);
        } else {
            this.propertyList.add(propertyName);
            this.priorities.add(priority);
        }
        this.propValue.put(propertyName, cssValue);
    }

    private void addShorthandName(String shorthand) {
        if (this.shorthandSet.contains(shorthand)) {
            this.shorthandSet.remove(shorthand);
        }
        this.shorthandSet.add(shorthand);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyList.isEmpty();
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int index) {
        if (index < 0 || index > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(index);
    }

    @Override
    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
        this.shorthandSet.clear();
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null) {
            prule.getStyleDeclarationErrorHandler().reset();
        }
    }

    @Override
    public BaseCSSDeclarationRule getParentRule() {
        return this.parentRule;
    }

    public void addStyle(BaseCSSStyleDeclaration style) {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        HashSet<String> addedShorthands = new HashSet<String>(style.shorthandSet.size());
        Iterator<String> it = style.propertyList.iterator();
        int i = -1;
        while (it.hasNext()) {
            String shorthand;
            ++i;
            String propertyName = it.next();
            int pIndex = this.propertyList.indexOf(propertyName);
            if (pIndex == -1) {
                this.propertyList.add(propertyName);
                this.priorities.add(style.priorities.get(i));
            } else if (!"important".equals(this.priorities.get(pIndex))) {
                this.priorities.set(pIndex, style.priorities.get(i));
            } else if (!"important".equals(style.priorities.get(i))) continue;
            AbstractCSSValue value = style.getCSSValue(propertyName);
            if (value.isSubproperty() && !addedShorthands.contains(shorthand = pdb.getShorthand(propertyName))) {
                AbstractCSSValue shvalue;
                String bigshorthand = pdb.getShorthand(shorthand);
                if (bigshorthand != null && style.shorthandSet.contains(bigshorthand)) {
                    addedShorthands.add(bigshorthand);
                    this.addShorthandName(bigshorthand);
                    shvalue = style.propValue.get(bigshorthand);
                    this.setPropertyCSSValue(bigshorthand, shvalue, null);
                }
                if ((shvalue = style.propValue.get(shorthand)) != null) {
                    addedShorthands.add(shorthand);
                    this.addShorthandName(shorthand);
                    this.setPropertyCSSValue(shorthand, shvalue, null);
                }
            }
            String href = null;
            if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
                href = style.getParentRule() != null ? style.getParentRule().getParentStyleSheet().getHref() : ((NodeStyleDeclaration)((Object)style)).getOwnerNode().getOwnerDocument().getBaseURI();
            }
            this.setPropertyCSSValue(propertyName, value, href);
        }
    }

    protected void setPropertyCSSValue(String propertyName, AbstractCSSValue value, String hrefcontext) {
        this.propValue.put(propertyName, value);
    }

    @Override
    protected void prioritySplit(AbstractCSSStyleDeclaration importantDecl, AbstractCSSStyleDeclaration normalDecl) {
        AbstractCSSValue value;
        int psz = this.propertyList.size();
        for (int i = 0; i < psz; ++i) {
            String propertyName = this.propertyList.get(i);
            value = this.propValue.get(propertyName);
            String priority = this.priorities.get(i);
            if ("important".equals(priority)) {
                importantDecl.addProperty(propertyName, value, priority);
                continue;
            }
            normalDecl.addProperty(propertyName, value, priority);
        }
        for (String sh : this.shorthandSet) {
            value = (CSSShorthandValue)this.propValue.get(sh);
            if (((CSSShorthandValue)value).isImportant()) {
                importantDecl.addProperty(sh, value, "important");
                continue;
            }
            normalDecl.addProperty(sh, value, null);
        }
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    protected AbstractCSSValue defaultPropertyValue(String propertyName) {
        AbstractCSSValue defval = PropertyDatabase.getInstance().getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                if (this.getStyleDatabase() == null) {
                    if (this.getStyleSheetFactory() != null) {
                        return this.getStyleSheetFactory().getSystemDefaultValue(propertyName);
                    }
                    return SystemDefaultValue.getInstance();
                }
                defval = (AbstractCSSValue)((Object)this.getStyleDatabase().getInitialColor());
            } else if (propertyName.equals("font-family")) {
                if (this.getStyleDatabase() == null) {
                    if (this.getStyleSheetFactory() != null) {
                        return this.getStyleSheetFactory().getSystemDefaultValue(propertyName);
                    }
                    return SystemDefaultValue.getInstance();
                }
                defval = new ValueFactory().parseProperty(this.getStyleDatabase().getDefaultGenericFontFamily());
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? new ValueFactory().parseProperty("right") : new ValueFactory().parseProperty("left");
            } else if (propertyName.endsWith("-color")) {
                defval = this.getCSSColor();
            } else if (propertyName.equals("quotes")) {
                defval = new ValueFactory().parseProperty("\" \"");
            }
        }
        return defval;
    }

    public AbstractCSSPrimitiveValue getCSSColor() {
        AbstractCSSPrimitiveValue color;
        AbstractCSSValue cssvalue = this.getCSSValue("color");
        if (cssvalue == null || cssvalue.getCssValueType() != 1) {
            StyleDatabase sdb = this.getStyleDatabase();
            if (sdb != null) {
                color = (AbstractCSSPrimitiveValue)this.getStyleDatabase().getInitialColor();
            } else {
                CSSStyleSheetFactory factory = this.getStyleSheetFactory();
                if (factory != null) {
                    return factory.getSystemDefaultValue("color");
                }
                color = SystemDefaultValue.getInstance();
            }
        } else {
            color = (AbstractCSSPrimitiveValue)cssvalue;
        }
        return color;
    }

    protected String setSubproperties(String propertyName, LexicalUnit value, String priority) throws DOMException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            ShorthandSetter setter;
            if ("font".equals(propertyName)) {
                String decl;
                if (this.getStyleDatabase() != null && value.getLexicalUnitType() == 35 && (decl = this.getStyleDatabase().getSystemFontDeclaration(value.getStringValue())) != null) {
                    InputSource source = new InputSource();
                    StringReader re = new StringReader(decl);
                    source.setCharacterStream((Reader)re);
                    LexicalUnit lunit = null;
                    try {
                        lunit = this.createSACParser().parsePropertyValue(source);
                    }
                    catch (CSSException e) {
                        throw new DOMException(12, e.getMessage());
                    }
                    catch (IOException e) {
                        throw new DOMException(11, e.getMessage());
                    }
                    return this.setSubproperties(propertyName, lunit, priority);
                }
                setter = new FontShorthandSetter();
            } else {
                setter = "margin".equals(propertyName) ? new MarginShorthandSetter() : ("padding".equals(propertyName) ? new BoxShorthandSetter("padding") : ("border".equals(propertyName) ? new BorderShorthandSetter() : ("border-width".equals(propertyName) ? new BorderWidthShorthandSetter() : ("border-style".equals(propertyName) ? new BorderStyleShorthandSetter() : ("border-color".equals(propertyName) ? new BorderColorShorthandSetter() : ("border-top".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "top") : ("border-right".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "right") : ("border-bottom".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "bottom") : ("border-left".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "left") : ("background".equals(propertyName) ? new BackgroundShorthandSetter() : ("transition".equals(propertyName) ? new TransitionShorthandSetter() : ("border-image".equals(propertyName) ? new BorderImageShorthandSetter() : new ShorthandSetter(propertyName)))))))))))));
            }
            setter.init(value, priority);
            if (!setter.assignSubproperties()) {
                throw new DOMException(12, "Invalid property declaration");
            }
            return setter.getCssText();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        TreeSet<String> propertyNames = new TreeSet<String>(this.propertyList);
        for (String property : propertyNames) {
            result = 31 * result + property.hashCode();
            result = 31 * result + this.propValue.get(property).hashCode();
            String prio = this.priorities.get(this.propertyList.indexOf(property));
            result = 31 * result + (prio == null ? 0 : prio.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseCSSStyleDeclaration)) {
            return false;
        }
        BaseCSSStyleDeclaration other = (BaseCSSStyleDeclaration)obj;
        if (this.propertyList.size() != other.propertyList.size()) {
            return false;
        }
        for (String property : this.propertyList) {
            if (!other.propertyList.contains(property)) {
                return false;
            }
            AbstractCSSValue value = this.propValue.get(property);
            if (!value.equals(other.propValue.get(property))) {
                return false;
            }
            int idx = this.propertyList.indexOf(property);
            int idxo = other.propertyList.indexOf(property);
            String prio = this.priorities.get(idx);
            String prioo = other.priorities.get(idxo);
            if (!(prio == null ? prioo != null : !prio.equals(prioo))) continue;
            return false;
        }
        return true;
    }

    public Diff<String> diff(BaseCSSStyleDeclaration other) {
        PropertyDiff diff = new PropertyDiff();
        for (String property : this.propertyList) {
            if (!other.propertyList.contains(property)) {
                diff.leftSide.add(property);
                continue;
            }
            AbstractCSSValue value = this.propValue.get(property);
            if (value.equals(other.propValue.get(property))) {
                int idx = this.propertyList.indexOf(property);
                int idxo = other.propertyList.indexOf(property);
                String prio = this.priorities.get(idx);
                String prioo = other.priorities.get(idxo);
                if (prio == null ? prioo == null : prio.equals(prioo)) continue;
            }
            diff.differentValues.add(property);
        }
        for (String property : other.propertyList) {
            if (this.propertyList.contains(property)) continue;
            diff.rightSide.add(property);
        }
        return diff;
    }

    public String toString() {
        return this.getCssText();
    }

    public BaseCSSStyleDeclaration clone() {
        return new BaseCSSStyleDeclaration(this);
    }

    @Override
    protected CSSStyleSheetFactory getStyleSheetFactory() {
        AbstractCSSStyleSheet sheet;
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null && (sheet = prule.getParentStyleSheet()) != null) {
            return sheet.getStyleSheetFactory();
        }
        return null;
    }

    static String lexicalUnitToString(LexicalUnit value) {
        String s = null;
        switch (value.getLexicalUnitType()) {
            case 35: 
            case 36: {
                s = value.getStringValue();
                break;
            }
            case 24: {
                s = "url('" + value.getStringValue() + "')";
                break;
            }
            case 37: {
                s = "attr('" + value.getStringValue() + "')";
                break;
            }
            case 12: {
                s = "inherit";
                break;
            }
            case 25: 
            case 26: 
            case 38: {
                s = value.getFunctionName();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                s = Float.toString(value.getFloatValue()) + value.getDimensionUnitText();
                break;
            }
            case 13: {
                s = Integer.toString(value.getIntegerValue());
                break;
            }
            case 40: {
                s = BaseCSSStyleDeclaration.lexicalUnitToString(value.getSubValues());
                break;
            }
            case 0: {
                s = ",";
                break;
            }
            case 6: {
                s = "^";
                break;
            }
            case 10: {
                s = ">=";
                break;
            }
            case 8: {
                s = ">";
                break;
            }
            case 9: {
                s = "<=";
                break;
            }
            case 7: {
                s = "<";
                break;
            }
            case 2: {
                s = "-";
                break;
            }
            case 5: {
                s = "%";
                break;
            }
            case 3: {
                s = "*";
                break;
            }
            case 1: {
                s = "+";
                break;
            }
            case 4: {
                s = "/";
                break;
            }
            case 11: {
                s = "~";
                break;
            }
            case 27: {
                s = value.getFunctionName();
            }
            default: {
                s = value.toString();
            }
        }
        if (value.getNextLexicalUnit() != null) {
            s = s + " " + BaseCSSStyleDeclaration.lexicalUnitToString(value.getNextLexicalUnit());
        }
        return s;
    }

    StyleDeclarationDocumentHandler getStyleDeclarationDocumentHandler() {
        return new StyleDeclarationDocumentHandler();
    }

    public static boolean testColor(LexicalUnit lunit) {
        String func;
        short utype = lunit.getLexicalUnitType();
        if (27 == utype) {
            return true;
        }
        if (36 == utype && lunit.getStringValue().charAt(0) == '#') {
            return true;
        }
        if (35 == utype) {
            String sv = lunit.getStringValue();
            if (sv == null) {
                return false;
            }
            sv = sv.toLowerCase(Locale.US);
            return ColorIdentifiers.getInstance().getColor(sv) != null || "transparent".equals(sv) || "currentcolor".equals(sv);
        }
        return 41 == utype && ("rgba".equals(func = lunit.getFunctionName().toLowerCase(Locale.US)) || "hsla".equals(func) || "hsl".equals(func) || "hwb".equals(func));
    }

    @Override
    public String getAzimuth() {
        return this.getPropertyValue("azimuth");
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
        this.getPropertyCSSValue("azimuth").setCssText(azimuth);
    }

    @Override
    public String getBackground() {
        return this.getPropertyValue("background");
    }

    @Override
    public void setBackground(String background) throws DOMException {
        this.getPropertyCSSValue("background").setCssText(background);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getPropertyValue("background-attachment");
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundAttachment);
    }

    @Override
    public String getBackgroundColor() {
        return this.getPropertyValue("background-color");
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.getPropertyCSSValue("background-color").setCssText(backgroundColor);
    }

    @Override
    public String getBackgroundImage() {
        return this.getPropertyValue("background-image");
    }

    @Override
    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundImage);
    }

    @Override
    public String getBackgroundPosition() {
        return this.getPropertyValue("background-position");
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.getPropertyCSSValue("background-position").setCssText(backgroundPosition);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getPropertyValue("background-repeat");
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.getPropertyCSSValue("background-repeat").setCssText(backgroundRepeat);
    }

    @Override
    public String getBorder() {
        return this.getPropertyValue("border");
    }

    @Override
    public void setBorder(String border) throws DOMException {
        this.getPropertyCSSValue("border").setCssText(border);
    }

    @Override
    public String getBorderCollapse() {
        return this.getPropertyValue("border-collapse");
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.getPropertyCSSValue("border-collapse").setCssText(borderCollapse);
    }

    @Override
    public String getBorderColor() {
        return this.getPropertyValue("border-color");
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
        this.getPropertyCSSValue("border-color").setCssText(borderColor);
    }

    @Override
    public String getBorderSpacing() {
        return this.getPropertyValue("border-spacing");
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.getPropertyCSSValue("border-spacing").setCssText(borderSpacing);
    }

    @Override
    public String getBorderStyle() {
        return this.getPropertyValue("border-style");
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
        this.getPropertyCSSValue("border-style").setCssText(borderStyle);
    }

    @Override
    public String getBorderTop() {
        return this.getPropertyValue("border-top");
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
        this.getPropertyCSSValue("border-top").setCssText(borderTop);
    }

    @Override
    public String getBorderRight() {
        return this.getPropertyValue("border-right");
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
        this.getPropertyCSSValue("border-right").setCssText(borderRight);
    }

    @Override
    public String getBorderBottom() {
        return this.getPropertyValue("border-bottom");
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
        this.getPropertyCSSValue("border-bottom").setCssText(borderBottom);
    }

    @Override
    public String getBorderLeft() {
        return this.getPropertyValue("border-left");
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
        this.getPropertyCSSValue("border-left").setCssText(borderLeft);
    }

    @Override
    public String getBorderTopColor() {
        return this.getPropertyValue("border-top-color");
    }

    @Override
    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.getPropertyCSSValue("border-top-color").setCssText(borderTopColor);
    }

    @Override
    public String getBorderRightColor() {
        return this.getPropertyValue("border-right-color");
    }

    @Override
    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.getPropertyCSSValue("border-right-color").setCssText(borderRightColor);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getPropertyValue("border-bottom-color");
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.getPropertyCSSValue("border-bottom-color").setCssText(borderBottomColor);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getPropertyValue("border-left-color");
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.getPropertyCSSValue("border-left-color").setCssText(borderLeftColor);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getPropertyValue("border-top-style");
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.getPropertyCSSValue("border-top-style").setCssText(borderTopStyle);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getPropertyValue("border-right-style");
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.getPropertyCSSValue("border-right-style").setCssText(borderRightStyle);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getPropertyValue("border-bottom-style");
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.getPropertyCSSValue("border-bottom-style").setCssText(borderBottomStyle);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getPropertyValue("border-left-style");
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.getPropertyCSSValue("border-left-style").setCssText(borderLeftStyle);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getPropertyValue("border-top-width");
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.getPropertyCSSValue("border-top-width").setCssText(borderTopWidth);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getPropertyValue("border-right-width");
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.getPropertyCSSValue("border-right-width").setCssText(borderRightWidth);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getPropertyValue("border-bottom-width");
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.getPropertyCSSValue("border-bottom-width").setCssText(borderBottomWidth);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getPropertyValue("border-left-width");
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.getPropertyCSSValue("border-left-width").setCssText(borderLeftWidth);
    }

    @Override
    public String getBorderWidth() {
        return this.getPropertyValue("border-width");
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
        this.getPropertyCSSValue("border-width").setCssText(borderWidth);
    }

    @Override
    public String getBottom() {
        return this.getPropertyValue("bottom");
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
        this.getPropertyCSSValue("bottom").setCssText(bottom);
    }

    @Override
    public String getCaptionSide() {
        return this.getPropertyValue("caption-side");
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
        this.getPropertyCSSValue("caption-side").setCssText(captionSide);
    }

    @Override
    public String getClear() {
        return this.getPropertyValue("clear");
    }

    @Override
    public void setClear(String clear) throws DOMException {
        this.getPropertyCSSValue("clear").setCssText(clear);
    }

    @Override
    public String getClip() {
        return this.getPropertyValue("clip");
    }

    @Override
    public void setClip(String clip) throws DOMException {
        this.getPropertyCSSValue("clip").setCssText(clip);
    }

    @Override
    public String getColor() {
        return this.getPropertyValue("color");
    }

    @Override
    public void setColor(String color) throws DOMException {
        this.getPropertyCSSValue("color").setCssText(color);
    }

    @Override
    public String getContent() {
        return this.getPropertyValue("content");
    }

    @Override
    public void setContent(String content) throws DOMException {
        this.getPropertyCSSValue("content").setCssText(content);
    }

    @Override
    public String getCounterIncrement() {
        return this.getPropertyValue("counter-increment");
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.getPropertyCSSValue("counter-increment").setCssText(counterIncrement);
    }

    @Override
    public String getCounterReset() {
        return this.getPropertyValue("counter-reset");
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
        this.getPropertyCSSValue("counter-reset").setCssText(counterReset);
    }

    @Override
    public String getCue() {
        return this.getPropertyValue("cue");
    }

    @Override
    public void setCue(String cue) throws DOMException {
        this.getPropertyCSSValue("cue").setCssText(cue);
    }

    @Override
    public String getCueAfter() {
        return this.getPropertyValue("cue-after");
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
        this.getPropertyCSSValue("cue-after").setCssText(cueAfter);
    }

    @Override
    public String getCueBefore() {
        return this.getPropertyValue("cue-before");
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
        this.getPropertyCSSValue("cue-before").setCssText(cueBefore);
    }

    @Override
    public String getCursor() {
        return this.getPropertyValue("cursor");
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
        this.getPropertyCSSValue("cursor").setCssText(cursor);
    }

    @Override
    public String getDirection() {
        return this.getPropertyValue("direction");
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.getPropertyCSSValue("direction").setCssText(direction);
    }

    @Override
    public String getDisplay() {
        return this.getPropertyValue("display");
    }

    @Override
    public void setDisplay(String display) throws DOMException {
        this.getPropertyCSSValue("display").setCssText(display);
    }

    @Override
    public String getElevation() {
        return this.getPropertyValue("elevation");
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
        this.getPropertyCSSValue("elevation").setCssText(elevation);
    }

    @Override
    public String getEmptyCells() {
        return this.getPropertyValue("empty-cells");
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
        this.getPropertyCSSValue("empty-cells").setCssText(emptyCells);
    }

    @Override
    public String getCssFloat() {
        return this.getPropertyValue("css-float");
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
        this.getPropertyCSSValue("css-float").setCssText(cssFloat);
    }

    @Override
    public String getFont() {
        return this.getPropertyValue("font");
    }

    @Override
    public void setFont(String font) throws DOMException {
        this.getPropertyCSSValue("font").setCssText(font);
    }

    @Override
    public String getFontFamily() {
        return this.getPropertyValue("font-family");
    }

    @Override
    public void setFontFamily(String fontFamily) throws DOMException {
        this.getPropertyCSSValue("font-family").setCssText(fontFamily);
    }

    @Override
    public String getFontSize() {
        return this.getPropertyValue("font-size");
    }

    @Override
    public void setFontSize(String fontSize) throws DOMException {
        this.getPropertyCSSValue("font-size").setCssText(fontSize);
    }

    @Override
    public String getFontSizeAdjust() {
        return this.getPropertyValue("font-size-adjust");
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.getPropertyCSSValue("font-size-adjust").setCssText(fontSizeAdjust);
    }

    @Override
    public String getFontStretch() {
        return this.getPropertyValue("font-stretch");
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        this.getPropertyCSSValue("font-stretch").setCssText(fontStretch);
    }

    @Override
    public String getFontStyle() {
        return this.getPropertyValue("font-style");
    }

    @Override
    public void setFontStyle(String fontStyle) throws DOMException {
        this.getPropertyCSSValue("font-style").setCssText(fontStyle);
    }

    @Override
    public String getFontVariant() {
        return this.getPropertyValue("font-variant");
    }

    @Override
    public void setFontVariant(String fontVariant) throws DOMException {
        this.getPropertyCSSValue("font-variant").setCssText(fontVariant);
    }

    @Override
    public String getFontWeight() {
        return this.getPropertyValue("font-weight");
    }

    @Override
    public void setFontWeight(String fontWeight) throws DOMException {
        this.getPropertyCSSValue("font-weight").setCssText(fontWeight);
    }

    @Override
    public String getHeight() {
        return this.getPropertyValue("height");
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.getPropertyCSSValue("height").setCssText(height);
    }

    @Override
    public String getLeft() {
        return this.getPropertyValue("left");
    }

    @Override
    public void setLeft(String left) throws DOMException {
        this.getPropertyCSSValue("left").setCssText(left);
    }

    @Override
    public String getLetterSpacing() {
        return this.getPropertyValue("letter-spacing");
    }

    @Override
    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.getPropertyCSSValue("letter-spacing").setCssText(letterSpacing);
    }

    @Override
    public String getLineHeight() {
        return this.getPropertyValue("line-height");
    }

    @Override
    public void setLineHeight(String lineHeight) throws DOMException {
        this.getPropertyCSSValue("line-height").setCssText(lineHeight);
    }

    @Override
    public String getListStyle() {
        return this.getPropertyValue("list-style");
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        this.getPropertyCSSValue("list-style").setCssText(listStyle);
    }

    @Override
    public String getListStyleImage() {
        return this.getPropertyValue("list-style-image");
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.getPropertyCSSValue("list-style-image").setCssText(listStyleImage);
    }

    @Override
    public String getListStylePosition() {
        return this.getPropertyValue("list-style-position");
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.getPropertyCSSValue("list-style-position").setCssText(listStylePosition);
    }

    @Override
    public String getListStyleType() {
        return this.getPropertyValue("list-style-type");
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        this.getPropertyCSSValue("list-style-type").setCssText(listStyleType);
    }

    @Override
    public String getMargin() {
        return this.getPropertyValue("margin");
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        this.getPropertyCSSValue("margin").setCssText(margin);
    }

    @Override
    public String getMarginTop() {
        return this.getPropertyValue("margin-top");
    }

    @Override
    public void setMarginTop(String marginTop) throws DOMException {
        this.getPropertyCSSValue("margin-top").setCssText(marginTop);
    }

    @Override
    public String getMarginRight() {
        return this.getPropertyValue("margin-right");
    }

    @Override
    public void setMarginRight(String marginRight) throws DOMException {
        this.getPropertyCSSValue("margin-right").setCssText(marginRight);
    }

    @Override
    public String getMarginBottom() {
        return this.getPropertyValue("margin-bottom");
    }

    @Override
    public void setMarginBottom(String marginBottom) throws DOMException {
        this.getPropertyCSSValue("margin-bottom").setCssText(marginBottom);
    }

    @Override
    public String getMarginLeft() {
        return this.getPropertyValue("margin-left");
    }

    @Override
    public void setMarginLeft(String marginLeft) throws DOMException {
        this.getPropertyCSSValue("margin-left").setCssText(marginLeft);
    }

    @Override
    public String getMarkerOffset() {
        return this.getPropertyValue("marker-offset");
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.getPropertyCSSValue("marker-offset").setCssText(markerOffset);
    }

    @Override
    public String getMarks() {
        return this.getPropertyValue("marks");
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        this.getPropertyCSSValue("marks").setCssText(marks);
    }

    @Override
    public String getMaxHeight() {
        return this.getPropertyValue("max-height");
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        this.getPropertyCSSValue("max-height").setCssText(maxHeight);
    }

    @Override
    public String getMaxWidth() {
        return this.getPropertyValue("max-width");
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        this.getPropertyCSSValue("max-width").setCssText(maxWidth);
    }

    @Override
    public String getMinHeight() {
        return this.getPropertyValue("min-height");
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        this.getPropertyCSSValue("min-height").setCssText(minHeight);
    }

    @Override
    public String getMinWidth() {
        return this.getPropertyValue("min-width");
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        this.getPropertyCSSValue("min-width").setCssText(minWidth);
    }

    @Override
    public String getOrphans() {
        return this.getPropertyValue("orphans");
    }

    @Override
    public void setOrphans(String orphans) throws DOMException {
        this.getPropertyCSSValue("orphans").setCssText(orphans);
    }

    @Override
    public String getOutline() {
        return this.getPropertyValue("outline");
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        this.getPropertyCSSValue("outline").setCssText(outline);
    }

    @Override
    public String getOutlineColor() {
        return this.getPropertyValue("outline-color");
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        this.getPropertyCSSValue("outline-color").setCssText(outlineColor);
    }

    @Override
    public String getOutlineStyle() {
        return this.getPropertyValue("outline-style");
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.getPropertyCSSValue("outline-style").setCssText(outlineStyle);
    }

    @Override
    public String getOutlineWidth() {
        return this.getPropertyValue("outline-width");
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.getPropertyCSSValue("outline-width").setCssText(outlineWidth);
    }

    @Override
    public String getOverflow() {
        return this.getPropertyValue("overflow");
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.getPropertyCSSValue("overflow").setCssText(overflow);
    }

    @Override
    public String getPadding() {
        return this.getPropertyValue("padding");
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        this.getPropertyCSSValue("padding").setCssText(padding);
    }

    @Override
    public String getPaddingTop() {
        return this.getPropertyValue("padding-top");
    }

    @Override
    public void setPaddingTop(String paddingTop) throws DOMException {
        this.getPropertyCSSValue("padding-top").setCssText(paddingTop);
    }

    @Override
    public String getPaddingRight() {
        return this.getPropertyValue("padding-right");
    }

    @Override
    public void setPaddingRight(String paddingRight) throws DOMException {
        this.getPropertyCSSValue("padding-right").setCssText(paddingRight);
    }

    @Override
    public String getPaddingBottom() {
        return this.getPropertyValue("padding-bottom");
    }

    @Override
    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.getPropertyCSSValue("padding-bottom").setCssText(paddingBottom);
    }

    @Override
    public String getPaddingLeft() {
        return this.getPropertyValue("padding-left");
    }

    @Override
    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.getPropertyCSSValue("padding-left").setCssText(paddingLeft);
    }

    @Override
    public String getPage() {
        return this.getPropertyValue("page");
    }

    @Override
    public void setPage(String page) throws DOMException {
        this.getPropertyCSSValue("page").setCssText(page);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getPropertyValue("page-break-after");
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.getPropertyCSSValue("page-break-after").setCssText(pageBreakAfter);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getPropertyValue("page-break-before");
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.getPropertyCSSValue("page-break-before").setCssText(pageBreakBefore);
    }

    @Override
    public String getPageBreakInside() {
        return this.getPropertyValue("page-break-inside");
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.getPropertyCSSValue("page-break-inside").setCssText(pageBreakInside);
    }

    @Override
    public String getPause() {
        return this.getPropertyValue("pause");
    }

    @Override
    public void setPause(String pause) throws DOMException {
        this.getPropertyCSSValue("pause").setCssText(pause);
    }

    @Override
    public String getPauseAfter() {
        return this.getPropertyValue("pause-after");
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.getPropertyCSSValue("pause-after").setCssText(pauseAfter);
    }

    @Override
    public String getPauseBefore() {
        return this.getPropertyValue("pause-before");
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.getPropertyCSSValue("pause-before").setCssText(pauseBefore);
    }

    @Override
    public String getPitch() {
        return this.getPropertyValue("pitch");
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        this.getPropertyCSSValue("pitch").setCssText(pitch);
    }

    @Override
    public String getPitchRange() {
        return this.getPropertyValue("pitch-range");
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        this.getPropertyCSSValue("pitch-range").setCssText(pitchRange);
    }

    @Override
    public String getPlayDuring() {
        return this.getPropertyValue("play-during");
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        this.getPropertyCSSValue("play-during").setCssText(playDuring);
    }

    @Override
    public String getPosition() {
        return this.getPropertyValue("position");
    }

    @Override
    public void setPosition(String position) throws DOMException {
        this.getPropertyCSSValue("position").setCssText(position);
    }

    @Override
    public String getQuotes() {
        return this.getPropertyValue("quotes");
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        this.getPropertyCSSValue("quotes").setCssText(quotes);
    }

    @Override
    public String getRichness() {
        return this.getPropertyValue("richness");
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        this.getPropertyCSSValue("richness").setCssText(richness);
    }

    @Override
    public String getRight() {
        return this.getPropertyValue("right");
    }

    @Override
    public void setRight(String right) throws DOMException {
        this.getPropertyCSSValue("right").setCssText(right);
    }

    @Override
    public String getSize() {
        return this.getPropertyValue("size");
    }

    @Override
    public void setSize(String size) throws DOMException {
        this.getPropertyCSSValue("size").setCssText(size);
    }

    @Override
    public String getSpeak() {
        return this.getPropertyValue("speak");
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        this.getPropertyCSSValue("speak").setCssText(speak);
    }

    @Override
    public String getSpeakHeader() {
        return this.getPropertyValue("speak-header");
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.getPropertyCSSValue("speak-header").setCssText(speakHeader);
    }

    @Override
    public String getSpeakNumeral() {
        return this.getPropertyValue("speak-numeral");
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.getPropertyCSSValue("speak-numeral").setCssText(speakNumeral);
    }

    @Override
    public String getSpeakPunctuation() {
        return this.getPropertyValue("speak-punctuation");
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.getPropertyCSSValue("speak-punctuation").setCssText(speakPunctuation);
    }

    @Override
    public String getSpeechRate() {
        return this.getPropertyValue("speech-rate");
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        this.getPropertyCSSValue("speech-rate").setCssText(speechRate);
    }

    @Override
    public String getStress() {
        return this.getPropertyValue("stress");
    }

    @Override
    public void setStress(String stress) throws DOMException {
        this.getPropertyCSSValue("stress").setCssText(stress);
    }

    @Override
    public String getTableLayout() {
        return this.getPropertyValue("table-layout");
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        this.getPropertyCSSValue("table-layout").setCssText(tableLayout);
    }

    @Override
    public String getTextAlign() {
        return this.getPropertyValue("text-align");
    }

    @Override
    public void setTextAlign(String textAlign) throws DOMException {
        this.getPropertyCSSValue("text-align").setCssText(textAlign);
    }

    @Override
    public String getTextDecoration() {
        return this.getPropertyValue("text-decoration");
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        this.getPropertyCSSValue("text-decoration").setCssText(textDecoration);
    }

    @Override
    public String getTextIndent() {
        return this.getPropertyValue("text-indent");
    }

    @Override
    public void setTextIndent(String textIndent) throws DOMException {
        this.getPropertyCSSValue("text-indent").setCssText(textIndent);
    }

    @Override
    public String getTextShadow() {
        return this.getPropertyValue("text-shadow");
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        this.getPropertyCSSValue("text-shadow").setCssText(textShadow);
    }

    @Override
    public String getTextTransform() {
        return this.getPropertyValue("text-transform");
    }

    @Override
    public void setTextTransform(String textTransform) throws DOMException {
        this.getPropertyCSSValue("text-transform").setCssText(textTransform);
    }

    @Override
    public String getTop() {
        return this.getPropertyValue("top");
    }

    @Override
    public void setTop(String top) throws DOMException {
        this.getPropertyCSSValue("top").setCssText(top);
    }

    @Override
    public String getUnicodeBidi() {
        return this.getPropertyValue("unicode-bidi");
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.getPropertyCSSValue("unicode-bidi").setCssText(unicodeBidi);
    }

    @Override
    public String getVerticalAlign() {
        return this.getPropertyValue("vertical-align");
    }

    @Override
    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.getPropertyCSSValue("vertical-align").setCssText(verticalAlign);
    }

    @Override
    public String getVisibility() {
        return this.getPropertyValue("visibility");
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        this.getPropertyCSSValue("visibility").setCssText(visibility);
    }

    @Override
    public String getVoiceFamily() {
        return this.getPropertyValue("voice-family");
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.getPropertyCSSValue("voice-family").setCssText(voiceFamily);
    }

    @Override
    public String getVolume() {
        return this.getPropertyValue("volume");
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        this.getPropertyCSSValue("volume").setCssText(volume);
    }

    @Override
    public String getWhiteSpace() {
        return this.getPropertyValue("white-space");
    }

    @Override
    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.getPropertyCSSValue("white-space").setCssText(whiteSpace);
    }

    @Override
    public String getWidows() {
        return null;
    }

    @Override
    public void setWidows(String widows) throws DOMException {
        this.getPropertyCSSValue("widows").setCssText(widows);
    }

    @Override
    public String getWidth() {
        return this.getPropertyValue("width");
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.getPropertyCSSValue("width").setCssText(width);
    }

    @Override
    public String getWordSpacing() {
        return this.getPropertyValue("word-spacing");
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.getPropertyCSSValue("word-spacing").setCssText(wordSpacing);
    }

    @Override
    public String getZIndex() {
        return this.getPropertyValue("z-index");
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        this.getPropertyCSSValue("z-index").setCssText(zIndex);
    }

    class BorderImageShorthandSetter
    extends ShorthandSetter {
        BorderImageShorthandSetter() {
            super("border-image");
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
        }

        @Override
        public boolean assignSubproperties() {
            if (this.scanForCssWideKeywords(this.currentValue)) {
                return true;
            }
            boolean errorFound = false;
            boolean bisourceUnset = true;
            boolean bisliceUnset = true;
            boolean biwidthUnset = true;
            boolean bioutsetUnset = true;
            boolean birepeatUnset = true;
            while (this.currentValue != null) {
                StyleDeclarationErrorHandler errHandler;
                short lut = this.currentValue.getLexicalUnitType();
                if (lut == 24 || this.isGradientValue()) {
                    this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                    bisourceUnset = false;
                    this.nextCurrentValue();
                    continue;
                }
                if (lut == 35) {
                    if (this.testIdentifiers("border-image-repeat")) {
                        this.setSubpropertyValue("border-image-repeat", this.createCSSValue("border-image-repeat", this.currentValue));
                        birepeatUnset = false;
                    } else if ("none".equals(this.currentValue.getStringValue())) {
                        this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                        bisourceUnset = false;
                    } else if ("auto".equals(this.currentValue.getStringValue())) {
                        this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                        biwidthUnset = false;
                    } else {
                        errHandler = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler();
                        if (errHandler != null) {
                            errHandler.unknownIdentifier("border-image", this.currentValue.getStringValue());
                        }
                        errorFound = true;
                    }
                    this.nextCurrentValue();
                    continue;
                }
                if (ValueFactory.isPlainNumberOrPercentSACUnit(this.currentValue)) {
                    int c;
                    OMCSSValueList list = OMCSSValueList.createWSValueList();
                    do {
                        list.add(this.createCSSValue("border-image-slice", this.currentValue));
                        this.nextCurrentValue();
                    } while (this.currentValue != null && (lut = this.currentValue.getLexicalUnitType()) != 4 && lut != 35);
                    this.setSubpropertyValue("border-image-slice", list);
                    bisliceUnset = false;
                    if (this.currentValue == null) continue;
                    if (lut == 35) {
                        if (!"fill".equals(this.currentValue.getStringValue().toLowerCase(Locale.US))) continue;
                        list.add(this.createCSSValue("border-image-slice", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        lut = this.currentValue.getLexicalUnitType();
                    }
                    if (lut != 4) continue;
                    this.nextCurrentValue();
                    lut = this.currentValue.getLexicalUnitType();
                    if (lut == 4) {
                        this.nextCurrentValue();
                        if (!ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                            StyleDeclarationErrorHandler errHandler2 = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler();
                            if (errHandler2 == null) break;
                            CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for border-image: expected width / outset");
                            ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(this.currentValue));
                            errHandler2.wrongValue("border-image", ex);
                            errorFound = true;
                            break;
                        }
                        list = OMCSSValueList.createWSValueList();
                        c = 0;
                        while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                            list.add(this.createCSSValue("border-image-outset", this.currentValue));
                            this.nextCurrentValue();
                            c = (byte)(c + 1);
                            if (this.currentValue != null && c < 4) continue;
                        }
                        if (list.getLength() == 0) continue;
                        this.setSubpropertyValue("border-image-outset", list);
                        bioutsetUnset = false;
                        continue;
                    }
                    if (lut == 35) {
                        if (!"auto".equals(this.currentValue.getStringValue())) continue;
                        this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                        biwidthUnset = false;
                        this.nextCurrentValue();
                        continue;
                    }
                    c = 0;
                    list = OMCSSValueList.createWSValueList();
                    while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                        list.add(this.createCSSValue("border-image-width", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        lut = this.currentValue.getLexicalUnitType();
                        c = (byte)(c + 1);
                        if (lut != 4 && lut != 35 && c < 4) continue;
                    }
                    if (list.getLength() != 0) {
                        this.setSubpropertyValue("border-image-width", list);
                        biwidthUnset = false;
                    }
                    if (lut != 4) continue;
                    this.nextCurrentValue();
                    if (this.currentValue == null) break;
                    list = OMCSSValueList.createWSValueList();
                    while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue) && c < 4) {
                        list.add(this.createCSSValue("border-image-outset", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        c = (byte)(c + 1);
                    }
                    if (list.getLength() == 0) continue;
                    this.setSubpropertyValue("border-image-outset", list);
                    bioutsetUnset = false;
                    continue;
                }
                errHandler = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    errHandler.shorthandError("border-image", "Unexpected value: " + this.currentValue.toString());
                }
                return false;
            }
            if (bisourceUnset) {
                this.setSubpropertyValue("border-image-source", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-source"));
            }
            if (bisliceUnset) {
                this.setSubpropertyValue("border-image-slice", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-slice"));
            }
            if (biwidthUnset) {
                this.setSubpropertyValue("border-image-width", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-width"));
            }
            if (bioutsetUnset) {
                this.setSubpropertyValue("border-image-outset", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-outset"));
            }
            if (birepeatUnset) {
                this.setSubpropertyValue("border-image-repeat", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-repeat"));
            }
            if (errorFound && bisourceUnset) {
                return false;
            }
            this.flush();
            return true;
        }
    }

    class TransitionShorthandSetter
    extends ShorthandSetter {
        private String cssText;
        private int transitionsCount;
        private OMCSSValueList lstProperty;
        private OMCSSValueList lstDuration;
        private OMCSSValueList lstTiming;
        private OMCSSValueList lstDelay;

        TransitionShorthandSetter() {
            super("transition");
            this.cssText = null;
            this.transitionsCount = 0;
            this.lstProperty = OMCSSValueList.createCSValueList();
            this.lstDuration = OMCSSValueList.createCSValueList();
            this.lstTiming = OMCSSValueList.createCSValueList();
            this.lstDelay = OMCSSValueList.createCSValueList();
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
            this.setCssText(shorthandValue);
            this.countTransitions(shorthandValue);
        }

        private void setCssText(LexicalUnit value) {
            ValueFactory factory = new ValueFactory();
            StringBuilder valueBuffer = new StringBuilder(32);
            block5: do {
                switch (value.getLexicalUnitType()) {
                    case 0: {
                        valueBuffer.append(',');
                        break;
                    }
                    case 4: {
                        valueBuffer.append('/');
                        break;
                    }
                    case 6: {
                        valueBuffer.append('^');
                        break;
                    }
                    default: {
                        AbstractCSSValue cssValue = factory.createCSSValueItem(value, true);
                        if (cssValue == null) continue block5;
                        String cssText = cssValue.getCssText();
                        if (valueBuffer.length() > 0) {
                            valueBuffer.append(' ');
                        }
                        valueBuffer.append(cssText);
                    }
                }
            } while ((value = value.getNextLexicalUnit()) != null);
            this.cssText = valueBuffer.toString();
        }

        @Override
        public String getCssText() {
            return this.cssText;
        }

        protected void countTransitions(LexicalUnit shorthandValue) {
            this.transitionsCount = 0;
            int valueCount = 0;
            for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
                if (value.getLexicalUnitType() == 0) {
                    if (valueCount <= 0) continue;
                    ++this.transitionsCount;
                    valueCount = 0;
                    continue;
                }
                ++valueCount;
            }
            if (valueCount > 0) {
                ++this.transitionsCount;
            }
        }

        @Override
        public boolean assignSubproperties() {
            int lastTdurCopied = 0;
            int lastTimingCopied = 0;
            int lastDelayCopied = 0;
            int i = 0;
            block0: while (i < this.transitionsCount && this.currentValue != null) {
                boolean tpropUnset = true;
                boolean tdurUnset = true;
                boolean ttfUnset = true;
                boolean tdelayUnset = true;
                while (this.currentValue != null) {
                    AbstractCSSValue value;
                    String sv;
                    short lut = this.currentValue.getLexicalUnitType();
                    if (lut == 0) {
                        ++i;
                        this.nextCurrentValue();
                        break;
                    }
                    if (this.currentValue.getLexicalUnitType() == 12) {
                        while (this.currentValue != null) {
                            boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                            this.currentValue = this.currentValue.getNextLexicalUnit();
                            if (!commaFound) continue;
                            break;
                        }
                        this.clearLayer(++i);
                        CSSInheritedValue inherit = CSSInheritedValue.getValue().asSubproperty();
                        this.addSingleValueLayer(inherit);
                        this.appendValueString(inherit);
                        continue block0;
                    }
                    if (this.currentValue.getLexicalUnitType() == 35 && ("initial".equals(sv = this.currentValue.getStringValue().toLowerCase(Locale.US)) || "unset".equals(sv))) {
                        AbstractCSSValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true);
                        while (this.currentValue != null) {
                            boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                            this.currentValue = this.currentValue.getNextLexicalUnit();
                            if (!commaFound) continue;
                            break;
                        }
                        this.clearLayer(++i);
                        this.addSingleValueLayer(keyword);
                        this.appendValueString(keyword);
                        continue block0;
                    }
                    if ((tdurUnset || tdelayUnset) && ValueFactory.isTimeSACUnit(this.currentValue)) {
                        if (tdurUnset) {
                            value = this.createCSSValue("transition-duration", this.currentValue);
                            if (value != null) {
                                this.lstDuration.add(value);
                                tdurUnset = false;
                                this.nextCurrentValue();
                                continue;
                            }
                        } else {
                            value = this.createCSSValue("transition-delay", this.currentValue);
                            if (value != null) {
                                this.lstDelay.add(value);
                                tdelayUnset = false;
                                this.nextCurrentValue();
                                continue;
                            }
                        }
                    }
                    if (ttfUnset) {
                        if (35 == lut) {
                            if (this.testIdentifiers("transition-timing-function")) {
                                value = this.createCSSValue("transition-timing-function", this.currentValue);
                                this.lstTiming.add(value);
                                ttfUnset = false;
                                this.nextCurrentValue();
                                continue;
                            }
                        } else if (lut == 41 && (value = this.createCSSValue("transition-timing-function", this.currentValue)) != null) {
                            this.lstTiming.add(value);
                            ttfUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    }
                    if (tpropUnset && (lut == 35 || lut == 36)) {
                        value = this.createCSSValue("transition-property", this.currentValue);
                        if (!"none".equals(value.getCssText()) || this.transitionsCount == 1) {
                            this.lstProperty.add(value);
                            tpropUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                        this.lstProperty.clear();
                        this.lstDuration.clear();
                        this.lstTiming.clear();
                        this.lstDelay.clear();
                        this.cssText = "";
                        StyleDeclarationErrorHandler errHandler = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler();
                        if (errHandler != null) {
                            errHandler.shorthandError("transition", "Found 'none' in a multiple declaration");
                        }
                        return false;
                    }
                    StyleDeclarationErrorHandler errHandler = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        if (lut == 35) {
                            errHandler.unknownIdentifier("transition", this.currentValue.getStringValue());
                        } else {
                            AbstractCSSValue val = this.createCSSValue("transition", this.currentValue);
                            errHandler.unassignedShorthandValue("transition", val.getCssText());
                        }
                    }
                    this.nextCurrentValue();
                }
                if (tpropUnset) {
                    this.lstProperty.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-property"));
                }
                if (tdurUnset) {
                    if (i == 0 || this.lstDuration.isEmpty()) {
                        this.lstDuration.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-duration"));
                    } else {
                        this.lstDuration.add(this.lstDuration.item(lastTdurCopied));
                    }
                    if (++lastTdurCopied == i) {
                        lastTdurCopied = 0;
                    }
                }
                if (ttfUnset) {
                    if (i == 0 || this.lstTiming.isEmpty()) {
                        this.lstTiming.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-timing-function"));
                    } else {
                        this.lstTiming.add(this.lstTiming.item(lastTimingCopied));
                    }
                    if (++lastTimingCopied == i) {
                        lastTimingCopied = 0;
                    }
                }
                if (!tdelayUnset) continue;
                if (i == 0 || this.lstDelay.isEmpty()) {
                    this.lstDelay.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-delay"));
                } else {
                    this.lstDelay.add(this.lstDelay.item(lastDelayCopied));
                }
                if (++lastDelayCopied != i) continue;
                lastDelayCopied = 0;
            }
            int sz = this.lstProperty.getLength();
            if (sz > 1) {
                for (i = 1; i < sz; ++i) {
                    AbstractCSSValue value = this.lstProperty.item(i);
                    if (!"all".equals(value.getCssText())) continue;
                    for (int j = i - 1; j != -1; --j) {
                        this.lstDuration.set(j, this.lstDuration.item(i));
                        this.lstTiming.set(j, this.lstTiming.item(i));
                        this.lstDelay.set(j, this.lstDelay.item(i));
                    }
                }
            }
            this.setSubpropertyValue("transition-property", this.lstProperty);
            this.setSubpropertyValue("transition-duration", this.lstDuration);
            this.setSubpropertyValue("transition-timing-function", this.lstTiming);
            this.setSubpropertyValue("transition-delay", this.lstDelay);
            this.flush();
            return true;
        }

        private void clearLayer(int i) {
            if (this.lstProperty.getLength() == i) {
                this.lstProperty.remove(i - 1);
            }
            if (this.lstDuration.getLength() == i) {
                this.lstDuration.remove(i - 1);
            }
            if (this.lstTiming.getLength() == i) {
                this.lstTiming.remove(i - 1);
            }
            if (this.lstDelay.getLength() == i) {
                this.lstDelay.remove(i - 1);
            }
        }

        private void addSingleValueLayer(AbstractCSSValue keyword) {
            this.lstProperty.add(keyword);
            this.lstDuration.add(keyword);
            this.lstTiming.add(keyword);
            this.lstDelay.add(keyword);
        }

        @Override
        protected void nextCurrentValue() {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueString();
        }
    }

    class BorderSideShorthandSetter
    extends ShorthandSetter {
        private String pnameWidth;
        private String pnameStyle;
        private String pnameColor;

        BorderSideShorthandSetter(String shorthandName, String side) {
            super(shorthandName);
            this.pnameWidth = "border-" + side + "-width";
            this.pnameStyle = "border-" + side + "-style";
            this.pnameColor = "border-" + side + "-color";
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if (this.pnameWidth.equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-width") || ValueFactory.isSizeSACUnit(this.currentValue)) {
                    AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameStyle.equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-style")) {
                    AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameColor.equals(subproperty) && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
                AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BorderShorthandSetter
    extends ShorthandSetter {
        BorderShorthandSetter() {
            super("border");
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if ("border-width".equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty) || ValueFactory.isSizeSACUnit(this.currentValue)) {
                    AbstractCSSValue cssValue = this.createCSSValue("border-width", this.currentValue);
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    for (int i = 0; i < subparray.length; ++i) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-style".equals(subproperty)) {
                short utype = this.currentValue.getLexicalUnitType();
                if (35 == utype && this.testIdentifiers(subproperty)) {
                    AbstractCSSValue cssValue = this.createCSSValue("border-style", this.currentValue);
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    for (int i = 0; i < subparray.length; ++i) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-color".equals(subproperty) && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
                AbstractCSSValue cssValue = this.createCSSValue("border-color", this.currentValue);
                String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                for (int i = 0; i < subparray.length; ++i) {
                    this.setSubpropertyValue(subparray[i], cssValue);
                }
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BackgroundShorthandSetter
    extends ShorthandSetter {
        private StringBuilder layerBuffer;
        private int layerCount;
        private OMCSSValueList lstImage;
        private OMCSSValueList lstPosition;
        private OMCSSValueList lstSize;
        private OMCSSValueList lstRepeat;
        private OMCSSValueList lstClip;
        private OMCSSValueList lstOrigin;
        private OMCSSValueList lstAttachment;

        BackgroundShorthandSetter() {
            super("background");
            this.layerBuffer = null;
            this.layerCount = 0;
            this.lstImage = OMCSSValueList.createCSValueList();
            this.lstPosition = OMCSSValueList.createCSValueList();
            this.lstSize = OMCSSValueList.createCSValueList();
            this.lstRepeat = OMCSSValueList.createCSValueList();
            this.lstClip = OMCSSValueList.createCSValueList();
            this.lstOrigin = OMCSSValueList.createCSValueList();
            this.lstAttachment = OMCSSValueList.createCSValueList();
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
            this.countLayers(shorthandValue);
        }

        protected void countLayers(LexicalUnit shorthandValue) {
            this.layerCount = 0;
            int valueCount = 0;
            for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
                if (value.getLexicalUnitType() == 0) {
                    if (valueCount <= 0) continue;
                    ++this.layerCount;
                    valueCount = 0;
                    continue;
                }
                ++valueCount;
            }
            if (valueCount > 0) {
                ++this.layerCount;
            }
        }

        @Override
        protected void appendValueString(CSSValue cssValue) {
            if (cssValue != null) {
                String cssText = cssValue.getCssText();
                if (this.layerBuffer.length() > 0) {
                    this.layerBuffer.append(' ');
                }
                this.layerBuffer.append(cssText);
            }
        }

        @Override
        public boolean assignSubproperties() {
            LinkedList<LexicalUnit> unknownValues = null;
            this.layerBuffer = new StringBuilder(40);
            boolean finalLayer = false;
            int lastCopiedPosition = 0;
            int lastCopiedSize = 0;
            int lastCopiedRepeat = 0;
            int lastCopiedClip = 0;
            int lastCopiedOrigin = 0;
            int lastCopiedAttachment = 0;
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            int i = 0;
            block0: while (i < this.layerCount && this.currentValue != null) {
                boolean validLayer = false;
                HashSet<String> subp = new HashSet<String>(subparray.length);
                subp.addAll(Arrays.asList((Object[])subparray.clone()));
                while (this.currentValue != null) {
                    String sv;
                    BaseCSSDeclarationRule prule;
                    if (this.currentValue.getLexicalUnitType() == 0) {
                        if (validLayer) {
                            ++i;
                            this.appendValueBuffer(this.layerBuffer);
                            this.layerBuffer.setLength(0);
                            if (!finalLayer) {
                                this.layerBuffer.append(',');
                            }
                            if (unknownValues != null) {
                                this.reportUnknownValues(subp, unknownValues);
                                unknownValues = null;
                            }
                        } else {
                            prule = BaseCSSStyleDeclaration.this.getParentRule();
                            if (prule != null) {
                                prule.getStyleDeclarationErrorHandler().shorthandError("background", "Invalid layer found: " + i);
                            }
                            unknownValues = null;
                        }
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        break;
                    }
                    if (this.currentValue.getLexicalUnitType() == 12) {
                        while (this.currentValue != null) {
                            boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                            this.currentValue = this.currentValue.getNextLexicalUnit();
                            if (!commaFound) continue;
                            break;
                        }
                        this.clearLayer(subp, ++i);
                        CSSInheritedValue inherit = CSSInheritedValue.getValue().asSubproperty();
                        this.addSingleValueLayer(inherit);
                        this.layerBuffer.setLength(0);
                        if (i != 1) {
                            this.layerBuffer.append(',');
                        }
                        this.appendValueString(inherit);
                        this.appendValueBuffer(this.layerBuffer);
                        this.layerBuffer.setLength(0);
                        if (i >= this.layerCount || finalLayer) continue block0;
                        this.layerBuffer.append(',');
                        continue block0;
                    }
                    if (this.currentValue.getLexicalUnitType() == 35 && ("initial".equals(sv = this.currentValue.getStringValue().toLowerCase(Locale.US)) || "unset".equals(sv))) {
                        AbstractCSSValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true);
                        while (this.currentValue != null) {
                            boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                            this.currentValue = this.currentValue.getNextLexicalUnit();
                            if (!commaFound) continue;
                            break;
                        }
                        this.clearLayer(subp, ++i);
                        this.addSingleValueLayer(keyword);
                        this.layerBuffer.setLength(0);
                        if (i != 1) {
                            this.layerBuffer.append(',');
                        }
                        this.appendValueString(keyword);
                        this.appendValueBuffer(this.layerBuffer);
                        this.layerBuffer.setLength(0);
                        if (i >= this.layerCount || finalLayer) continue block0;
                        this.layerBuffer.append(',');
                        continue block0;
                    }
                    if (BaseCSSStyleDeclaration.testColor(this.currentValue)) {
                        AbstractCSSValue cssValue = this.createCSSValue("background-color", this.currentValue);
                        this.setSubpropertyValue("background-color", cssValue);
                        subp.remove("background-color");
                        validLayer = true;
                        finalLayer = true;
                        this.nextCurrentValue();
                        continue;
                    }
                    if (this.testBackgroundImage(i, subp)) {
                        this.nextCurrentValue();
                        validLayer = true;
                        continue;
                    }
                    if (this.testBackgroundPosition(this.lstPosition)) {
                        subp.remove("background-position");
                        this.nextCurrentValue();
                        validLayer = true;
                        if (this.currentValue == null || 4 != this.currentValue.getLexicalUnitType()) continue;
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (this.currentValue != null && this.testBackgroundSize(i, subp)) {
                            this.nextCurrentValue();
                            continue;
                        }
                        prule = BaseCSSStyleDeclaration.this.getParentRule();
                        if (prule == null) continue;
                        prule.getStyleDeclarationErrorHandler().shorthandSyntaxError("background", "Size not found after slash");
                        continue;
                    }
                    if (this.testIdentifierProperty(i, subp, "background-attachment", this.lstAttachment)) {
                        this.nextCurrentValue();
                        subp.remove("background-attachment");
                        validLayer = true;
                        continue;
                    }
                    if (this.testBackgroundRepeat(this.lstRepeat)) {
                        subp.remove("background-repeat");
                        validLayer = true;
                        continue;
                    }
                    if (this.testIdentifierProperty(i, subp, "background-origin", this.lstOrigin)) {
                        LexicalUnit lastValue = this.currentValue;
                        this.nextCurrentValue();
                        subp.remove("background-origin");
                        if (this.currentValue != null && this.testIdentifierProperty(i, subp, "background-clip", this.lstClip)) {
                            this.nextCurrentValue();
                        } else {
                            AbstractCSSValue value = this.createCSSValue("background-clip", lastValue);
                            this.lstClip.add(value);
                        }
                        subp.remove("background-clip");
                        validLayer = true;
                        continue;
                    }
                    if (unknownValues == null) {
                        unknownValues = new LinkedList<LexicalUnit>();
                    }
                    unknownValues.add(this.currentValue);
                    this.nextCurrentValue();
                }
                if (unknownValues != null) {
                    this.reportUnknownValues(subp, unknownValues);
                    unknownValues = null;
                }
                if (validLayer && subp.size() > 0) {
                    boolean copiedPosition = false;
                    boolean copiedSize = false;
                    boolean copiedOrigin = false;
                    boolean copiedClip = false;
                    boolean copiedRepeat = false;
                    boolean copiedAttachment = false;
                    for (String pname : subp) {
                        AbstractCSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue(pname);
                        if ("background-image".equals(pname)) {
                            this.lstImage.add(cssVal);
                            continue;
                        }
                        if ("background-position".equals(pname)) {
                            if (i > 1) {
                                this.lstPosition.add(this.lstPosition.item(lastCopiedPosition));
                                copiedPosition = true;
                                continue;
                            }
                            this.lstPosition.add(cssVal);
                            continue;
                        }
                        if ("background-size".equals(pname)) {
                            if (i > 1) {
                                this.lstSize.add(this.lstSize.item(lastCopiedSize));
                                copiedSize = true;
                                continue;
                            }
                            OMCSSValueList list = OMCSSValueList.createWSValueList();
                            list.add(cssVal);
                            list.add(cssVal);
                            this.lstSize.add(list);
                            continue;
                        }
                        if ("background-origin".equals(pname)) {
                            if (i > 1) {
                                this.lstOrigin.add(this.lstOrigin.item(lastCopiedOrigin));
                                copiedOrigin = true;
                                continue;
                            }
                            this.lstOrigin.add(cssVal);
                            continue;
                        }
                        if ("background-clip".equals(pname)) {
                            if (i > 1) {
                                this.lstClip.add(this.lstClip.item(lastCopiedClip));
                                copiedClip = true;
                                continue;
                            }
                            this.lstClip.add(cssVal);
                            continue;
                        }
                        if ("background-repeat".equals(pname)) {
                            if (i > 1) {
                                this.lstRepeat.add(this.lstRepeat.item(lastCopiedRepeat));
                                copiedRepeat = true;
                                continue;
                            }
                            this.lstRepeat.add(cssVal);
                            continue;
                        }
                        if (!"background-attachment".equals(pname)) continue;
                        if (i > 1) {
                            this.lstAttachment.add(this.lstAttachment.item(lastCopiedAttachment));
                            copiedAttachment = true;
                            continue;
                        }
                        this.lstAttachment.add(cssVal);
                    }
                    if (i > 1) {
                        if (copiedPosition) {
                            copiedPosition = false;
                            ++lastCopiedPosition;
                        }
                        if (copiedSize) {
                            copiedSize = false;
                            ++lastCopiedSize;
                        }
                        if (copiedOrigin) {
                            copiedOrigin = false;
                            ++lastCopiedOrigin;
                        }
                        if (copiedClip) {
                            copiedClip = false;
                            ++lastCopiedClip;
                        }
                        if (copiedRepeat) {
                            copiedRepeat = false;
                            ++lastCopiedRepeat;
                        }
                        if (copiedAttachment) {
                            copiedAttachment = false;
                            ++lastCopiedAttachment;
                        }
                    }
                }
                if (!validLayer) {
                    this.layerBuffer.setLength(0);
                }
                if (!finalLayer) continue;
                break;
            }
            this.appendValueBuffer(this.layerBuffer);
            this.setListSubpropertyValue("background-image", this.lstImage);
            this.setListSubpropertyValue("background-position", this.lstPosition);
            this.setListSubpropertyValue("background-size", this.lstSize);
            this.setListSubpropertyValue("background-origin", this.lstOrigin);
            this.setListSubpropertyValue("background-clip", this.lstClip);
            this.setListSubpropertyValue("background-repeat", this.lstRepeat);
            this.setListSubpropertyValue("background-attachment", this.lstAttachment);
            this.flush();
            return true;
        }

        private void clearLayer(Set<String> subp, int i) {
            if (!subp.contains("background-image") && this.lstImage.getLength() == i) {
                this.lstImage.remove(i - 1);
            }
            if (!subp.contains("background-position") && this.lstPosition.getLength() == i) {
                this.lstPosition.remove(i - 1);
            }
            if (!subp.contains("background-size") && this.lstSize.getLength() == i) {
                this.lstSize.remove(i - 1);
            }
            if (!subp.contains("background-origin") && this.lstOrigin.getLength() == i) {
                this.lstOrigin.remove(i - 1);
            }
            if (!subp.contains("background-clip") && this.lstClip.getLength() == i) {
                this.lstClip.remove(i - 1);
            }
            if (!subp.contains("background-repeat") && this.lstRepeat.getLength() == i) {
                this.lstRepeat.remove(i - 1);
            }
            if (!subp.contains("background-attachment") && this.lstAttachment.getLength() == i) {
                this.lstAttachment.remove(i - 1);
            }
        }

        private void addSingleValueLayer(AbstractCSSValue keyword) {
            this.lstImage.add(keyword);
            this.lstPosition.add(keyword);
            this.lstSize.add(keyword);
            this.lstRepeat.add(keyword);
            this.lstOrigin.add(keyword);
            this.lstClip.add(keyword);
            this.lstAttachment.add(keyword);
            if (this.currentValue == null) {
                this.setSubpropertyValue("background-color", keyword);
            }
        }

        private void reportUnknownValues(Set<String> subp, List<LexicalUnit> unknownValues) {
            BaseCSSDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
            if (prule != null) {
                StyleDeclarationErrorHandler eh = prule.getStyleDeclarationErrorHandler();
                if (unknownValues.size() == 1 && unknownValues.get(0).getLexicalUnitType() == 35) {
                    eh.unknownIdentifier("background", unknownValues.get(0).getStringValue());
                } else {
                    eh.unassignedShorthandValues("background", subp.toArray(new String[0]), unknownValues.toArray(new LexicalUnit[0]));
                }
            }
        }

        private void setListSubpropertyValue(String pname, OMCSSValueList list) {
            if (list.getLength() == 1) {
                AbstractCSSValue val = list.item(0);
                if (val.getCssValueType() == 1) {
                    ((AbstractCSSPrimitiveValue)val).setSubproperty(true);
                } else if (val.getCssValueType() == 0) {
                    val = ((CSSInheritedValue)val).asSubproperty();
                } else if (val.getCssValueType() == 2) {
                    ((OMCSSValueList)val).setSubproperty(true);
                }
                this.setSubpropertyValue(pname, val);
            } else {
                list.setSubproperty(true);
                this.setSubpropertyValue(pname, list);
            }
        }

        @Override
        protected void nextCurrentValue() {
            this.appendValueString();
            this.currentValue = this.currentValue.getNextLexicalUnit();
        }

        private boolean testBackgroundImage(int i, Set<String> subp) {
            if (this.currentValue.getLexicalUnitType() == 24 || this.isGradientValue()) {
                this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
                subp.remove("background-image");
                return true;
            }
            if (this.currentValue.getLexicalUnitType() == 35 && "none".equals(this.currentValue.getStringValue())) {
                this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
                subp.remove("background-image");
                return true;
            }
            return false;
        }

        private boolean testBackgroundPosition(OMCSSValueList posList) {
            if (this.currentValue.getLexicalUnitType() == 35 && this.testIdentifiers("background-position") || ValueFactory.isSizeSACUnit(this.currentValue)) {
                OMCSSValueList list = OMCSSValueList.createWSValueList();
                AbstractCSSValue value = this.createCSSValue("background-position", this.currentValue);
                list.add(value);
                int count = 1;
                LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
                while (nlu != null && count < 4) {
                    if (nlu.getLexicalUnitType() == 35 && this.getPropertyDatabase().isIdentifierValue("background-position", nlu.getStringValue()) || ValueFactory.isSizeSACUnit(nlu)) {
                        value = this.createCSSValue("background-position", nlu);
                        list.add(value);
                        count = (short)(count + 1);
                        this.nextCurrentValue();
                        nlu = this.currentValue.getNextLexicalUnit();
                        continue;
                    }
                    nlu = null;
                }
                if (list.getLength() == 1) {
                    posList.add(list.item(0));
                } else if (this.checkPositionProperty(list)) {
                    posList.add(list);
                } else {
                    BaseCSSDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                    if (prule != null) {
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                        ex.setValueText(list.getCssText());
                        prule.getStyleDeclarationErrorHandler().wrongValue("background-position", ex);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean checkPositionProperty(OMCSSValueList list) {
            int count = list.getLength();
            if (count == 2) {
                return true;
            }
            if (count == 4) {
                return ((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(3))).getPrimitiveType() != 21;
            }
            if (((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() != 21) {
                return false;
            }
            if (((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() != 21) {
                return true;
            }
            return ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21;
        }

        private boolean testBackgroundSize(int i, Set<String> subp) {
            if (this.currentValue.getLexicalUnitType() == 35 && this.testIdentifiers("background-size") || ValueFactory.isSizeSACUnit(this.currentValue)) {
                OMCSSValueList list = OMCSSValueList.createWSValueList();
                AbstractCSSValue value = this.createCSSValue("background-size", this.currentValue);
                list.add(value);
                this.layerBuffer.append(" /");
                LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
                if (nlu != null && (nlu.getLexicalUnitType() == 35 && this.getPropertyDatabase().isIdentifierValue("background-size", nlu.getStringValue()) || ValueFactory.isSizeSACUnit(nlu))) {
                    value = this.createCSSValue("background-size", nlu);
                    list.add(value);
                    this.nextCurrentValue();
                }
                if (list.getLength() == 1) {
                    this.lstSize.add(list.item(0));
                } else {
                    this.lstSize.add(list);
                }
                subp.remove("background-size");
                return true;
            }
            return false;
        }

        private boolean testBackgroundRepeat(OMCSSValueList rptList) {
            if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("background-repeat")) {
                AbstractCSSValue value = this.createCSSValue("background-repeat", this.currentValue);
                String s = value.getCssText();
                this.nextCurrentValue();
                if (s.equals("repeat-y") || s.equals("repeat-x")) {
                    rptList.add(value);
                } else if (this.currentValue != null && 35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("background-repeat")) {
                    OMCSSValueList list = OMCSSValueList.createWSValueList();
                    list.add(value);
                    list.add(this.createCSSValue("background-repeat", this.currentValue));
                    rptList.add(list);
                    this.nextCurrentValue();
                } else {
                    rptList.add(value);
                }
                return true;
            }
            return false;
        }

        private boolean testIdentifierProperty(int layer, Set<String> subp, String subpropertyName, OMCSSValueList lst) {
            if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subpropertyName)) {
                AbstractCSSValue value = this.createCSSValue(subpropertyName, this.currentValue);
                lst.add(value);
                return true;
            }
            return false;
        }
    }

    private class BorderColorShorthandSetter
    extends BoxShorthandSetter {
        BorderColorShorthandSetter() {
            super("border-color");
        }

        @Override
        protected short boxValueCount(LexicalUnit topLevelUnit) {
            short valueCount = 0;
            for (LexicalUnit value = topLevelUnit; value != null; value = value.getNextLexicalUnit()) {
                String sv;
                if (BaseCSSStyleDeclaration.testColor(value)) {
                    valueCount = (short)(valueCount + 1);
                    continue;
                }
                if (value.getLexicalUnitType() != 35 || !"initial".equals(sv = value.getStringValue().toLowerCase(Locale.US)) && !"unset".equals(sv)) break;
                valueCount = (short)(valueCount + 1);
            }
            return valueCount;
        }
    }

    private class BorderStyleShorthandSetter
    extends BoxShorthandSetter {
        BorderStyleShorthandSetter() {
            super("border-style");
        }

        @Override
        protected short boxValueCount(LexicalUnit topLevelUnit) {
            String sv;
            short utype;
            short valueCount = 0;
            for (LexicalUnit value = topLevelUnit; value != null && (utype = value.getLexicalUnitType()) == 35 && (sv = value.getStringValue()) != null && ("none".equals(sv = sv.toLowerCase(Locale.US)) || this.getPropertyDatabase().isIdentifierValue("border-style", sv) || "initial".equals(sv) || "unset".equals(sv)); value = value.getNextLexicalUnit()) {
                valueCount = (short)(valueCount + 1);
            }
            return valueCount;
        }
    }

    private class BorderWidthShorthandSetter
    extends BoxShorthandSetter {
        BorderWidthShorthandSetter() {
            super("border-width");
        }

        @Override
        protected short boxValueCount(LexicalUnit topLevelUnit) {
            short valueCount = 0;
            for (LexicalUnit value = topLevelUnit; value != null; value = value.getNextLexicalUnit()) {
                String sv;
                if (ValueFactory.isSizeSACUnit(value)) {
                    valueCount = (short)(valueCount + 1);
                    continue;
                }
                if (value.getLexicalUnitType() != 35 || (sv = value.getStringValue()) == null) break;
                sv = sv.toLowerCase(Locale.US);
                if (!this.getPropertyDatabase().isIdentifierValue("border-width", sv) && !"initial".equals(sv) && !"unset".equals(sv)) break;
                valueCount = (short)(valueCount + 1);
            }
            return valueCount;
        }
    }

    private class MarginShorthandSetter
    extends BoxShorthandSetter {
        MarginShorthandSetter() {
            super("margin");
        }
    }

    class BoxShorthandSetter
    extends ShorthandSetter {
        BoxShorthandSetter(String shorthand) {
            super(shorthand);
        }

        @Override
        public boolean assignSubproperties() {
            if (this.scanForInherited(this.currentValue)) {
                return true;
            }
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            short vcount = this.boxValueCount(this.currentValue);
            switch (vcount) {
                case 1: {
                    AbstractCSSValue cssValue = this.createCSSValue(this.getShorthandName(), this.currentValue);
                    for (int i = 0; i < subparray.length; ++i) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                    }
                    break;
                }
                case 2: {
                    AbstractCSSValue cssValue = this.createCSSValue(subparray[0], this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(subparray[1], this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    break;
                }
                case 3: {
                    AbstractCSSValue cssValue = this.createCSSValue(subparray[0], this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(subparray[1], this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(subparray[2], this.currentValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    break;
                }
                case 4: {
                    for (int i = 0; i < subparray.length; ++i) {
                        AbstractCSSValue cssValue = this.createCSSValue(subparray[i], this.currentValue);
                        this.setSubpropertyValue(subparray[i], cssValue);
                        this.nextCurrentValue();
                    }
                    break;
                }
                default: {
                    StyleDeclarationErrorHandler errHandler = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        errHandler.wrongSubpropertyCount(this.getShorthandName(), vcount);
                    }
                    return false;
                }
            }
            this.flush();
            return true;
        }

        protected short boxValueCount(LexicalUnit topLevelUnit) {
            short valueCount = 0;
            for (LexicalUnit value = topLevelUnit; value != null; value = value.getNextLexicalUnit()) {
                String lcsv;
                String sv;
                if (ValueFactory.isSizeSACUnit(value)) {
                    valueCount = (short)(valueCount + 1);
                    continue;
                }
                if (value.getLexicalUnitType() != 35 || (sv = value.getStringValue()) == null || !"auto".equals(lcsv = sv.toLowerCase(Locale.US).intern()) && !"initial".equals(lcsv) && !"unset".equals(lcsv)) break;
                valueCount = (short)(valueCount + 1);
            }
            return valueCount;
        }
    }

    class FontShorthandSetter
    extends ShorthandSetter {
        private LexicalUnit nextLex;
        private boolean lineHeightSet;

        FontShorthandSetter() {
            super("font");
            this.nextLex = null;
            this.lineHeightSet = false;
        }

        @Override
        protected void nextCurrentValue() {
            super.nextCurrentValue();
            this.nextLex = this.currentValue != null ? this.currentValue.getNextLexicalUnit() : null;
        }

        @Override
        protected List<String> subpropertyList() {
            List<String> subp = super.subpropertyList();
            subp.remove("line-height");
            return subp;
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if (subproperty.equals("font-size") && this.assignFontSize()) {
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 4) {
                    this.nextCurrentValue();
                    AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                    this.setProperty("line-height", cssValue, this.getPriority());
                    this.nextCurrentValue();
                    this.lineHeightSet = true;
                }
                return true;
            }
            switch (this.currentValue.getLexicalUnitType()) {
                case 35: {
                    if (super.assignSubproperty(subproperty)) {
                        return true;
                    }
                    if (!subproperty.equals("font-family")) break;
                    boolean is_set = false;
                    while (this.currentValue != null && (this.nextLex == null || this.nextLex.getLexicalUnitType() == 0)) {
                        AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                        if (cssValue != null) {
                            this.addSubpropertyValue(subproperty, cssValue);
                            is_set = true;
                        }
                        this.nextCurrentValue();
                    }
                    if (is_set) {
                        this.currentValue = null;
                        this.nextLex = null;
                    }
                    return is_set;
                }
                case 36: {
                    if (!subproperty.equals("font-family")) break;
                    boolean is_set = false;
                    while (this.currentValue != null && (this.nextLex == null || this.nextLex.getLexicalUnitType() == 0)) {
                        AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                        if (cssValue != null) {
                            this.addSubpropertyValue(subproperty, cssValue);
                            is_set = true;
                        }
                        this.nextCurrentValue();
                    }
                    return is_set;
                }
                case 13: {
                    if (!subproperty.equals("font-weight")) break;
                    this.setSubpropertyValue("font-weight", this.createCSSValue("font-size", this.currentValue));
                    this.nextCurrentValue();
                    return true;
                }
            }
            return false;
        }

        private boolean assignFontSize() {
            if (this.currentValue.getLexicalUnitType() == 35) {
                return super.assignSubproperty("font-size");
            }
            if (ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
                AbstractCSSValue cssValue = this.createCSSValue("font-size", this.currentValue);
                this.setSubpropertyValue("font-size", cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }

        @Override
        protected void resetSubproperties() {
            super.resetSubproperties();
            if (!this.lineHeightSet) {
                AbstractCSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue("line-height");
                ((AbstractCSSPrimitiveValue)cssVal).setSubproperty(true);
                this.setProperty("line-height", cssVal, this.getPriority());
            }
        }

        @Override
        protected void setSubpropertiesInherit(CSSInheritedValue inherit) {
            super.setSubpropertiesInherit(inherit);
            this.lineHeightSet = true;
        }
    }

    class ShorthandSetter
    implements SubpropertySetter {
        private String shorthandName;
        private String priority = null;
        private PropertyDatabase pdb = PropertyDatabase.getInstance();
        ValueFactory valueFactory = new ValueFactory();
        private HashMap<String, AbstractCSSValue> mypropValue = new HashMap();
        private LinkedList<String> mypropertyList = new LinkedList();
        private LinkedList<String> mypriorities = new LinkedList();
        protected LexicalUnit currentValue = null;
        private StringBuilder valueBuffer = new StringBuilder(40);
        private ArrayList<String> unassignedProperties = new ArrayList(6);
        private List<LexicalUnit> unassignedValues = new ArrayList<LexicalUnit>(8);

        ShorthandSetter(String shorthandName) {
            this.shorthandName = shorthandName;
        }

        public String getShorthandName() {
            return this.shorthandName;
        }

        public String getPriority() {
            return this.priority;
        }

        protected void setPriority(String priority) {
            this.priority = priority;
        }

        public final PropertyDatabase getPropertyDatabase() {
            return this.pdb;
        }

        protected void addUnassignedProperty(String propertyName) {
            this.unassignedProperties.add(propertyName);
            int sz = this.unassignedValues.size();
            if (!(this.currentValue == null || sz != 0 && this.unassignedValues.get(sz - 1).equals(this.currentValue))) {
                this.unassignedValues.add(this.currentValue);
            }
        }

        protected List<String> getUnassignedProperties() {
            return this.unassignedProperties;
        }

        protected void scanUnassigned() {
            BaseCSSDeclarationRule prule;
            if (this.unassignedValues.size() > 0 && (prule = BaseCSSStyleDeclaration.this.getParentRule()) != null) {
                prule.getStyleDeclarationErrorHandler().unassignedShorthandValues(this.getShorthandName(), this.unassignedProperties.toArray(new String[0]), this.unassignedValues.toArray(new LexicalUnit[0]));
            }
        }

        boolean scanForInherited(LexicalUnit lunit) {
            while (lunit != null) {
                if (lunit.getLexicalUnitType() == 12) {
                    CSSInheritedValue inherit = CSSInheritedValue.getValue().asSubproperty();
                    this.setSubpropertiesInherit(inherit);
                    this.initValueString();
                    this.appendValueString(inherit);
                    return true;
                }
                lunit = lunit.getNextLexicalUnit();
            }
            return false;
        }

        boolean scanForCssWideKeywords(LexicalUnit lunit) {
            while (lunit != null) {
                String sv;
                if (lunit.getLexicalUnitType() == 12) {
                    CSSInheritedValue inherit = CSSInheritedValue.getValue().asSubproperty();
                    this.setSubpropertiesInherit(inherit);
                    this.initValueString();
                    this.appendValueString(inherit);
                    return true;
                }
                if (lunit.getLexicalUnitType() == 35 && ((sv = lunit.getStringValue().toLowerCase(Locale.US)).equals("initial") || sv.equals("unset"))) {
                    AbstractCSSValue cssval = new ValueFactory().createCSSValue(lunit);
                    ((AbstractCSSPrimitiveValue)cssval).setSubproperty(true);
                    this.setSubpropertiesToKeyword(cssval);
                    this.initValueString();
                    this.appendValueString(cssval);
                }
                lunit = lunit.getNextLexicalUnit();
            }
            return false;
        }

        void setSubpropertiesInherit(CSSInheritedValue inherit) {
            String[] subparray;
            for (String subp : subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName())) {
                String[] sh;
                if (!this.getPropertyDatabase().isShorthand(subp)) {
                    BaseCSSStyleDeclaration.this.setProperty(subp, inherit, this.getPriority());
                    continue;
                }
                for (String s : sh = this.getPropertyDatabase().getShorthandSubproperties(subp)) {
                    BaseCSSStyleDeclaration.this.setProperty(s, inherit, this.getPriority());
                }
            }
        }

        void setSubpropertiesToKeyword(AbstractCSSValue keyword) {
            String[] subparray;
            for (String subp : subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName())) {
                String[] sh;
                if (!this.getPropertyDatabase().isShorthand(subp)) {
                    BaseCSSStyleDeclaration.this.setProperty(subp, keyword, this.getPriority());
                    continue;
                }
                for (String s : sh = this.getPropertyDatabase().getShorthandSubproperties(subp)) {
                    BaseCSSStyleDeclaration.this.setProperty(s, keyword, this.getPriority());
                }
            }
        }

        protected void nextCurrentValue() {
            if (this.currentValue != null) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 0) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                }
                this.appendValueString();
            }
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
            this.unassignedValues.clear();
            this.initValueString();
            this.appendValueString();
        }

        protected void resetSubproperties() {
            List<String> props = this.getUnassignedProperties();
            for (String pname : props) {
                if (!this.getPropertyDatabase().isShorthand(pname)) {
                    this.setPropertyDefault(pname);
                    continue;
                }
                String[] sh = this.getPropertyDatabase().getShorthandSubproperties(pname);
                for (int i = 0; i < sh.length; ++i) {
                    this.setPropertyDefault(sh[i]);
                }
            }
        }

        private void setPropertyDefault(String pname) {
            AbstractCSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue(pname);
            if (cssVal != null) {
                ((AbstractCSSPrimitiveValue)cssVal).setSubproperty(true);
                this.setProperty(pname, cssVal, this.getPriority());
            } else {
                BaseCSSDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                if (prule != null) {
                    prule.getStyleDeclarationErrorHandler().noDefault(pname);
                }
            }
        }

        protected List<String> subpropertyList() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            ArrayList<String> subp = new ArrayList<String>(subparray.length);
            subp.addAll(Arrays.asList((Object[])subparray.clone()));
            return subp;
        }

        @Override
        public boolean assignSubproperties() {
            if (this.scanForCssWideKeywords(this.currentValue)) {
                return true;
            }
            List<String> subp = this.subpropertyList();
            while (this.currentValue != null) {
                this.unassignedProperties.clear();
                boolean assigned = false;
                for (int i = 0; i < subp.size(); ++i) {
                    String pname = subp.get(i);
                    if (this.currentValue == null) break;
                    if (this.assignSubproperty(pname)) {
                        subp.remove(i);
                        assigned = true;
                        break;
                    }
                    this.addUnassignedProperty(pname);
                }
                if (assigned) continue;
                this.nextCurrentValue();
            }
            if (subp.size() > 0) {
                Iterator<String> it = subp.iterator();
                while (it.hasNext()) {
                    this.addUnassignedProperty(it.next());
                }
                this.scanUnassigned();
            }
            this.resetSubproperties();
            this.flush();
            return true;
        }

        protected boolean assignSubproperty(String subproperty) {
            AbstractCSSValue cssValue;
            short lutype = this.currentValue.getLexicalUnitType();
            if ((lutype == 35 || lutype == 36) && this.assignIdentifiers(subproperty)) {
                return true;
            }
            if (subproperty.endsWith("-color") && BaseCSSStyleDeclaration.testColor(this.currentValue) && (cssValue = this.createCSSValue(subproperty, this.currentValue)) != null) {
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }

        protected boolean assignIdentifiers(String subproperty) {
            if (this.testIdentifiers(subproperty)) {
                AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }

        protected boolean testIdentifiers(String subproperty) {
            return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
        }

        protected void setSubpropertyValue(String subproperty, AbstractCSSValue cssValue) {
            this.setProperty(subproperty, cssValue, this.getPriority());
            int szm1 = this.unassignedValues.size() - 1;
            if (szm1 >= 0 && this.unassignedValues.get(szm1).equals(this.currentValue)) {
                this.unassignedValues.remove(szm1);
                --szm1;
            }
        }

        protected void addSubpropertyValue(String subproperty, AbstractCSSValue cssValue) {
            AbstractCSSValue cssval = this.getDeclaredCSSValue(subproperty);
            if (cssval == null) {
                this.setSubpropertyValue(subproperty, cssValue);
            } else {
                switch (cssval.getCssValueType()) {
                    case 2: {
                        ((OMCSSValueList)cssval).add(cssValue);
                        cssValue = cssval;
                        break;
                    }
                    default: {
                        OMCSSValueList list = OMCSSValueList.createCSValueList();
                        list.add(cssval);
                        list.add(cssValue);
                        cssValue = list;
                    }
                }
                this.setProperty(subproperty, cssValue, this.getPriority());
            }
        }

        protected void setProperty(String subpropertyName, AbstractCSSValue cssValue, String priority) {
            this.mypropertyList.add(subpropertyName);
            this.mypriorities.add(priority);
            this.mypropValue.put(subpropertyName, cssValue);
        }

        protected AbstractCSSValue getDeclaredCSSValue(String propertyName) {
            return this.mypropValue.get(propertyName);
        }

        void flush() {
            int i = 0;
            for (String myproperty : this.mypropertyList) {
                BaseCSSStyleDeclaration.this.setProperty(myproperty, this.mypropValue.get(myproperty), this.mypriorities.get(i));
                ++i;
            }
            this.mypropertyList.clear();
            this.mypriorities.clear();
            this.mypropValue.clear();
        }

        public AbstractCSSValue createCSSValue(String propertyName, LexicalUnit lunit) {
            StyleDeclarationErrorHandler errHandler;
            AbstractCSSValue item = this.valueFactory.createCSSValueItem(lunit, true);
            if (this.valueFactory.hasWarnings() && (errHandler = BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler()) != null) {
                this.valueFactory.handleSyntaxWarnings(errHandler);
            }
            return item;
        }

        protected void initValueString() {
            this.valueBuffer.setLength(0);
        }

        protected void appendValueString(CSSValue cssValue) {
            if (cssValue != null) {
                String cssText = cssValue.getCssText();
                if (this.valueBuffer.length() > 0) {
                    this.valueBuffer.append(' ');
                }
                this.valueBuffer.append(cssText);
            }
        }

        protected void appendValueString() {
            if (this.currentValue != null) {
                AbstractCSSValue currentCss = new ValueFactory().createCSSValueItem(this.currentValue, true);
                this.appendValueString(currentCss);
            }
        }

        protected void appendValueBuffer(StringBuilder buf) {
            this.valueBuffer.append((CharSequence)buf);
        }

        @Override
        public String getCssText() {
            return this.valueBuffer.toString();
        }

        boolean isGradientValue() {
            return this.currentValue.getLexicalUnitType() == 41 && this.currentValue.getFunctionName().toLowerCase(Locale.US).endsWith("-gradient");
        }
    }

    static interface SubpropertySetter {
        public void init(LexicalUnit var1, String var2);

        public boolean assignSubproperties();

        public String getCssText();
    }

    public class StyleDeclarationDocumentHandler
    extends PropertyDocumentHandler
    implements ErrorHandler {
        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            block2: {
                try {
                    super.property(name, value, important);
                }
                catch (DOMException e) {
                    if (BaseCSSStyleDeclaration.this.getParentRule() == null || BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }

        public void warning(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacWarning(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacFatalError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }
    }

    class PropertyDiff
    implements Diff<String> {
        LinkedList<String> leftSide = new LinkedList();
        LinkedList<String> rightSide = new LinkedList();
        LinkedList<String> differentValues = new LinkedList();

        PropertyDiff() {
        }

        @Override
        public boolean hasDifferences() {
            return !this.leftSide.isEmpty() || !this.rightSide.isEmpty() || !this.differentValues.isEmpty();
        }

        public String[] getLeftSide() {
            if (this.leftSide.isEmpty()) {
                return null;
            }
            return this.leftSide.toArray(new String[0]);
        }

        public String[] getRightSide() {
            if (this.rightSide.isEmpty()) {
                return null;
            }
            return this.rightSide.toArray(new String[0]);
        }

        public String[] getDifferent() {
            if (this.differentValues.isEmpty()) {
                return null;
            }
            return this.differentValues.toArray(new String[0]);
        }
    }
}

