/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.RuleStore;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSRuleArrayList
extends ArrayList<AbstractCSSRule>
implements CSSRuleList,
RuleStore {
    private static final long serialVersionUID = 2L;

    public CSSRuleArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public CSSRuleArrayList() {
    }

    public CSSRuleArrayList(Collection<? extends AbstractCSSRule> c) {
        super(c);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public AbstractCSSRule item(int index) {
        if (index >= this.getLength() || index < 0) {
            return null;
        }
        return (AbstractCSSRule)this.get(index);
    }

    @Override
    public int insertRule(CSSRule cssrule, int index) {
        if (index > this.size()) {
            index = this.size();
        } else if (index < 0) {
            index = 0;
        }
        this.add(index, (AbstractCSSRule)cssrule);
        return index;
    }

    public boolean appendRule(AbstractCSSRule rule) {
        return super.add(rule);
    }

    public String toMinifiedString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            sb.append(this.item(i).getMinifiedCssText());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            AbstractCSSRule rule = this.item(i);
            DOMStringList comments = rule.getPrecedingComments();
            if (comments != null) {
                int nc = comments.getLength();
                for (int j = 0; j < nc; ++j) {
                    sb.append("/*").append(comments.item(j)).append("*/\n");
                }
            }
            sb.append(rule.getCssText()).append('\n');
        }
        return sb.toString();
    }
}

