/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.ExtendedCSSStyleSheet;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;

public class DefaultSheetErrorHandler
implements SheetErrorHandler {
    static Logger log = LoggerFactory.getLogger((String)DefaultSheetErrorHandler.class.getName());
    private ExtendedCSSStyleSheet sheet;
    private boolean logged = false;
    private List<AbstractCSSRule> ruleList = null;
    private List<CSSParseException> sacWarnings = null;
    private List<CSSParseException> sacErrors = null;
    private boolean sacWarningMergedState = false;
    private boolean sacErrorMergedState = false;

    public DefaultSheetErrorHandler(ExtendedCSSStyleSheet sheet) {
        this.sheet = sheet;
    }

    private void logSheetInfo() {
        if (!this.logged) {
            this.logged = true;
            String text = "unknown";
            CSSElement owner = (CSSElement)this.sheet.getOwnerNode();
            if (owner != null && "style".equalsIgnoreCase(owner.getTagName())) {
                text = owner.toString();
            } else {
                String uri = this.sheet.getHref();
                if (uri != null) {
                    text = "at " + uri;
                }
            }
            log.warn("Issue(s) with sheet " + text);
        }
    }

    @Override
    public void unknownRuleType(CSSRule rule) {
        this.logSheetInfo();
        log.info("While computing style, found rule of type " + rule.getType());
    }

    @Override
    public void emptyCascade(String selector) {
        if (log.isDebugEnabled()) {
            this.logSheetInfo();
            log.debug("Could not find styles matching selector " + selector);
        }
    }

    @Override
    public void ignoredImport(String uri) {
        this.logSheetInfo();
        log.debug("Ignoring @import from " + uri + ": must be at the beginning of the style sheet (CSS 2.1 \u00a74.1.5)");
    }

    @Override
    public void ruleParsingError(CSSRule rule, CSSParseException ex) {
        this.logSheetInfo();
        log.error("Processing rule of type: " + rule.getType() + ", found error " + ex.getMessage());
    }

    @Override
    public void unexpectedProperty(String name, LexicalUnit value) {
        this.logSheetInfo();
        log.error("Unexpected property " + name + ": " + value.toString());
    }

    @Override
    public void emptyRule(String selector) {
        if (log.isDebugEnabled()) {
            this.logSheetInfo();
            log.debug("Discarding empty Style rule for selector " + selector);
        }
    }

    @Override
    public void emptyMediaList() {
        this.logSheetInfo();
        log.warn("Found a @media rule with empty media list");
    }

    @Override
    public void badMediaList(SACMediaList media) {
        this.logSheetInfo();
        log.warn("Found a rule with a wrong media list: " + media.toString());
    }

    @Override
    public void badAtRule(DOMException e, String atRule) {
        this.logSheetInfo();
        log.warn("Fatal error parsing at-rule: " + atRule, (Throwable)e);
    }

    @Override
    public void inlineStyleError(DOMException e, Element elm, String attr) {
        this.logSheetInfo();
        log.error("Error processing inline style: " + attr, (Throwable)e);
    }

    @Override
    public void computedStyleError(String propertyName, String propertyValue, String message) {
        this.logSheetInfo();
        log.error("Error in computed style, property " + propertyName + ", value " + propertyValue + " (" + message + ")");
    }

    @Override
    public void mapError(CSSParseException exception, AbstractCSSRule rule) {
        if (this.ruleList == null) {
            this.ruleList = new LinkedList<AbstractCSSRule>();
            this.sacErrors = new LinkedList<CSSParseException>();
        }
        this.sacErrors.add(exception);
        this.ruleList.add(rule);
    }

    @Override
    public void handleSacWarning(CSSParseException exception) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<CSSParseException>();
        }
        this.sacWarnings.add(exception);
    }

    public List<CSSParseException> getSacWarnings() {
        return this.sacWarnings;
    }

    @Override
    public void handleSacError(CSSParseException exception) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<CSSParseException>();
            this.ruleList = new LinkedList<AbstractCSSRule>();
        }
        this.sacErrors.add(exception);
        this.ruleList.add(null);
    }

    public List<CSSParseException> getSacErrors() {
        return this.sacErrors;
    }

    public AbstractCSSRule getRuleAtError(int index) {
        return this.ruleList == null ? null : this.ruleList.get(index);
    }

    @Override
    public boolean hasSacErrors() {
        return this.sacErrorMergedState || this.sacErrors != null;
    }

    @Override
    public boolean hasSacWarnings() {
        return this.sacWarningMergedState || this.sacWarnings != null;
    }

    @Override
    public void mergeState(SheetErrorHandler other) {
        this.sacWarningMergedState = this.sacWarningMergedState || other.hasSacWarnings();
        this.sacErrorMergedState = this.sacErrorMergedState || other.hasSacErrors();
    }

    @Override
    public void reset() {
        this.ruleList = null;
        this.sacErrors = null;
        this.sacWarnings = null;
        this.sacErrorMergedState = false;
        this.sacWarningMergedState = false;
    }

    public void logSacErrors() {
        if (this.sacErrors != null) {
            ListIterator<CSSParseException> it = this.sacErrors.listIterator();
            while (it.hasNext()) {
                CSSParseException ex = it.next();
                log.error("SAC error at [" + ex.getLineNumber() + "," + ex.getColumnNumber() + "]: " + ex.getMessage());
            }
        }
    }

    public void logSacWarnings() {
        if (this.sacWarnings != null) {
            ListIterator<CSSParseException> it = this.sacWarnings.listIterator();
            while (it.hasNext()) {
                CSSParseException ex = it.next();
                log.error("SAC warning at [" + ex.getLineNumber() + "," + ex.getColumnNumber() + "]: " + ex.getMessage());
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        if (this.hasSacErrors()) {
            buf.append("SAC Errors:");
            if (this.sacErrors != null) {
                buf.append('\n');
                for (int i = 0; i < this.sacErrors.size(); ++i) {
                    CSSParseException ex = this.sacErrors.get(i);
                    AbstractCSSRule rule = this.ruleList.get(i);
                    buf.append('[').append(ex.getLineNumber()).append(':').append(ex.getColumnNumber()).append("] ").append(ex.getMessage());
                    if (rule != null) {
                        buf.append(" --> ").append(rule.getCssText());
                    }
                    buf.append('\n');
                }
            } else {
                buf.append(" only merged.\n");
            }
        } else {
            buf.append("No SAC errors.\n");
        }
        if (this.sacWarnings != null) {
            buf.append("SAC Warnings:");
            Iterator<CSSParseException> it = this.sacWarnings.iterator();
            while (it.hasNext()) {
                buf.append(' ').append(it.next().getMessage());
            }
        } else {
            buf.append("No SAC warnings.\n");
        }
        return buf.toString();
    }
}

