/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

class MediaQuery {
    public static final byte FEATURE_PLAIN = 0;
    public static final byte FEATURE_EQ = 1;
    public static final byte FEATURE_LT = 2;
    public static final byte FEATURE_LE = 3;
    public static final byte FEATURE_GT = 4;
    public static final byte FEATURE_GE = 5;
    public static final byte FEATURE_LT_AND_LE = 26;
    public static final byte FEATURE_LE_AND_LT = 19;
    public static final byte FEATURE_GE_AND_GT = 37;
    public static final byte FEATURE_GT_AND_GE = 44;
    private String mediaType = null;
    private boolean negativeQuery = false;
    private boolean onlyPrefix = false;
    private final LinkedHashMap<String, CSSValue> featureList = new LinkedHashMap();
    private final HashMap<String, FeatureRange> featureRange = new HashMap();

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setNegative(boolean negative) {
        this.negativeQuery = negative;
    }

    public void setOnlyPrefix(boolean only) {
        this.onlyPrefix = only;
    }

    public boolean matches(String medium, CSSCanvas canvas) {
        if (this.mediaType != null && (this.mediaType.equals(medium) ? this.negativeQuery : !this.negativeQuery)) {
            return false;
        }
        if (!this.featureList.isEmpty()) {
            if (canvas == null) {
                return false;
            }
            block14: for (Map.Entry<String, CSSValue> entry : this.featureList.entrySet()) {
                float fval1;
                String feature = entry.getKey();
                CSSValue value = entry.getValue();
                FeatureRange range = this.featureRange.get(feature);
                byte type = range == null ? (byte)0 : range.rangeType;
                if (type == 0 || type == 1) {
                    if (canvas.supports(feature, value)) continue;
                    return false;
                }
                CSSValue featured = canvas.getFeatureValue(feature);
                if (value == null || value.getCssValueType() != 1 || featured.getCssValueType() != 1 || value.getCssValueType() != 1) {
                    return false;
                }
                short primitype = ((CSSPrimitiveValue)featured).getPrimitiveType();
                float fval = ((CSSPrimitiveValue)featured).getFloatValue(primitype);
                float fval2 = 0.0f;
                try {
                    fval1 = ((CSSPrimitiveValue)value).getFloatValue(primitype);
                }
                catch (DOMException e) {
                    return false;
                }
                if (type >= 6) {
                    if (range.value == null || range.value.getCssValueType() != 1) {
                        return false;
                    }
                    try {
                        fval2 = ((CSSPrimitiveValue)range.value).getFloatValue(primitype);
                    }
                    catch (DOMException e) {
                        return false;
                    }
                }
                switch (type) {
                    case 2: {
                        if (!(fval1 >= fval)) continue block14;
                        return false;
                    }
                    case 3: {
                        if (!(fval1 > fval)) continue block14;
                        return false;
                    }
                    case 4: {
                        if (!(fval1 <= fval)) continue block14;
                        return false;
                    }
                    case 5: {
                        if (!(fval1 < fval)) continue block14;
                        return false;
                    }
                    case 19: {
                        if (!(fval1 > fval) && !(fval >= fval2)) continue block14;
                        return false;
                    }
                    case 26: {
                        if (!(fval1 >= fval) && !(fval > fval2)) continue block14;
                        return false;
                    }
                    case 37: {
                        if (!(fval1 < fval) && !(fval <= fval2)) continue block14;
                        return false;
                    }
                    case 44: {
                        if (!(fval1 <= fval) && !(fval < fval2)) continue block14;
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public String getMedia() {
        StringBuilder buf = new StringBuilder(32);
        if (this.negativeQuery) {
            buf.append("not ");
        } else if (this.onlyPrefix) {
            buf.append("only ");
        }
        if (this.mediaType != null) {
            buf.append(this.mediaType);
        }
        if (!this.featureList.isEmpty()) {
            Iterator<Map.Entry<String, CSSValue>> it = this.featureList.entrySet().iterator();
            if (this.mediaType != null) {
                buf.append(" and (");
            } else {
                buf.append('(');
            }
            this.appendFeature(buf, it.next());
            while (it.hasNext()) {
                buf.append(" and (");
                this.appendFeature(buf, it.next());
            }
        }
        return buf.toString();
    }

    private void appendFeature(StringBuilder buf, Map.Entry<String, CSSValue> entry) {
        String feature = entry.getKey();
        CSSValue value = entry.getValue();
        FeatureRange range = this.featureRange.get(feature);
        byte type = range == null ? (byte)0 : range.rangeType;
        switch (type) {
            case 0: {
                buf.append(feature);
                if (value == null) break;
                buf.append(": ");
                buf.append(value.getCssText());
                break;
            }
            case 1: {
                buf.append(feature);
                buf.append(" = ");
                buf.append(value.getCssText());
                break;
            }
            case 2: {
                buf.append(feature);
                buf.append(" < ");
                buf.append(value.getCssText());
                break;
            }
            case 3: {
                buf.append(feature);
                buf.append(" <= ");
                buf.append(value.getCssText());
                break;
            }
            case 4: {
                buf.append(feature);
                buf.append(" > ");
                buf.append(value.getCssText());
                break;
            }
            case 5: {
                buf.append(feature);
                buf.append(" >= ");
                buf.append(value.getCssText());
                break;
            }
            case 26: {
                buf.append(value.getCssText());
                buf.append(" < ");
                buf.append(feature);
                buf.append(" <= ");
                buf.append(range.value.getCssText());
                break;
            }
            case 19: {
                buf.append(value.getCssText());
                buf.append(" <= ");
                buf.append(feature);
                buf.append(" < ");
                buf.append(range.value.getCssText());
                break;
            }
            case 37: {
                buf.append(value.getCssText());
                buf.append(" >= ");
                buf.append(feature);
                buf.append(" > ");
                buf.append(range.value.getCssText());
                break;
            }
            case 44: {
                buf.append(value.getCssText());
                buf.append(" > ");
                buf.append(feature);
                buf.append(" >= ");
                buf.append(range.value.getCssText());
            }
        }
        buf.append(")");
    }

    public String toString() {
        return this.getMedia();
    }

    public void addFeature(String featureName, byte rangeType, CSSValue value, CSSValue rangevalue) {
        if (featureName == null) {
            throw new IllegalArgumentException("Null feature name");
        }
        this.featureList.put(featureName, value);
        if (rangeType != 0 && rangeType != 1) {
            FeatureRange range = new FeatureRange(rangeType, rangevalue);
            this.featureRange.put(featureName, range);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = 31 * result + (this.negativeQuery ? 1231 : 1237);
        result = 31 * result + (this.onlyPrefix ? 1231 : 1237);
        if (this.featureList != null) {
            TreeSet<String> sorted = new TreeSet<String>(this.featureList.keySet());
            for (String feature : sorted) {
                FeatureRange range;
                result = 31 * result + feature.hashCode();
                CSSValue value = this.featureList.get(feature);
                if (value == null) continue;
                result = 31 * result + value.hashCode();
                if (this.featureRange == null || (range = this.featureRange.get(feature)) == null) continue;
                result = 31 * result + range.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaQuery other = (MediaQuery)obj;
        if (this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType)) {
            return false;
        }
        if (this.negativeQuery != other.negativeQuery) {
            return false;
        }
        if (this.onlyPrefix != other.onlyPrefix) {
            return false;
        }
        if (this.featureList == null) {
            if (other.featureList != null) {
                return false;
            }
        } else {
            if (other.featureList == null) {
                return false;
            }
            if (this.featureList.size() != other.featureList.size()) {
                return false;
            }
            if (this.featureRange == null ? other.featureRange != null : other.featureRange == null) {
                return false;
            }
            TreeSet<String> sorted = new TreeSet<String>(this.featureList.keySet());
            for (String feature : sorted) {
                if (!other.featureList.containsKey(feature)) {
                    return false;
                }
                CSSValue value = this.featureList.get(feature);
                CSSValue othervalue = other.featureList.get(feature);
                if (value != null) {
                    FeatureRange range;
                    if (othervalue == null) {
                        return false;
                    }
                    if (!value.equals(othervalue)) {
                        return false;
                    }
                    if (this.featureRange == null || (range = this.featureRange.get(feature)) == null || range.equals(other.featureRange.get(feature))) continue;
                    return false;
                }
                if (othervalue == null) continue;
                return false;
            }
        }
        return true;
    }

    static class FeatureRange {
        CSSValue value;
        byte rangeType;

        FeatureRange(byte rangeType, CSSValue value) {
            this.rangeType = rangeType;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = this.rangeType == 0 ? 1 : this.rangeType;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            byte otherefftype;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureRange other = (FeatureRange)obj;
            byte efftype = this.rangeType == 0 ? (byte)1 : this.rangeType;
            if (efftype != (otherefftype = other.rangeType == 0 ? (byte)1 : other.rangeType)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

