/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.MediaQueryHandler;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.TokenProducer;
import java.util.Locale;
import org.w3c.dom.css.CSSValue;

class MediaQueryParser {
    MediaQueryParser() {
    }

    public static void parse(String mediaQueryString, MediaQueryHandler mqhandler) {
        int[] allowInWords = new int[]{45, 95};
        MQTokenHandler handler = new MQTokenHandler(mqhandler);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(mediaQueryString);
    }

    private static CSSValue parseProperty(String stringValue) {
        AbstractCSSValue value;
        try {
            value = new ValueFactory().parseProperty(stringValue);
        }
        catch (RuntimeException e) {
            value = null;
        }
        return value;
    }

    private static boolean isKnownFeature(String string) {
        return string.startsWith("min-") || string.startsWith("max-") || MediaQueryFactory.isMediaFeature(string);
    }

    private static boolean isValidFeatureSyntax(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    static class MQTokenHandler
    implements TokenProducer.TokenHandler {
        MediaQueryHandler handler;
        byte stage = 0;
        StringBuilder buffer = new StringBuilder(64);
        boolean spaceFound = false;
        String featureName = null;
        String firstValue = null;
        int prevcp = 32;
        boolean functionToken = false;
        short parendepth = 0;
        byte rangeType = 0;

        MQTokenHandler(MediaQueryHandler handler) {
            this.handler = handler;
        }

        private void reverseRangetype() {
            if ((this.rangeType & 2) == 2) {
                this.rangeType = (byte)(this.rangeType ^ 2);
                this.rangeType = (byte)(this.rangeType | 4);
            } else if ((this.rangeType & 4) == 4) {
                this.rangeType = (byte)(this.rangeType ^ 4);
                this.rangeType = (byte)(this.rangeType | 2);
            }
        }

        @Override
        public void word(int index, String word) {
            if (this.stage == 127) {
                return;
            }
            String lctoken = word.toLowerCase(Locale.US);
            if (this.functionToken) {
                if (this.buffer.length() != 0) {
                    this.buffer.append(' ');
                }
                this.buffer.append(word);
            } else if ("not".equals(lctoken)) {
                if (this.stage != 0) {
                    this.handler.invalidQuery("Found 'not' at the wrong parsing stage");
                } else {
                    this.handler.negativeQuery();
                }
            } else if ("only".equals(lctoken)) {
                if (this.stage != 0) {
                    this.handler.invalidQuery("Found 'only' at the wrong parsing stage");
                } else {
                    this.handler.onlyPrefix();
                }
            } else if ("and".equals(lctoken)) {
                this.stage = (byte)2;
            } else if ("or".equals(lctoken)) {
                this.handler.invalidQuery("Found 'or'");
            } else if (this.stage == 0) {
                this.handler.mediaType(word);
                this.stage = 1;
            } else if (this.stage == 5) {
                this.featureName = word;
                this.stage = (byte)6;
            } else {
                if (this.buffer.length() != 0 && this.prevcp == 32) {
                    this.spaceFound = true;
                    this.buffer.append(' ');
                }
                this.buffer.append(word);
            }
            this.prevcp = 65;
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                if (this.prevcp != 32) {
                    this.functionToken = true;
                    this.buffer.append('(');
                } else if (this.stage == 2 || this.stage == 0) {
                    this.stage = (byte)3;
                }
                this.parendepth = (short)(this.parendepth + 1);
            } else {
                this.handler.invalidQuery("Unexpected " + new String(Character.toChars(codepoint)));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.parendepth = (short)(this.parendepth - 1);
                if (this.functionToken) {
                    this.buffer.append(')');
                    this.functionToken = false;
                } else {
                    if (this.stage == 6) {
                        String tempstr;
                        if (this.firstValue == null) {
                            this.firstValue = this.buffer.toString();
                        }
                        if (MediaQueryParser.isKnownFeature(this.firstValue)) {
                            tempstr = this.firstValue;
                            this.firstValue = this.featureName;
                            this.featureName = tempstr;
                        } else if (!MediaQueryParser.isKnownFeature(this.featureName)) {
                            if (MediaQueryParser.isValidFeatureSyntax(this.firstValue)) {
                                tempstr = this.firstValue;
                                this.firstValue = this.featureName;
                                this.featureName = tempstr;
                            } else {
                                if (!MediaQueryParser.isValidFeatureSyntax(this.featureName)) {
                                    this.handler.invalidQuery("Wrong feature expression near " + this.featureName + " " + this.firstValue + ")");
                                    this.prevcp = codepoint;
                                    return;
                                }
                                this.reverseRangetype();
                            }
                        } else {
                            this.reverseRangetype();
                        }
                        CSSValue value1 = MediaQueryParser.parseProperty(this.firstValue);
                        if (value1 == null) {
                            this.error(index, (byte)5, this.firstValue);
                        } else {
                            this.handler.featureRange(this.featureName, this.rangeType, value1, null);
                        }
                    } else if (this.buffer.length() != 0) {
                        if (this.stage == 4) {
                            CSSValue value = MediaQueryParser.parseProperty(this.buffer.toString());
                            if (value == null) {
                                this.error(index, (byte)5, this.buffer.toString());
                            } else {
                                this.handler.featureValue(this.featureName, value);
                            }
                        } else if (this.stage == 7) {
                            CSSValue value1 = MediaQueryParser.parseProperty(this.firstValue);
                            CSSValue value2 = MediaQueryParser.parseProperty(this.buffer.toString());
                            if (value1 == null) {
                                this.error(index, (byte)5, this.firstValue);
                            } else if (value2 == null) {
                                this.error(index, (byte)5, this.buffer.toString());
                            } else {
                                this.handler.featureRange(this.featureName, this.rangeType, value1, value2);
                            }
                        } else if (this.stage == 3 && !this.spaceFound) {
                            this.handler.featureValue(this.buffer.toString(), null);
                        } else {
                            this.error(index, (byte)32, this.buffer.toString());
                        }
                        this.buffer.setLength(0);
                    } else {
                        this.handler.invalidQuery("Unexpected )");
                    }
                    if (this.stage == 5) {
                        this.handler.invalidQuery("Unexpected )");
                    } else {
                        this.rangeType = 0;
                        this.stage = 1;
                    }
                }
            } else {
                this.handler.invalidQuery("Unexpected " + new String(Character.toChars(codepoint)));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.functionToken) {
                this.buffer.append(Character.toChars(codepoint));
            } else {
                if (codepoint == 58) {
                    if (this.buffer.length() != 0) {
                        this.featureName = this.buffer.toString();
                        this.buffer.setLength(0);
                        this.stage = (byte)4;
                    } else {
                        this.handler.invalidQuery("Empty feature name");
                    }
                } else if (codepoint == 44) {
                    if (this.parendepth != 0) {
                        this.handler.invalidQuery("Unmatched parenthesis");
                    } else if (this.stage == 0) {
                        this.handler.invalidQuery("No media found");
                    }
                    this.stage = 0;
                    this.prevcp = 32;
                    this.spaceFound = false;
                    this.handler.endQuery();
                } else if (codepoint == 46) {
                    if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                        this.buffer.append('.');
                    } else {
                        this.handler.invalidQuery("Unexpected '.'");
                    }
                } else if (codepoint == 47) {
                    if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                        this.buffer.append('/');
                    } else {
                        this.handler.invalidQuery("Unexpected '/'");
                    }
                } else if (codepoint == 59) {
                    this.error(index, (byte)4, ";");
                } else if (codepoint == 60) {
                    if (this.stage < 3 || this.rangeType > 5) {
                        this.handler.invalidQuery("Unexpected <");
                    } else if (this.stage != 6) {
                        this.rangeType = (byte)(this.rangeType | 2);
                        this.stage = (byte)5;
                    } else {
                        this.rangeType = (byte)(this.rangeType | 0x10);
                        this.stage = (byte)7;
                    }
                } else if (codepoint == 61) {
                    if (this.stage < 3 || this.rangeType > 5) {
                        this.handler.invalidQuery("Unexpected =");
                    } else if (this.stage != 6) {
                        this.rangeType = (byte)(this.rangeType | 1);
                        this.stage = (byte)5;
                    } else {
                        this.rangeType = (byte)(this.rangeType | 8);
                        this.stage = (byte)7;
                    }
                } else if (codepoint == 62 || this.rangeType > 5) {
                    if (this.stage < 3) {
                        this.handler.invalidQuery("Unexpected >");
                    } else if (this.stage != 6) {
                        this.rangeType = (byte)(this.rangeType | 4);
                        this.stage = (byte)5;
                    } else {
                        this.rangeType = (byte)(this.rangeType | 0x20);
                        this.stage = (byte)7;
                    }
                } else {
                    this.handler.invalidQuery("Unexpected " + new String(Character.toChars(codepoint)));
                }
                if (this.stage == 5 && this.firstValue == null && this.buffer.length() != 0) {
                    this.firstValue = this.buffer.toString();
                    this.buffer.setLength(0);
                }
            }
            this.prevcp = codepoint;
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            if (this.buffer.length() != 0) {
                this.buffer.append(' ');
            }
            this.buffer.append('\'').append(quoted).append('\'');
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            if (this.buffer.length() != 0) {
                this.buffer.append(' ');
            }
            this.buffer.append('\"').append(quoted).append('\"');
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.stage != 127) {
                this.buffer.append('\\').append(Character.toChars(codepoint));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void separator(int index, int cp) {
            this.prevcp = 32;
        }

        @Override
        public void control(int index, int codepoint) {
            this.prevcp = 32;
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handler.invalidQuery("Unmatched parenthesis");
            } else if (this.stage > 1) {
                this.handler.invalidQuery("Unexpected end of media text");
            } else if (this.buffer.length() != 0) {
                this.handler.invalidQuery("Unexpected text: " + this.buffer.toString());
            }
            this.handler.endQuery();
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            this.handler.invalidQuery("Bad query near: " + context.toString());
            this.stage = (byte)127;
        }
    }
}

