/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.OMMediaList;
import java.io.IOException;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;

public class OMCSSImportRule
extends BaseCSSRule
implements CSSImportRule,
ExtendedCSSRule {
    private AbstractCSSStyleSheet loadedSheet = null;
    private String styleSheetURI = null;
    private MediaQueryList mediaList;

    public OMCSSImportRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)3, origin);
        this.mediaList = OMMediaList.createMediaList();
    }

    OMCSSImportRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, short origin) {
        super(parentSheet, (short)3, origin);
        this.mediaList = mediaList;
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public AbstractCSSStyleSheet getStyleSheet() {
        return this.loadedSheet;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("@import url(\"").append(this.getStyleSheet().getHref()).append("\")");
        if (!this.mediaList.isAllMedia()) {
            sb.append(' ').append(this.mediaList.getMediaText());
        }
        return sb.append(';').toString();
    }

    public boolean loadStyleSheet(String uri, String title, SACMediaList media) throws CSSException, IOException, DOMException {
        URL styleSheetURL = this.getURL(uri);
        this.styleSheetURI = styleSheetURL.toExternalForm();
        ((MediaListAccess)((Object)this.mediaList)).appendSACMediaList(media);
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (title == null && parentSS != null) {
            title = parentSS.getTitle();
        }
        BaseCSSStyleSheet css = (BaseCSSStyleSheet)parentSS.getStyleSheetFactory().createRuleStyleSheet(this, title, this.mediaList);
        css.setParentStyleSheet(parentSS);
        this.loadedSheet = css;
        return css.loadStyleSheet(styleSheetURL);
    }

    @Override
    public OMCSSImportRule clone(AbstractCSSStyleSheet parentSheet) {
        OMCSSImportRule rule = new OMCSSImportRule(parentSheet, ((MediaListAccess)((Object)this.getMedia())).unmodifiable(), this.getOrigin());
        rule.styleSheetURI = this.getHref();
        rule.loadedSheet = this.getStyleSheet();
        return rule;
    }
}

