/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.CSSSupportsRule;
import io.sf.carte.doc.style.css.SupportsCondition;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.OMCSSGroupingRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.Iterator;
import org.w3c.css.sac.CSSParseException;
import org.w3c.dom.DOMException;

public class OMCSSSupportsRule
extends OMCSSGroupingRule
implements CSSSupportsRule {
    private SupportsCondition condition = null;

    public OMCSSSupportsRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)12, origin);
    }

    OMCSSSupportsRule(AbstractCSSStyleSheet parentSheet, OMCSSSupportsRule copyfrom) {
        super(parentSheet, copyfrom);
        this.condition = copyfrom.getCondition();
    }

    @Override
    public String getConditionText() {
        return this.condition.toString();
    }

    @Override
    public void setConditionText(String conditionText) throws CSSParseException {
        this.parseConditionText(conditionText, null);
    }

    private void parseConditionText(String conditionText, AbstractCSSRule rule) {
        CSSParser parser = new CSSParser();
        this.condition = parser.parseSupportsCondition(conditionText, rule);
    }

    @Override
    public SupportsCondition getCondition() {
        return this.condition;
    }

    @Override
    public boolean supports(CSSCanvas canvas) {
        return false;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
        sb.append("@supports ").append(this.getConditionText()).append(" {\n");
        Iterator it = this.getCssRules().iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getCssText()).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
        String cond = this.condition.getMinifiedText();
        sb.append("@supports");
        if (cond.length() != 0 && cond.charAt(0) != '(') {
            sb.append(' ');
        }
        sb.append(cond);
        sb.append("{");
        Iterator it = this.getCssRules().iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int lm1 = cssText.length() - 1;
        int idx = cssText.indexOf(123);
        if (idx == -1 || lm1 < 16 || cssText.charAt(lm1) != '}') {
            throw new DOMException(12, "Invalid @supports rule: " + cssText);
        }
        CharSequence atkeyword = cssText.subSequence(0, 10);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@supports")) {
            throw new DOMException(12, "Not a @supports rule: " + cssText);
        }
        this.parseConditionText(cssText.substring(10, idx).trim(), this);
        super.setCssText(cssText.substring(idx + 1, lm1));
    }

    @Override
    public OMCSSSupportsRule clone(AbstractCSSStyleSheet parentSheet) {
        return new OMCSSSupportsRule(parentSheet, this);
    }
}

