/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition2;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.nsac.PositionalCondition2;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class NSACSelectorFactory
implements Parser2.NamespaceMap {
    private ElementSelector universalSelector = (ElementSelector)universalSelectorList.item(0);
    private static SelectorList universalSelectorList = new SingleSelectorList((Selector)new AnyNodeSelector());
    private HashMap<String, String> mapNsPrefix2Uri = null;

    NSACSelectorFactory() {
    }

    ElementSelector getUniversalSelector(String namespacePrefix) {
        if (namespacePrefix == null) {
            return this.universalSelector;
        }
        return this.createUniversalSelector(this.getNamespaceURI(namespacePrefix));
    }

    ElementSelector getUniversalSelector() {
        return this.universalSelector;
    }

    SelectorList getUniversalSelectorList() {
        return universalSelectorList;
    }

    ElementSelector createUniversalSelector(String namespaceUri) {
        return new UniversalSelector(namespaceUri);
    }

    ElementSelectorImpl createElementSelector() {
        return new ElementSelectorImpl();
    }

    DescendantSelectorImpl createDescendantSelector(short type, Selector ancestorSelector) {
        if (ancestorSelector == null) {
            ancestorSelector = this.getUniversalSelector();
        }
        return new DescendantSelectorImpl(type, ancestorSelector);
    }

    SiblingSelectorImpl createSiblingSelector(short type, Selector firstSelector) {
        if (firstSelector == null) {
            firstSelector = this.getUniversalSelector();
        }
        return new SiblingSelectorImpl(type, firstSelector);
    }

    ConditionalSelectorImpl createConditionalSelector(SimpleSelector selector, Condition condition) throws CSSException {
        if (selector == null) {
            selector = this.getUniversalSelector();
        }
        return new ConditionalSelectorImpl(selector, condition);
    }

    void registerNamespacePrefix(String prefix, String uri) {
        if (this.mapNsPrefix2Uri == null) {
            this.mapNsPrefix2Uri = new HashMap();
        }
        this.mapNsPrefix2Uri.put(prefix, uri);
    }

    @Override
    public String getNamespaceURI(String nsPrefix) {
        return this.mapNsPrefix2Uri != null ? this.mapNsPrefix2Uri.get(nsPrefix) : null;
    }

    String getNamespacePrefix(String namespaceUri) {
        for (Map.Entry<String, String> me : this.mapNsPrefix2Uri.entrySet()) {
            if (!namespaceUri.equals(me.getValue())) continue;
            return me.getKey();
        }
        return null;
    }

    Condition createCondition(short type) {
        switch (type) {
            case 9: {
                AttributeConditionImpl cond = new AttributeConditionImpl(type);
                cond.caseSensitive = false;
                return cond;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                return new AttributeConditionImpl(type);
            }
            case 6: {
                return new LangConditionImpl();
            }
            case 3: {
                return new PositionalConditionImpl();
            }
            case 0: {
                return new CombinatorConditionImpl();
            }
            case 17: {
                return new SelectorArgumentConditionImpl();
            }
        }
        return null;
    }

    static /* synthetic */ SelectorList access$000() {
        return universalSelectorList;
    }

    static class SelectorArgumentConditionImpl
    implements ArgumentCondition {
        String name = null;
        SelectorList arguments = null;

        SelectorArgumentConditionImpl() {
        }

        public short getConditionType() {
            return 17;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        @Override
        public SelectorList getSelectors() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(':').append(this.getName()).append('(').append(this.arguments.toString()).append(')');
            return buf.toString();
        }
    }

    static class CombinatorConditionImpl
    implements CombinatorCondition {
        Condition first = null;
        Condition second = null;

        CombinatorConditionImpl() {
        }

        public short getConditionType() {
            return 0;
        }

        public Condition getFirstCondition() {
            return this.first;
        }

        public Condition getSecondCondition() {
            return this.second;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getFirstCondition().toString());
            if (this.second != null) {
                buf.append(this.second.toString());
            } else {
                buf.append('?');
            }
            return buf.toString();
        }
    }

    static class PositionalConditionImpl
    implements PositionalCondition2 {
        int offset = 1;
        int slope = 0;
        boolean forwardCondition = true;
        boolean oftype = false;
        boolean needsArgument = false;
        SelectorList ofList = NSACSelectorFactory.access$000();

        PositionalConditionImpl() {
        }

        public short getConditionType() {
            return 3;
        }

        @Override
        public boolean isForwardCondition() {
            return this.forwardCondition;
        }

        @Override
        public boolean isOfType() {
            return this.oftype;
        }

        public int getPosition() {
            if (this.slope != 0) {
                return 0;
            }
            if (!this.forwardCondition) {
                return -this.offset;
            }
            return this.offset;
        }

        @Override
        public int getFactor() {
            return this.slope;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        public boolean getTypeNode() {
            return true;
        }

        public boolean getType() {
            return this.oftype;
        }

        @Override
        public SelectorList getOfList() {
            return this.ofList;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(':');
            int slope = this.getFactor();
            if (this.oftype) {
                if (slope == 0) {
                    if (this.getPosition() == 1) {
                        buf.append("first-of-type");
                    } else if (this.getPosition() == -1) {
                        buf.append("last-of-type");
                    } else {
                        if (this.forwardCondition) {
                            buf.append("nth-of-type(");
                        } else {
                            buf.append("nth-last-of-type(");
                        }
                        buf.append(this.offset).append(')');
                    }
                } else {
                    if (this.forwardCondition) {
                        buf.append("nth-of-type(");
                    } else {
                        buf.append("nth-last-of-type(");
                    }
                    buf.append(slope).append('n');
                    if (this.offset > 0) {
                        buf.append('+');
                    }
                    buf.append(this.offset).append(')');
                }
            } else if (slope == 0) {
                if (this.offset == 1 && this.isUniversalOfList()) {
                    if (this.forwardCondition) {
                        buf.append("first-child");
                    } else {
                        buf.append("last-child");
                    }
                } else {
                    if (this.forwardCondition) {
                        buf.append("nth-child(");
                    } else {
                        buf.append("nth-last-child(");
                    }
                    buf.append(this.offset);
                    if (!this.isUniversalOfList()) {
                        buf.append(" of ").append(this.ofList.toString());
                    }
                    buf.append(')');
                }
            } else {
                if (this.forwardCondition) {
                    buf.append("nth-child(");
                } else {
                    buf.append("nth-last-child(");
                }
                buf.append(slope).append('n');
                if (this.offset > 0) {
                    buf.append('+');
                }
                buf.append(this.offset);
                if (!this.isUniversalOfList()) {
                    buf.append(" of ").append(this.ofList.toString());
                }
                buf.append(')');
            }
            return buf.toString();
        }

        private boolean isUniversalOfList() {
            if (this.ofList == null) {
                return true;
            }
            for (int i = 0; i < this.ofList.getLength(); ++i) {
                if (this.ofList.item(i).getSelectorType() != 1) continue;
                return true;
            }
            return false;
        }
    }

    static class LangConditionImpl
    implements LangCondition {
        String lang = null;

        LangConditionImpl() {
        }

        public short getConditionType() {
            return 6;
        }

        public String getLang() {
            return this.lang;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(":lang(").append(this.getLang()).append(')');
            return buf.toString();
        }
    }

    class AttributeConditionImpl
    implements AttributeCondition2 {
        short type;
        String namespaceURI = null;
        String localName = null;
        String value = null;
        boolean caseSensitive = true;

        AttributeConditionImpl(short type) {
            this.type = type;
        }

        public short getConditionType() {
            return this.type;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getLocalName() {
            return this.localName;
        }

        public boolean getSpecified() {
            return this.value != null;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            short condtype = this.getConditionType();
            switch (condtype) {
                case 4: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    if (this.getSpecified()) {
                        buf.append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                        if (!this.caseSensitive) {
                            buf.append(' ').append('i');
                        }
                    }
                    buf.append(']');
                    break;
                }
                case 8: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('|').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    buf.append(']');
                    break;
                }
                case 7: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('~').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    buf.append(']');
                    break;
                }
                case 14: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('^').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    buf.append(']');
                    break;
                }
                case 15: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('$').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    buf.append(']');
                    break;
                }
                case 16: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('*').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    buf.append(']');
                    break;
                }
                case 9: {
                    buf.append('.').append(this.getEscapedValue());
                    break;
                }
                case 5: {
                    buf.append('#').append(this.getEscapedValue());
                    break;
                }
                case 10: {
                    buf.append(':').append(this.getEscapedLocalName());
                    if (this.value == null) break;
                    buf.append('(').append(this.getEscapedValue()).append(')');
                    break;
                }
                case 6: {
                    buf.append(":lang(").append(this.getValue()).append(')');
                    break;
                }
                case 11: {
                    buf.append(":only-child");
                    break;
                }
                case 12: {
                    buf.append(":only-of-type");
                    break;
                }
                case 18: {
                    buf.append(':').append(':').append(this.getEscapedLocalName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + condtype);
                }
            }
            return buf.toString();
        }

        private String getEscapedLocalName() {
            return this.localName != null ? ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(this.localName)) : "";
        }

        private void appendEscapedQName(StringBuilder buf) {
            if (this.namespaceURI != null) {
                if (this.namespaceURI.length() != 0) {
                    String nspre = NSACSelectorFactory.this.getNamespacePrefix(this.namespaceURI);
                    if (nspre != null && nspre.length() != 0) {
                        buf.append(nspre).append("|");
                    }
                } else {
                    buf.append("|");
                }
            }
            if (this.localName != null) {
                buf.append(ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(this.localName)));
            }
        }

        private String getEscapedValue() {
            return this.value != null ? ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(this.value)) : "";
        }

        private String getControlEscapedValue() {
            return this.value != null ? ParseHelper.escapeControl(ParseHelper.escapeBackslash(this.value)) : "";
        }
    }

    static class ConditionalSelectorImpl
    implements ConditionalSelector {
        SimpleSelector selector;
        Condition condition;

        ConditionalSelectorImpl(SimpleSelector selector, Condition condition) {
            this.selector = selector;
            this.condition = condition;
        }

        public short getSelectorType() {
            return 0;
        }

        public SimpleSelector getSimpleSelector() {
            return this.selector;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            short simpletype = this.selector.getSelectorType();
            if (simpletype != 1) {
                buf.append(this.selector.toString());
            }
            buf.append(this.condition.toString());
            return buf.toString();
        }
    }

    static class SiblingSelectorImpl
    implements SiblingSelector {
        private short type;
        SimpleSelector siblingSelector = null;
        Selector selector;

        SiblingSelectorImpl(short type, Selector selector) {
            this.type = type;
            this.selector = selector;
        }

        public short getSelectorType() {
            return this.type;
        }

        public short getNodeType() {
            return 201;
        }

        public Selector getSelector() {
            return this.selector;
        }

        public SimpleSelector getSiblingSelector() {
            return this.siblingSelector;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.selector.toString());
            switch (this.type) {
                case 12: {
                    buf.append('+');
                    break;
                }
                case 13: {
                    buf.append('~');
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + this.type);
                }
            }
            if (this.siblingSelector != null) {
                buf.append(this.siblingSelector.toString());
            } else {
                buf.append('?');
            }
            return buf.toString();
        }
    }

    static class DescendantSelectorImpl
    implements DescendantSelector {
        private short type;
        Selector ancestorSelector;
        SimpleSelector simpleSelector = null;

        DescendantSelectorImpl(short type, Selector ancestorSelector) {
            this.type = type;
            this.ancestorSelector = ancestorSelector;
        }

        void setSelectorType(short newType) {
            this.type = newType;
        }

        public short getSelectorType() {
            return this.type;
        }

        public Selector getAncestorSelector() {
            return this.ancestorSelector;
        }

        public SimpleSelector getSimpleSelector() {
            return this.simpleSelector;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.ancestorSelector.toString());
            switch (this.type) {
                case 11: {
                    buf.append('>');
                    break;
                }
                case 10: {
                    buf.append(' ');
                    break;
                }
                case 14: {
                    buf.append('|').append('|');
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + this.type);
                }
            }
            if (this.simpleSelector != null) {
                buf.append(this.simpleSelector.toString());
            } else {
                buf.append('?');
            }
            return buf.toString();
        }
    }

    class ElementSelectorImpl
    implements ElementSelector {
        String namespaceUri = null;
        String localName = null;

        ElementSelectorImpl() {
        }

        void setNamespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        void setLocalName(String localName) {
            this.localName = localName;
        }

        public short getSelectorType() {
            return 4;
        }

        public String getNamespaceURI() {
            return this.namespaceUri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String toString() {
            if (this.namespaceUri != null) {
                if (this.namespaceUri.length() != 0) {
                    String nspre = NSACSelectorFactory.this.getNamespacePrefix(this.namespaceUri);
                    if (nspre != null && nspre.length() != 0) {
                        return nspre + "|" + this.getLocalName();
                    }
                } else {
                    return "|" + this.getLocalName();
                }
            }
            return this.getLocalName();
        }
    }

    static class SingleSelectorList
    implements SelectorList {
        Selector selector;

        public SingleSelectorList(Selector selector) {
            this.selector = selector;
        }

        public int getLength() {
            return 1;
        }

        public Selector item(int index) {
            if (index != 0) {
                return null;
            }
            return this.selector;
        }

        public String toString() {
            return this.selector.toString();
        }
    }

    class UniversalSelector
    extends ElementSelectorImpl {
        UniversalSelector(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        @Override
        public short getSelectorType() {
            return 1;
        }

        @Override
        public String getLocalName() {
            return "*";
        }

        @Override
        public String toString() {
            if (this.namespaceUri == null) {
                return "*";
            }
            return NSACSelectorFactory.this.getNamespacePrefix(this.namespaceUri) + "|*";
        }
    }

    static class AnyNodeSelector
    implements ElementSelector {
        AnyNodeSelector() {
        }

        public short getSelectorType() {
            return 1;
        }

        public String getLocalName() {
            return "*";
        }

        public String getNamespaceURI() {
            return null;
        }

        public String toString() {
            return "*";
        }
    }
}

