/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSNumberValue
extends AbstractCSSPrimitiveValue {
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";
    private boolean asInteger = false;
    boolean lengthUnitType = false;

    CSSNumberValue() {
    }

    protected CSSNumberValue(CSSNumberValue copied) {
        super(copied);
        this.realvalue = copied.realvalue;
        this.asInteger = copied.asInteger;
        this.dimensionUnitText = copied.dimensionUnitText;
    }

    @Override
    public String getCssText() {
        boolean notaNumber;
        boolean bl = notaNumber = this.getPrimitiveType() != 1;
        if (this.realvalue == 0.0f && notaNumber && this.getPrimitiveType() != 2 && this.isLengthUnitType()) {
            return "0";
        }
        double rintValue = Math.rint(this.realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)this.realvalue == rintValue ? notaNumber : this.getPrimitiveType() == 2) {
            return Integer.toString((int)rintValue) + this.dimensionUnitText;
        }
        return Float.toString(this.realvalue) + this.dimensionUnitText;
    }

    private boolean isLengthUnitType() {
        return this.lengthUnitType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify the whole style declaration.");
        }
        this.setCSSUnitType(unitType);
        this.realvalue = floatValue;
        this.dimensionUnitText = CSSNumberValue.dimensionUnitString(unitType);
        this.asInteger = unitType == 1 && (float)Math.rint(floatValue) == this.realvalue;
    }

    public void setFloatValuePt(float floatValue) {
        this.setCSSUnitType((short)9);
        this.realvalue = floatValue;
        this.dimensionUnitText = "pt";
        this.asInteger = (double)Math.abs(this.realvalue - (float)Math.floor(this.realvalue)) < 0.01;
    }

    public void setIntegerValue(int intValue) {
        this.realvalue = intValue;
        this.setCSSUnitType((short)1);
        this.asInteger = true;
    }

    @Override
    boolean isNegativeNumber() {
        return this.realvalue < 0.0f;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (unitType == this.getPrimitiveType()) {
            return this.realvalue;
        }
        if (unitType == 1 && this.getPrimitiveType() != 2) {
            return this.realvalue;
        }
        return CSSNumberValue.floatValueConversion(this.realvalue, this.getPrimitiveType(), unitType);
    }

    public static float floatValueConversion(float fvalue, short declType, short unitType) throws DOMException {
        if (fvalue == 0.0f) {
            return 0.0f;
        }
        if (declType == unitType) {
            return fvalue;
        }
        switch (declType) {
            case 9: {
                if (unitType == 5) {
                    return fvalue / 0.75f;
                }
                if (unitType == 8) {
                    return fvalue / 72.0f;
                }
                if (unitType == 10) {
                    return fvalue / 12.0f;
                }
                if (unitType == 6) {
                    return fvalue / 28.34646f;
                }
                if (unitType == 7) {
                    return fvalue / 2.834646f;
                }
                if (unitType != 30) break;
                return fvalue * 1.411111f;
            }
            case 5: {
                if (unitType == 9) {
                    return fvalue * 0.75f;
                }
                if (unitType == 8) {
                    return fvalue / 96.0f;
                }
                if (unitType == 10) {
                    return fvalue / 16.0f;
                }
                if (unitType == 6) {
                    return fvalue / 37.795f;
                }
                if (unitType == 7) {
                    return fvalue / 3.7795f;
                }
                if (unitType != 30) break;
                return fvalue * 1.05834f;
            }
            case 10: {
                if (unitType == 9) {
                    return fvalue * 12.0f;
                }
                if (unitType == 8) {
                    return fvalue / 6.0f;
                }
                if (unitType == 5) {
                    return fvalue * 16.0f;
                }
                if (unitType == 6) {
                    return fvalue / 2.3622f;
                }
                if (unitType == 7) {
                    return fvalue * 4.2333f;
                }
                if (unitType != 30) break;
                return fvalue * 16.9333f;
            }
            case 8: {
                if (unitType == 5) {
                    return fvalue * 96.0f;
                }
                if (unitType == 9) {
                    return fvalue * 72.0f;
                }
                if (unitType == 10) {
                    return fvalue * 6.0f;
                }
                if (unitType == 6) {
                    return fvalue * 2.54f;
                }
                if (unitType == 7) {
                    return fvalue * 25.4f;
                }
                if (unitType != 30) break;
                return fvalue * 101.6f;
            }
            case 6: {
                if (unitType == 9) {
                    return fvalue * 28.34646f;
                }
                if (unitType == 8) {
                    return fvalue / 2.54f;
                }
                if (unitType == 5) {
                    return fvalue * 37.795f;
                }
                if (unitType == 10) {
                    return fvalue * 2.3622f;
                }
                if (unitType == 7) {
                    return fvalue * 10.0f;
                }
                if (unitType != 30) break;
                return fvalue * 40.0f;
            }
            case 7: {
                if (unitType == 9) {
                    return fvalue * 2.834646f;
                }
                if (unitType == 8) {
                    return fvalue * 3.937f;
                }
                if (unitType == 5) {
                    return fvalue * 3.7795f;
                }
                if (unitType == 10) {
                    return fvalue * 0.23622f;
                }
                if (unitType == 6) {
                    return fvalue * 0.1f;
                }
                if (unitType != 30) break;
                return fvalue * 4.0f;
            }
            case 14: {
                if (unitType != 15) break;
                return fvalue * 1000.0f;
            }
            case 15: {
                if (unitType != 14) break;
                return fvalue * 0.001f;
            }
            case 33: {
                if (unitType == 12) {
                    return fvalue * 2.0f * (float)Math.PI;
                }
                if (unitType == 13) {
                    return fvalue * 400.0f;
                }
                if (unitType != 11) break;
                return fvalue * 360.0f;
            }
            case 12: {
                if (unitType == 11) {
                    return (float)Math.toDegrees(fvalue);
                }
                if (unitType == 13) {
                    return fvalue * 63.661976f;
                }
                if (unitType != 33) break;
                return fvalue * 0.15915494f;
            }
            case 11: {
                if (unitType == 12) {
                    return (float)Math.toRadians(fvalue);
                }
                if (unitType == 13) {
                    return fvalue * 1.1111112f;
                }
                if (unitType != 33) break;
                return fvalue / 360.0f;
            }
            case 13: {
                if (unitType == 11) {
                    return fvalue * 0.9f;
                }
                if (unitType == 12) {
                    return fvalue * 0.015707964f;
                }
                if (unitType != 33) break;
                return fvalue * 0.0025f;
            }
            case 30: {
                if (unitType == 9) {
                    return fvalue * 11.338584f;
                }
                if (unitType == 8) {
                    return fvalue * 15.748f;
                }
                if (unitType == 5) {
                    return fvalue * 15.118f;
                }
                if (unitType == 10) {
                    return fvalue * 0.94488f;
                }
                if (unitType == 7) {
                    return fvalue * 0.25f;
                }
                if (unitType != 6) break;
                return fvalue * 0.025f;
            }
            case 1: {
                if (unitType == 11) {
                    return fvalue;
                }
            }
            default: {
                if (18 != unitType) break;
                return fvalue;
            }
        }
        throw new DOMException(15, "Cannot transform unit " + CSSNumberValue.dimensionUnitString(declType) + " to " + CSSNumberValue.dimensionUnitString(unitType));
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        super.setLexicalUnit(lunit, subp, factory);
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        switch (lunit.getLexicalUnitType()) {
            case 13: {
                this.realvalue = lunit.getIntegerValue();
                this.asInteger = true;
                break;
            }
            default: {
                this.realvalue = lunit.getFloatValue();
                this.asInteger = false;
                this.dimensionUnitText = lunit.getDimensionUnitText();
            }
        }
        this.setSubproperty(subp);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.realvalue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CSSNumberValue)) {
            return false;
        }
        CSSNumberValue other = (CSSNumberValue)obj;
        return Float.floatToIntBits(this.realvalue) == Float.floatToIntBits(other.realvalue);
    }

    @Override
    public CSSNumberValue clone() {
        return new CSSNumberValue(this);
    }

    CSSNumberValue immutable() {
        return new ImmutableCSSNumberValue(this);
    }

    static String dimensionUnitString(short unitType) {
        switch (unitType) {
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 5: {
                return "px";
            }
            case 8: {
                return "in";
            }
            case 6: {
                return "cm";
            }
            case 7: {
                return "mm";
            }
            case 9: {
                return "pt";
            }
            case 10: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 11: {
                return "deg";
            }
            case 13: {
                return "grad";
            }
            case 12: {
                return "rad";
            }
            case 14: {
                return "ms";
            }
            case 15: {
                return "s";
            }
            case 16: {
                return "Hz";
            }
            case 17: {
                return "kHz";
            }
        }
        return "";
    }

    private static class ImmutableCSSNumberValue
    extends CSSNumberValue {
        ImmutableCSSNumberValue(CSSNumberValue value) {
            super(value);
        }

        @Override
        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setFloatValuePt(float floatValue) {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setIntegerValue(int intValue) {
            throw new DOMException(7, "This value is immutable");
        }
    }
}

