/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag.maven;

import io.smallrye.beanbag.BeanBag;
import io.smallrye.beanbag.BeanInstantiationException;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.beanbag.Scope;
import io.smallrye.beanbag.maven.PlexusContainerImpl;
import io.smallrye.beanbag.sisu.Sisu;
import io.smallrye.common.constraint.Assert;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public final class MavenFactory {
    private static final String MAVEN_CENTRAL = "https://repo1.maven.org/maven2";
    private static final String NL = System.lineSeparator();
    private final BeanBag container;
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    private MavenFactory(List<ClassLoader> classLoaders, Consumer<BeanBag.Builder> configurator, DependencyFilter dependencyFilter) {
        BeanBag.Builder builder = BeanBag.builder();
        configurator.accept(builder);
        Sisu sisu = Sisu.createFor((BeanBag.Builder)builder);
        builder.addBean(BeanBag.class).setSupplier(Scope::getContainer).build();
        builder.addBean(PlexusContainerImpl.class).setPriority(-100).setSingleton(true).setSupplier(scope -> new PlexusContainerImpl(scope.getContainer())).build();
        for (ClassLoader classLoader : classLoaders) {
            sisu.addClassLoader(classLoader, dependencyFilter);
        }
        builder.addBean(SecDispatcher.class).setName("maven").setPriority(-100).setSingleton(true).setSupplier(scope -> (SecDispatcher)scope.getBean(SecDispatcher.class, "", false, (type, name, priority) -> name.isEmpty())).build();
        this.container = builder.build();
    }

    public static MavenFactory create(List<ClassLoader> classLoaders, Consumer<BeanBag.Builder> configurator, DependencyFilter dependencyFilter) {
        return new MavenFactory((List)Assert.checkNotNullParam((String)"classLoaders", classLoaders), configurator, dependencyFilter);
    }

    public static MavenFactory create(ClassLoader classLoader, Consumer<BeanBag.Builder> configurator, DependencyFilter dependencyFilter) {
        return MavenFactory.create(List.of((ClassLoader)Assert.checkNotNullParam((String)"classLoader", (Object)classLoader)), configurator, dependencyFilter);
    }

    public static MavenFactory create(ClassLoader classLoader, Consumer<BeanBag.Builder> configurator) {
        return MavenFactory.create(classLoader, configurator, DependencyFilter.ACCEPT);
    }

    public static MavenFactory create(ClassLoader classLoader) {
        return MavenFactory.create(classLoader, ignored -> {});
    }

    public static MavenFactory create() {
        return MavenFactory.create(WALKER.getCallerClass().getClassLoader());
    }

    public BeanBag getContainer() {
        return this.container;
    }

    public RepositorySystem getRepositorySystem() throws BeanInstantiationException {
        return (RepositorySystem)this.getContainer().requireBean(RepositorySystem.class);
    }

    public SettingsBuilder getSettingsBuilder() throws BeanInstantiationException {
        return (SettingsBuilder)this.getContainer().requireBean(SettingsBuilder.class);
    }

    public Settings createSettingsFromContainer(File globalSettings, File userSettings, Consumer<SettingsProblem> problemHandler) throws SettingsBuildingException {
        return MavenFactory.getSettings(globalSettings, userSettings, problemHandler, this.getSettingsBuilder());
    }

    public static Settings createSettings(File globalSettings, File userSettings, Consumer<SettingsProblem> problemHandler) throws SettingsBuildingException {
        return MavenFactory.getSettings(globalSettings, userSettings, problemHandler, (SettingsBuilder)new DefaultSettingsBuilderFactory().newInstance());
    }

    private static Settings getSettings(File globalSettings, File userSettings, Consumer<SettingsProblem> problemHandler, SettingsBuilder builder) throws SettingsBuildingException {
        Settings settings;
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        if (globalSettings != null) {
            request.setGlobalSettingsFile(globalSettings);
        }
        if (userSettings != null) {
            request.setUserSettingsFile(userSettings);
        }
        request.setSystemProperties(System.getProperties());
        SettingsBuildingResult result = builder.build((SettingsBuildingRequest)request);
        if (problemHandler != null) {
            result.getProblems().forEach(problemHandler);
        }
        if ((settings = result.getEffectiveSettings()).getLocalRepository() == null) {
            settings.setLocalRepository(System.getProperty("user.home", "") + File.separator + ".m2" + File.separator + "repository");
        }
        return settings;
    }

    public RepositorySystemSession createSession(Settings settings) throws BeanInstantiationException {
        Assert.checkNotNullParam((String)"settings", (Object)settings);
        RepositorySystem system = this.getRepositorySystem();
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        String repositoryType = "default";
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(new File(settings.getLocalRepository()), repositoryType)));
        session.setOffline(settings.isOffline());
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : settings.getProxies()) {
            proxySelector.add(MavenFactory.convertProxy(proxy), proxy.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        session.setSystemProperties((Map)System.getProperties());
        session.setConfigProperties((Map)System.getProperties());
        return session;
    }

    public static List<RemoteRepository> createRemoteRepositoryList(Settings settings) {
        Assert.checkNotNullParam((String)"settings", (Object)settings);
        if (settings.isOffline()) {
            return List.of();
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder("central", "default", MAVEN_CENTRAL);
        builder.setSnapshotPolicy(new RepositoryPolicy(false, null, null));
        RemoteRepository remoteRepository = builder.build();
        List<RemoteRepository> basicList = List.of(remoteRepository);
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Object mirror : settings.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LinkedHashSet<RemoteRepository> mirroredRepos = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository repository : basicList) {
            RemoteRepository mirror = mirrorSelector.getMirror(repository);
            mirroredRepos.add(mirror != null ? mirror : repository);
        }
        LinkedHashSet<RemoteRepository> authorizedRepos = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository remoteRepository2 : mirroredRepos) {
            RemoteRepository.Builder builder2 = new RemoteRepository.Builder(remoteRepository2);
            Server server = settings.getServer(remoteRepository2.getId());
            if (server != null) {
                AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase());
                builder2.setAuthentication(authenticationBuilder.build());
            }
            authorizedRepos.add(builder2.build());
        }
        return List.copyOf(authorizedRepos);
    }

    public static File getGlobalSettingsLocation() {
        String mavenHome = System.getProperty("maven.home");
        return mavenHome == null ? null : new File(mavenHome + File.separator + "conf" + File.separator + "settings.xml");
    }

    public static File getUserSettingsLocation() {
        String userHome = System.getProperty("user.home");
        return userHome == null ? null : new File(userHome + File.separator + ".m2" + File.separator + "settings.xml");
    }

    public static String dumpSettings(Settings settings) {
        return MavenFactory.dumpSettings(new StringBuilder(), settings, 0).toString();
    }

    public static StringBuilder dumpSettings(StringBuilder sb, Settings settings, int indent) {
        MavenFactory.indent(sb, indent).append("settings={").append(NL);
        MavenFactory.joinStrings(MavenFactory.indent(sb, indent + 1).append("activeProfiles=["), settings.getActiveProfiles()).append(']').append(NL);
        MavenFactory.indent(sb, indent + 1).append("localRepository=").append(settings.getLocalRepository()).append(NL);
        MavenFactory.dumpMirrors(sb, settings.getMirrors(), indent + 1).append(NL);
        MavenFactory.indent(sb, indent + 1).append("modelEncoding=").append(settings.getModelEncoding()).append(NL);
        MavenFactory.joinStrings(MavenFactory.indent(sb, indent + 1).append("pluginGroups=["), settings.getPluginGroups()).append(']').append(NL);
        MavenFactory.dumpProfiles(sb, settings.getProfiles(), indent + 1).append(NL);
        MavenFactory.dumpProxies(sb, settings.getProxies(), indent + 1).append(NL);
        MavenFactory.dumpServers(sb, settings.getServers(), indent + 1).append(NL);
        MavenFactory.indent(sb, indent + 1).append("interactiveMode=").append(settings.isInteractiveMode()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("offline=").append(settings.isOffline()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("usePluginRegistry=").append(settings.isUsePluginRegistry()).append(NL);
        return MavenFactory.indent(sb, indent).append("}");
    }

    private static StringBuilder dumpServers(StringBuilder sb, List<Server> servers, int indent) {
        MavenFactory.indent(sb, indent).append("servers=[");
        Iterator<Server> iterator = servers.iterator();
        if (iterator.hasNext()) {
            sb.append(NL);
            MavenFactory.dumpServer(sb, iterator.next(), indent + 1);
            while (iterator.hasNext()) {
                sb.append(',').append(NL);
                MavenFactory.dumpServer(sb, iterator.next(), indent + 1);
            }
            sb.append(NL);
            MavenFactory.indent(sb, indent);
        }
        return sb.append(']');
    }

    private static StringBuilder dumpServer(StringBuilder sb, Server server, int indent) {
        MavenFactory.indent(sb, indent).append("server={").append(NL);
        MavenFactory.indent(sb, indent + 1).append("username=").append(server.getUsername()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("password=").append(server.getPassword() == null ? "<NOT SET>" : "<SET>").append(NL);
        MavenFactory.indent(sb, indent + 1).append("privateKey=").append(server.getPrivateKey() == null ? "<NOT SET>" : "<SET>").append(NL);
        MavenFactory.indent(sb, indent + 1).append("passphrase=").append(server.getPassphrase() == null ? "<NOT SET>" : "<SET>").append(NL);
        MavenFactory.indent(sb, indent + 1).append("filePermissions=").append(server.getFilePermissions()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("directoryPermissions=").append(server.getDirectoryPermissions()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("configuration=").append(server.getConfiguration()).append(NL);
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder dumpProxies(StringBuilder sb, List<org.apache.maven.settings.Proxy> proxies, int indent) {
        MavenFactory.indent(sb, indent).append("proxies=[");
        Iterator<org.apache.maven.settings.Proxy> iterator = proxies.iterator();
        if (iterator.hasNext()) {
            sb.append(NL);
            MavenFactory.dumpProxy(sb, iterator.next(), indent + 1);
            while (iterator.hasNext()) {
                sb.append(',').append(NL);
                MavenFactory.dumpProxy(sb, iterator.next(), indent + 1);
            }
            sb.append(NL);
            MavenFactory.indent(sb, indent);
        }
        return sb.append(']');
    }

    private static StringBuilder dumpProxy(StringBuilder sb, org.apache.maven.settings.Proxy proxy, int indent) {
        MavenFactory.indent(sb, indent).append("proxy={").append(NL);
        MavenFactory.indent(sb, indent + 1).append("active=").append(proxy.isActive()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("protocol=").append(proxy.getProtocol()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("username=").append(proxy.getUsername()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("password=").append(proxy.getPassword() == null ? "<NOT SET>" : "<SET>").append(NL);
        MavenFactory.indent(sb, indent + 1).append("port=").append(proxy.getPort()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("host=").append(proxy.getHost()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("nonProxyHosts=").append(proxy.getNonProxyHosts()).append(NL);
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder dumpProfiles(StringBuilder sb, List<Profile> profiles, int indent) {
        MavenFactory.indent(sb, indent).append("profiles=[");
        Iterator<Profile> iterator = profiles.iterator();
        if (iterator.hasNext()) {
            sb.append(NL);
            MavenFactory.dumpProfile(sb, iterator.next(), indent + 1);
            while (iterator.hasNext()) {
                sb.append(',').append(NL);
                MavenFactory.dumpProfile(sb, iterator.next(), indent + 1);
            }
            sb.append(NL);
            MavenFactory.indent(sb, indent);
        }
        return sb.append(']');
    }

    private static StringBuilder dumpProfile(StringBuilder sb, Profile profile, int indent) {
        MavenFactory.indent(sb, indent).append("profile={").append(NL);
        if (profile.getActivation() != null) {
            MavenFactory.dumpActivation(sb, profile.getActivation(), indent + 1).append(NL);
        }
        MavenFactory.dumpRepositories(sb, "repositories", profile.getRepositories(), indent + 1).append(NL);
        MavenFactory.dumpRepositories(sb, "pluginRepositories", profile.getPluginRepositories(), indent + 1).append(NL);
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder dumpRepositories(StringBuilder sb, String label, List<Repository> repositories, int indent) {
        MavenFactory.indent(sb, indent).append(label).append("=[");
        Iterator<Repository> iterator = repositories.iterator();
        if (iterator.hasNext()) {
            sb.append(NL);
            MavenFactory.dumpRepository(sb, iterator.next(), indent + 1);
            while (iterator.hasNext()) {
                sb.append(',').append(NL);
                MavenFactory.dumpRepository(sb, iterator.next(), indent + 1);
            }
            sb.append(NL);
            MavenFactory.indent(sb, indent);
        }
        return sb.append(']');
    }

    private static StringBuilder dumpRepository(StringBuilder sb, Repository repository, int indent) {
        MavenFactory.indent(sb, indent).append("repository={").append(NL);
        MavenFactory.indent(sb, indent + 1).append("id=").append(repository.getId()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("name=").append(repository.getName()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("url=").append(repository.getUrl()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("layout=").append(repository.getLayout()).append(NL);
        if (repository.getReleases() != null) {
            MavenFactory.dumpRepositoryPolicy(sb, "releasesPolicy", repository.getReleases(), indent + 1).append(NL);
        }
        if (repository.getSnapshots() != null) {
            MavenFactory.dumpRepositoryPolicy(sb, "snapshotsPolicy", repository.getSnapshots(), indent + 1).append(NL);
        }
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder dumpRepositoryPolicy(StringBuilder sb, String label, org.apache.maven.settings.RepositoryPolicy repositoryPolicy, int indent) {
        MavenFactory.indent(sb, indent).append(label).append("={").append(NL);
        MavenFactory.indent(sb, indent + 1).append("enabled=").append(repositoryPolicy.isEnabled()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("updatePolicy=").append(repositoryPolicy.getUpdatePolicy()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("checksumPolicy=").append(repositoryPolicy.getChecksumPolicy()).append(NL);
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder dumpActivation(StringBuilder sb, Activation activation, int indent) {
        ActivationProperty property;
        String name;
        ActivationOS os;
        String jdk;
        MavenFactory.indent(sb, indent).append("activation={").append(NL);
        MavenFactory.indent(sb, indent + 1).append("activeByDefault=").append(activation.isActiveByDefault()).append(NL);
        ActivationFile file = activation.getFile();
        if (file != null) {
            String exists = file.getExists();
            String missing = file.getMissing();
            if (exists != null || missing != null) {
                MavenFactory.indent(sb, indent + 1);
                if (exists != null) {
                    sb.append("file=").append(exists);
                    if (missing != null) {
                        sb.append(',');
                    }
                }
                if (missing != null) {
                    sb.append("!file=").append(missing);
                }
                sb.append(NL);
            }
        }
        if ((jdk = activation.getJdk()) != null) {
            MavenFactory.indent(sb, indent + 1).append("jdk=").append(jdk).append(NL);
        }
        if ((os = activation.getOs()) != null) {
            String arch = os.getArch();
            name = os.getName();
            String family = os.getFamily();
            String version = os.getVersion();
            if (arch != null || name != null || family != null || version != null) {
                MavenFactory.indent(sb, indent + 1);
                if (arch != null) {
                    sb.append("osArch=").append(arch);
                    if (name != null || family != null || version != null) {
                        sb.append(',');
                    }
                }
                if (name != null) {
                    sb.append("osName=").append(name);
                    if (family != null || version != null) {
                        sb.append(',');
                    }
                }
                if (family != null) {
                    sb.append("osFamily=").append(family);
                    if (version != null) {
                        sb.append(',');
                    }
                }
                if (version != null) {
                    sb.append("osVersion=").append(version);
                }
                sb.append(NL);
            }
        }
        if ((property = activation.getProperty()) != null) {
            name = property.getName();
            String value = property.getValue();
            if (name != null) {
                MavenFactory.indent(sb, indent + 1).append("property=").append(name);
                if (value != null) {
                    sb.append("=").append(value);
                }
                sb.append(NL);
            }
        }
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder dumpMirrors(StringBuilder sb, List<Mirror> mirrors, int indent) {
        MavenFactory.indent(sb, indent).append("mirrors=[");
        Iterator<Mirror> iterator = mirrors.iterator();
        if (iterator.hasNext()) {
            sb.append(NL);
            MavenFactory.dumpMirror(sb, iterator.next(), indent + 1);
            while (iterator.hasNext()) {
                sb.append(',').append(NL);
                MavenFactory.dumpMirror(sb, iterator.next(), indent + 1);
            }
            sb.append(NL);
            MavenFactory.indent(sb, indent);
        }
        return sb.append(']');
    }

    private static StringBuilder dumpMirror(StringBuilder sb, Mirror mirror, int indent) {
        MavenFactory.indent(sb, indent).append("mirror={").append(NL);
        MavenFactory.indent(sb, indent + 1).append("name=").append(mirror.getName()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("url=").append(mirror.getUrl()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("layout=").append(mirror.getLayout()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("mirrorOf=").append(mirror.getMirrorOf()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("mirrorOfLayouts=").append(mirror.getMirrorOfLayouts()).append(NL);
        MavenFactory.indent(sb, indent + 1).append("blocked=").append(mirror.isBlocked()).append(NL);
        return MavenFactory.indent(sb, indent).append('}');
    }

    private static StringBuilder joinStrings(StringBuilder sb, List<String> strings) {
        Iterator<String> iterator = strings.iterator();
        if (iterator.hasNext()) {
            sb.append(iterator.next());
            while (iterator.hasNext()) {
                sb.append(',').append(iterator.next());
            }
        }
        return sb;
    }

    private static StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append("    ");
        }
        return sb;
    }

    private static Proxy convertProxy(org.apache.maven.settings.Proxy proxy) {
        Authentication authentication = proxy.getUsername() != null || proxy.getPassword() != null ? new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build() : null;
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authentication);
    }
}

