/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingNames;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public final class ConfigMappings {
    public static void registerConfigMappings(SmallRyeConfig config, Set<ConfigClass> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, new SmallRyeConfigBuilder(), configClasses);
        }
    }

    public static void registerConfigProperties(SmallRyeConfig config, Set<ConfigClass> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, new SmallRyeConfigBuilder().withValidateUnknown(false), configClasses);
        }
    }

    public static Map<String, ConfigMappingInterface.Property> getProperties(ConfigClass configClass) {
        HashMap<String, ConfigMappingInterface.Property> properties = new HashMap<String, ConfigMappingInterface.Property>();
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : ConfigMappingInterface.getProperties(ConfigMappingLoader.getConfigMapping(configClass.getKlass())).get(configClass.getKlass()).get("").entrySet()) {
            properties.put(ConfigMappings.prefix(configClass.getPrefix(), entry.getKey()), entry.getValue());
        }
        return properties;
    }

    @Deprecated
    public static Set<String> mappedProperties(ConfigClass configClass, Set<String> properties) {
        ConfigMappingNames names = new ConfigMappingNames(ConfigMappingLoader.getConfigMapping(configClass.getKlass()).getNames());
        HashSet<String> mappedNames = new HashSet<String>();
        for (String property : properties) {
            if (!names.hasAnyName(configClass.getKlass().getName(), configClass.getPrefix(), configClass.getPrefix(), Set.of(property))) continue;
            mappedNames.add(property);
        }
        return mappedNames;
    }

    private static void mapConfiguration(SmallRyeConfig config, SmallRyeConfigBuilder configBuilder, Set<ConfigClass> configClasses) throws ConfigValidationException {
        for (ConfigClass configClass : configClasses) {
            configBuilder.withMapping(configClass);
        }
        config.getDefaultValues().addDefaults(configBuilder.getDefaultValues());
        config.getMappings().putAll(config.buildMappings(configBuilder));
    }

    static String prefix(String prefix, String path) {
        if (prefix.isEmpty()) {
            return path;
        }
        if (path.isEmpty()) {
            return prefix;
        }
        if (path.charAt(0) == '[') {
            return prefix + path;
        }
        return prefix + "." + path;
    }

    public static final class ConfigClass {
        private final Class<?> klass;
        private final String prefix;

        public ConfigClass(Class<?> klass, String prefix) {
            this.klass = klass;
            this.prefix = prefix;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigClass that = (ConfigClass)o;
            return this.klass.equals(that.klass) && this.prefix.equals(that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.klass, this.prefix);
        }

        public static ConfigClass configClass(Class<?> klass, String prefix) {
            return new ConfigClass(klass, prefix);
        }

        public static ConfigClass configClass(Class<?> klass) {
            String prefix;
            if (klass.isInterface()) {
                ConfigMapping configMapping = klass.getAnnotation(ConfigMapping.class);
                String prefix2 = configMapping != null ? configMapping.prefix() : "";
                return ConfigClass.configClass(klass, prefix2);
            }
            ConfigProperties configProperties = klass.getAnnotation(ConfigProperties.class);
            String string = prefix = configProperties != null ? configProperties.prefix() : "";
            if (prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
                prefix = "";
            }
            return ConfigClass.configClass(klass, prefix);
        }
    }
}

