/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.function.Functions;
import io.smallrye.config.NameIterator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class KeyMap<V>
extends HashMap<String, KeyMap<V>> {
    private static final Object NO_VALUE = new Serializable(){
        private static final long serialVersionUID = -6072559389176920349L;
    };
    private static final long serialVersionUID = 3584966224369608557L;
    private KeyMap<V> any;
    private V rootValue = NO_VALUE;

    public KeyMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public KeyMap(int initialCapacity) {
        super(initialCapacity);
    }

    public KeyMap() {
    }

    public KeyMap<V> get(String key, int offs, int len) {
        return (KeyMap)this.get(key.substring(offs, offs + len));
    }

    public KeyMap<V> getAny() {
        return this.any;
    }

    public KeyMap<V> getOrCreateAny() {
        KeyMap<V> any = this.any;
        if (any == null) {
            any = this.any = new KeyMap<V>();
        }
        return any;
    }

    public KeyMap<V> putAny(KeyMap<V> any) {
        KeyMap<V> oldAny = this.any;
        this.any = any;
        return oldAny;
    }

    public KeyMap<V> putAnyIfAbsent(KeyMap<V> any) {
        KeyMap<V> oldAny = this.any;
        if (oldAny == null) {
            this.any = any;
            return null;
        }
        return oldAny;
    }

    public boolean hasRootValue() {
        return this.rootValue != NO_VALUE;
    }

    public V getRootValue() {
        return this.getRootValueOrDefault(null);
    }

    public V getRootValueOrDefault(V defaultVal) {
        V rootValue = this.rootValue;
        return rootValue == NO_VALUE ? defaultVal : rootValue;
    }

    public V getOrComputeRootValue(Supplier<V> supplier) {
        V rootValue = this.rootValue;
        if (rootValue == NO_VALUE) {
            this.rootValue = rootValue = supplier.get();
        }
        return rootValue;
    }

    public V removeRootValue() {
        V rootValue = this.rootValue;
        if (rootValue != NO_VALUE) {
            this.rootValue = NO_VALUE;
        }
        return rootValue;
    }

    public V putRootValue(V rootValue) {
        V old = this.rootValue;
        this.rootValue = rootValue;
        return old == NO_VALUE ? null : (V)old;
    }

    public KeyMap<V> find(String path) {
        return this.find(new NameIterator(path));
    }

    public KeyMap<V> find(NameIterator ni) {
        if (!ni.hasNext()) {
            return this;
        }
        String seg = ni.getNextSegment();
        ni.next();
        KeyMap<V> next = this.findOrDefault(seg);
        return next == null ? null : next.find(ni);
    }

    public KeyMap<V> find(Iterator<String> iter) {
        if (!iter.hasNext()) {
            return this;
        }
        String seg = iter.next();
        KeyMap<V> next = seg.equals("*") ? this.any : this.getOrDefault(seg, this.any);
        return next == null ? null : next.find(iter);
    }

    public KeyMap<V> find(Iterable<String> i) {
        return this.find(i.iterator());
    }

    private KeyMap<V> findOrDefault(String seg) {
        int begin;
        KeyMap<KeyMap<V>> next = this.getOrDefault(seg, this.any);
        if (seg.endsWith("]") && (begin = seg.lastIndexOf(91)) != -1 && this.isValidIndex(seg, begin) && (next = this.getOrDefault(seg.substring(0, begin), this.any)) != null && (next = next.find("[")) != null && (next = next.getOrDefault(seg.substring(begin + 1, seg.length() - 1), next.any)) != null) {
            next = next.find("]");
        }
        return next;
    }

    private boolean isValidIndex(String seg, int begin) {
        try {
            String index = seg.substring(begin + 1, seg.length() - 1);
            if (index.equals("*")) {
                return true;
            }
            Integer.parseInt(index);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public KeyMap<V> findOrAdd(String path) {
        return this.findOrAdd(new NameIterator(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyMap<V> findOrAdd(NameIterator ni) {
        if (!ni.hasNext()) {
            return this;
        }
        String seg = ni.getNextSegment();
        ni.next();
        try {
            KeyMap<V> next = this.getNext(seg);
            KeyMap<V> keyMap = next.findOrAdd(ni);
            return keyMap;
        }
        finally {
            ni.previous();
        }
    }

    public KeyMap<V> findOrAdd(Iterator<String> iter) {
        if (!iter.hasNext()) {
            return this;
        }
        String seg = iter.next();
        KeyMap<V> next = this.getNext(seg);
        return next.findOrAdd(iter);
    }

    public KeyMap<V> findOrAdd(Iterable<String> i) {
        return this.findOrAdd(i.iterator());
    }

    public KeyMap<V> findOrAdd(String ... keys) {
        return this.findOrAdd(keys, 0, keys.length);
    }

    public KeyMap<V> findOrAdd(String[] keys, int off, int len) {
        String seg = keys[off];
        KeyMap<V> next = this.getNext(seg);
        return off + 1 > len - 1 ? next : next.findOrAdd(keys, off + 1, len);
    }

    private KeyMap<V> getNext(String seg) {
        if (seg.equals("*")) {
            return this.getOrCreateAny();
        }
        if (seg.endsWith("]")) {
            int begin = seg.lastIndexOf(91);
            if (begin != -1 && this.isValidIndex(seg, begin)) {
                String index = seg.substring(begin + 1, seg.length() - 1);
                String name = seg.substring(0, begin);
                KeyMap next = name.equals("*") ? this.getOrCreateAny() : this.computeIfAbsent(name, k -> new KeyMap());
                next = next.computeIfAbsent("[", k -> new KeyMap());
                next = index.equals("*") ? next.getOrCreateAny() : next.computeIfAbsent(index, k -> new KeyMap());
                next = next.computeIfAbsent("]", k -> new KeyMap());
                return next;
            }
            return this.computeIfAbsent(seg, k -> new KeyMap());
        }
        return this.computeIfAbsent(seg, k -> new KeyMap());
    }

    public V findRootValue(String path) {
        return this.findRootValue(new NameIterator(path));
    }

    public V findRootValue(NameIterator ni) {
        KeyMap<V> result = this.find(ni);
        return result == null ? null : (V)result.getRootValue();
    }

    public boolean hasRootValue(String path) {
        return this.hasRootValue(new NameIterator(path));
    }

    public boolean hasRootValue(NameIterator ni) {
        KeyMap<V> result = this.find(ni);
        return result != null && result.hasRootValue();
    }

    public boolean hasRootValue(Iterable<String> i) {
        KeyMap<V> result = this.find(i.iterator());
        return result != null && result.hasRootValue();
    }

    public <P, V2> KeyMap<V2> map(P param, BiFunction<P, V, V2> conversion) {
        return this.map(param, conversion, new IdentityHashMap<KeyMap<V>, KeyMap<V2>>());
    }

    public <V2> KeyMap<V2> map(Function<V, V2> conversion) {
        return this.map(conversion, Functions.functionBiFunction());
    }

    <P, V2> KeyMap<V2> map(P param, BiFunction<P, V, V2> conversion, IdentityHashMap<KeyMap<V>, KeyMap<V2>> cached) {
        if (cached.containsKey(this)) {
            return cached.get(this);
        }
        KeyMap<KeyMap<V2>> newMap = new KeyMap<KeyMap<V2>>(this.size());
        cached.put(this, newMap);
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            newMap.put((String)entry.getKey(), ((KeyMap)entry.getValue()).map(param, conversion, cached));
        }
        KeyMap<KeyMap<V>> any = this.getAny();
        if (any != null) {
            newMap.putAny(any.map(param, conversion, cached));
        }
        if (this.hasRootValue()) {
            newMap.putRootValue((KeyMap<V2>)conversion.apply(param, this.getRootValue()));
        }
        return newMap;
    }

    public void putAll(KeyMap<V> m) {
        for (Map.Entry entry : m.entrySet()) {
            KeyMap value;
            String key = (String)entry.getKey();
            KeyMap all = this.putIfAbsent(key, value = (KeyMap)entry.getValue());
            if (all == null) continue;
            all.putAll(value);
        }
        if (m.any != null) {
            if (this.any == null) {
                this.getOrCreateAny().putRootValue(m.any.rootValue);
            }
            this.getAny().putAll(m.any);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends KeyMap<V>> m) {
        if (m instanceof KeyMap) {
            this.putAll((KeyMap)m);
        } else {
            super.putAll(m);
        }
    }

    @Override
    public Set<String> keySet() {
        Set keys = super.keySet();
        HashSet<String> allKeys = new HashSet<String>();
        for (String key : keys) {
            Set<String> childKeys = this.find(key).keySet();
            for (String childKey : childKeys) {
                allKeys.add(key + "." + childKey);
            }
            if (!this.hasRootValue(key)) continue;
            allKeys.add(key);
        }
        return allKeys;
    }

    public StringBuilder toString(StringBuilder b) {
        b.append("KeyMap(");
        V rootValue = this.rootValue;
        if (rootValue == NO_VALUE) {
            b.append("no value");
        } else {
            b.append("value=").append(rootValue);
        }
        b.append(") {");
        Iterator iterator = this.entrySet().iterator();
        KeyMap<V> any = this.any;
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            b.append((String)entry.getKey()).append("=>");
            ((KeyMap)entry.getValue()).toString(b);
            while (iterator.hasNext()) {
                entry = iterator.next();
                b.append(',').append((String)entry.getKey()).append("=>");
                ((KeyMap)entry.getValue()).toString(b);
            }
            if (any != null) {
                b.append(',').append("(any)=>");
                any.toString(b);
            }
        } else if (any != null) {
            b.append("(any)=>");
            any.toString(b);
        }
        b.append('}');
        return b;
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

