/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingNames;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import io.smallrye.config.PropertyName;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config._private.ConfigMessages;
import io.smallrye.config.common.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigMappingContext {
    private final SmallRyeConfig config;
    private final Map<Class<?>, Map<String, ConfigMappingObject>> roots = new IdentityHashMap();
    private final Map<Class<?>, Converter<?>> converterInstances = new IdentityHashMap();
    private ConfigMapping.NamingStrategy namingStrategy;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final Set<String> usedProperties = new HashSet<String>();
    private final List<ConfigValidationException.Problem> problems = new ArrayList<ConfigValidationException.Problem>();
    private final ConfigMappingNames names;

    public ConfigMappingContext(SmallRyeConfig config, Map<String, List<Class<?>>> roots, Map<String, Map<String, Set<String>>> names) {
        this.config = config;
        this.names = new ConfigMappingNames(names);
        for (Map.Entry<String, List<Class<?>>> entry : roots.entrySet()) {
            String path = entry.getKey();
            for (Class<?> root : entry.getValue()) {
                this.registerRoot(root, path);
            }
        }
    }

    private void registerRoot(final Class<?> rootType, final String rootPath) {
        this.roots.computeIfAbsent(rootType, new Function<Class<?>, Map<String, ConfigMappingObject>>(){

            @Override
            public Map<String, ConfigMappingObject> apply(Class<?> mapping) {
                return new HashMap<String, ConfigMappingObject>();
            }
        }).computeIfAbsent(rootPath, new Function<String, ConfigMappingObject>(){

            @Override
            public ConfigMappingObject apply(String path) {
                ConfigMappingContext.this.namingStrategy = null;
                ConfigMappingContext.this.stringBuilder.replace(0, ConfigMappingContext.this.stringBuilder.length(), rootPath);
                return (ConfigMappingObject)ConfigMappingContext.this.constructRoot(rootType);
            }
        });
    }

    public <T> T constructRoot(Class<T> interfaceType) {
        return this.constructGroup(interfaceType);
    }

    public <T> T constructGroup(Class<T> interfaceType) {
        ConfigMapping.NamingStrategy namingStrategy = this.namingStrategy;
        T mappingObject = ConfigMappingLoader.configMappingObject(interfaceType, this);
        this.namingStrategy = this.applyNamingStrategy(namingStrategy);
        return mappingObject;
    }

    public <T> ObjectCreator<T> constructObject(String path) {
        return new ObjectCreator(path);
    }

    public <T> Converter<T> getConverterInstance(Class<? extends Converter<? extends T>> converterType) {
        return this.converterInstances.computeIfAbsent(converterType, t -> {
            try {
                return (Converter)t.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable t2) {
                    throw new UndeclaredThrowableException(t2);
                }
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        });
    }

    public ConfigMapping.NamingStrategy applyNamingStrategy(ConfigMapping.NamingStrategy namingStrategy) {
        if (namingStrategy != null) {
            this.namingStrategy = namingStrategy;
        } else if (this.namingStrategy == null) {
            this.namingStrategy = ConfigMapping.NamingStrategy.KEBAB_CASE;
        }
        return this.namingStrategy;
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public void reportProblem(RuntimeException problem) {
        this.problems.add(new ConfigValidationException.Problem(problem.toString()));
    }

    List<ConfigValidationException.Problem> getProblems() {
        return this.problems;
    }

    Map<Class<?>, Map<String, ConfigMappingObject>> getRootsMap() {
        return this.roots;
    }

    void reportUnknown(List<String[]> ignoredPaths) {
        KeyMap ignoredProperties = new KeyMap();
        for (String[] ignoredPath : ignoredPaths) {
            KeyMap<Boolean> found;
            int len;
            if (ignoredPath[(len = ignoredPath.length) - 1].equals("**")) {
                found = ignoredProperties.findOrAdd(ignoredPath, 0, len - 1);
                found.putRootValue(Boolean.TRUE);
                ConfigMappingContext.ignoreRecursively(found);
                continue;
            }
            found = ignoredProperties.findOrAdd(ignoredPath);
            found.putRootValue(Boolean.TRUE);
        }
        HashSet<String> roots = new HashSet<String>();
        for (Map<String, ConfigMappingObject> value : this.roots.values()) {
            roots.addAll(value.keySet());
        }
        for (String name : ConfigMappingContext.filterPropertiesInRoots(this.config.getPropertyNames(), roots)) {
            if (this.usedProperties.contains(name) || ignoredProperties.hasRootValue(name)) continue;
            ConfigValue configValue = this.config.getConfigValue(name);
            this.problems.add(new ConfigValidationException.Problem(ConfigMessages.msg.propertyDoesNotMapToAnyRoot(name, configValue.getLocation())));
        }
    }

    private static void ignoreRecursively(KeyMap<Boolean> root) {
        if (root.getRootValue() == null) {
            root.putRootValue(Boolean.TRUE);
        }
        if (root.getAny() == null) {
            root.putAny(root);
        } else {
            KeyMap<Boolean> any = root.getAny();
            if (root != any) {
                ConfigMappingContext.ignoreRecursively(any);
            }
        }
        for (KeyMap value : root.values()) {
            ConfigMappingContext.ignoreRecursively(value);
        }
    }

    private static Iterable<String> filterPropertiesInRoots(Iterable<String> properties, Set<String> roots) {
        if (roots.isEmpty()) {
            return properties;
        }
        if (roots.contains("")) {
            return properties;
        }
        ArrayList<String> matchedProperties = new ArrayList<String>();
        block0: for (String property : properties) {
            for (String root : roots) {
                if (!ConfigMappingContext.isPropertyInRoot(property, root)) continue;
                matchedProperties.add(property);
                continue block0;
            }
        }
        return matchedProperties;
    }

    private static boolean isPropertyInRoot(String property, String root) {
        if (property.equals(root)) {
            return true;
        }
        if (property.length() <= root.length()) {
            return false;
        }
        char c = property.charAt(root.length());
        if (c == '.' || c == '[') {
            return property.startsWith(root);
        }
        return false;
    }

    static class MapWithDefault<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1390928078837140814L;
        private final V defaultValue;

        MapWithDefault(V defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object key) {
            return this.getOrDefault(key, this.defaultValue);
        }
    }

    public class ObjectCreator<T> {
        private T root;
        private List<Consumer<Function<String, Object>>> creators;

        public ObjectCreator(final String path) {
            this.creators = List.of(new Consumer<Function<String, Object>>(){

                @Override
                public void accept(Function<String, Object> get) {
                    ObjectCreator.this.root = get.apply(path);
                }
            });
        }

        public <K> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith) {
            return this.map(keyRawType, keyConvertWith, null);
        }

        public <K> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, String unnamedKey) {
            return this.map(keyRawType, keyConvertWith, unnamedKey, (Class)null);
        }

        public <K, V> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, String unnamedKey, final Class<V> defaultClass) {
            Supplier supplier = null;
            if (defaultClass != null) {
                supplier = new Supplier<V>(){

                    @Override
                    public V get() {
                        int length = ConfigMappingContext.this.stringBuilder.length();
                        ConfigMappingContext.this.stringBuilder.append(".*");
                        Object defaultValue = ConfigMappingContext.this.constructGroup(defaultClass);
                        ConfigMappingContext.this.stringBuilder.setLength(length);
                        return defaultValue;
                    }
                };
            }
            return this.map(keyRawType, keyConvertWith, unnamedKey, supplier);
        }

        public <K, V> ObjectCreator<T> map(Class<K> keyRawType, Class<? extends Converter<K>> keyConvertWith, final String unnamedKey, final Supplier<V> defaultValue) {
            final Object keyConverter = keyConvertWith == null ? ConfigMappingContext.this.config.requireConverter(keyRawType) : ConfigMappingContext.this.getConverterInstance(keyConvertWith);
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        Map<String, String> mapKeys = ObjectCreator.this.getMapKeys(path.length() > 0 && path.charAt(path.length() - 1) == '.' ? path.substring(0, path.length() - 1) : path);
                        final HashMap map = defaultValue != null ? new MapWithDefault(defaultValue.get()) : new HashMap(mapKeys.size());
                        for (final Map.Entry<String, String> entry : mapKeys.entrySet()) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    Object value = get.apply((String)entry.getValue());
                                    if (value != null) {
                                        map.putIfAbsent(keyConverter.convert((String)entry.getKey()), value);
                                    }
                                }
                            });
                        }
                        if (unnamedKey != null) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    Object value = get.apply(path);
                                    if (value != null) {
                                        map.putIfAbsent(unnamedKey.equals("") ? null : keyConverter.convert(unnamedKey), value);
                                    }
                                }
                            });
                        }
                        return map;
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> collection(Class<C> collectionRawType) {
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            IntFunction<Collection<C>> collectionFactory = this.createCollectionFactory(collectionRawType);
            for (Consumer<Function<String, Object>> creator : this.creators) {
                final Collection<C> collection = collectionFactory.apply(0);
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        for (final Integer index : ConfigMappingContext.this.config.getIndexedPropertiesIndexes(path)) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    collection.add(get.apply(path + "[" + index + "]"));
                                }
                            });
                        }
                        return collection;
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> optionalCollection(Class<C> collectionRawType) {
            final ArrayList<Consumer<Function<String, Object>>> nestedCreators = new ArrayList<Consumer<Function<String, Object>>>();
            IntFunction<Collection<C>> collectionFactory = this.createCollectionFactory(collectionRawType);
            for (Consumer<Function<String, Object>> creator : this.creators) {
                final Collection<C> collection = collectionFactory.apply(0);
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Object apply(final String path) {
                        List<Integer> indexes = ConfigMappingContext.this.config.getIndexedPropertiesIndexes(path);
                        for (final Integer index : indexes) {
                            nestedCreators.add(new Consumer<Function<String, Object>>(){

                                @Override
                                public void accept(Function<String, Object> get) {
                                    collection.add(get.apply(path + "[" + index + "]"));
                                }
                            });
                        }
                        return indexes.isEmpty() ? Optional.empty() : Optional.of(collection);
                    }
                });
            }
            this.creators = nestedCreators;
            return this;
        }

        public <G> ObjectCreator<T> group(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public G apply(String path) {
                        StringBuilder sb = ConfigMappingContext.this.getStringBuilder();
                        int length = sb.length();
                        sb.append(path, length, path.length());
                        Object group = ConfigMappingContext.this.constructGroup(groupType);
                        sb.setLength(length);
                        return group;
                    }
                });
            }
            return this;
        }

        public <G> ObjectCreator<T> lazyGroup(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public G apply(String path) {
                        if (ObjectCreator.this.createRequired(groupType, path)) {
                            StringBuilder sb = ConfigMappingContext.this.getStringBuilder();
                            int length = sb.length();
                            sb.append(path, length, path.length());
                            Object group = ConfigMappingContext.this.constructGroup(groupType);
                            sb.setLength(length);
                            return group;
                        }
                        return null;
                    }
                });
            }
            return this;
        }

        public <G> ObjectCreator<T> optionalGroup(final Class<G> groupType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Optional<G> apply(String path) {
                        if (ObjectCreator.this.createRequired(groupType, path)) {
                            StringBuilder sb = ConfigMappingContext.this.getStringBuilder();
                            int length = sb.length();
                            sb.append(path, length, path.length());
                            Object group = ConfigMappingContext.this.constructGroup(groupType);
                            sb.setLength(length);
                            return Optional.of(group);
                        }
                        return Optional.empty();
                    }
                });
            }
            return this;
        }

        public ObjectCreator<T> value(final Class<T> valueRawType, final Class<? extends Converter<T>> valueConvertWith) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public T apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        return ConfigMappingContext.this.config.getValue(propertyName, valueConverter);
                    }
                });
            }
            return this;
        }

        public <V> ObjectCreator<T> optionalValue(final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public Optional<V> apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        return ConfigMappingContext.this.config.getOptionalValue(propertyName, valueConverter);
                    }
                });
            }
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> values(final Class<V> itemRawType, final Class<? extends Converter<V>> itemConvertWith, final Class<C> collectionRawType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public T apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getIndexedProperties(propertyName));
                        Converter itemConverter = itemConvertWith == null ? ConfigMappingContext.this.config.requireConverter(itemRawType) : ConfigMappingContext.this.getConverterInstance(itemConvertWith);
                        IntFunction<Collection<?>> collectionFactory = ObjectCreator.this.createCollectionFactory(collectionRawType);
                        return ConfigMappingContext.this.config.getValues(propertyName, itemConverter, collectionFactory);
                    }
                });
            }
            return this;
        }

        public <V, C extends Collection<V>> ObjectCreator<T> optionalValues(final Class<V> itemRawType, final Class<? extends Converter<V>> itemConvertWith, final Class<C> collectionRawType) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                creator.accept(new Function<String, Object>(){

                    @Override
                    public T apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getIndexedProperties(propertyName));
                        Converter itemConverter = ObjectCreator.this.getConverter(itemRawType, itemConvertWith);
                        IntFunction<Collection<?>> collectionFactory = ObjectCreator.this.createCollectionFactory(collectionRawType);
                        return ConfigMappingContext.this.config.getOptionalValues(propertyName, itemConverter, collectionFactory);
                    }
                });
            }
            return this;
        }

        public <K, V> ObjectCreator<T> values(final Class<K> keyRawType, final Class<? extends Converter<K>> keyConvertWith, final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith, final String defaultValue) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                Function<String, Object> values = new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getMapKeys(propertyName).values());
                        Converter keyConverter = ObjectCreator.this.getConverter(keyRawType, keyConvertWith);
                        final Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        if (defaultValue == null) {
                            return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, HashMap::new).orElse(new HashMap());
                        }
                        IntFunction mapFactory = new IntFunction<Map<K, V>>(){

                            @Override
                            public Map<K, V> apply(int value) {
                                return new MapWithDefault(valueConverter.convert(defaultValue));
                            }
                        };
                        return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, mapFactory).orElse((Map)mapFactory.apply(0));
                    }
                };
                creator.accept(values);
            }
            return this;
        }

        public <K, V, C extends Collection<V>> ObjectCreator<T> values(final Class<K> keyRawType, final Class<? extends Converter<K>> keyConvertWith, final Class<V> valueRawType, final Class<? extends Converter<V>> valueConvertWith, final Class<C> collectionRawType, final String defaultValue) {
            for (Consumer<Function<String, Object>> creator : this.creators) {
                Function<String, Object> values = new Function<String, Object>(){

                    @Override
                    public Object apply(String propertyName) {
                        ConfigMappingContext.this.usedProperties.add(propertyName);
                        for (String mapKey : ConfigMappingContext.this.config.getMapKeys(propertyName).values()) {
                            ConfigMappingContext.this.usedProperties.add(mapKey);
                            ConfigMappingContext.this.usedProperties.addAll(ConfigMappingContext.this.config.getIndexedProperties(mapKey));
                        }
                        Converter keyConverter = ObjectCreator.this.getConverter(keyRawType, keyConvertWith);
                        final Converter valueConverter = ObjectCreator.this.getConverter(valueRawType, valueConvertWith);
                        final IntFunction<Collection<?>> collectionFactory = ObjectCreator.this.createCollectionFactory(collectionRawType);
                        if (defaultValue == null) {
                            return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, HashMap::new, collectionFactory).orElse(new HashMap());
                        }
                        IntFunction mapFactory = new IntFunction<Map<K, C>>(){

                            @Override
                            public Map<K, C> apply(int value) {
                                return new MapWithDefault((Collection)Converters.newCollectionConverter(valueConverter, collectionFactory).convert(defaultValue));
                            }
                        };
                        return ConfigMappingContext.this.config.getOptionalValues(propertyName, keyConverter, valueConverter, mapFactory, collectionFactory).orElse((Map)mapFactory.apply(0));
                    }
                };
                creator.accept(values);
            }
            return this;
        }

        public T get() {
            return this.root;
        }

        private <V> Converter<V> getConverter(Class<V> rawType, Class<? extends Converter<V>> convertWith) {
            return convertWith == null ? ConfigMappingContext.this.config.requireConverter(rawType) : ConfigMappingContext.this.getConverterInstance(convertWith);
        }

        private Map<String, String> getMapKeys(String name) {
            HashMap<String, String> mapKeys = new HashMap<String, String>();
            for (String propertyName : ConfigMappingContext.this.config.getPropertyNames()) {
                if (propertyName.length() <= name.length() + 1 || name.length() != 0 && propertyName.charAt(name.length()) != '.' || !propertyName.startsWith(name)) continue;
                NameIterator key = name.length() > 0 ? new NameIterator(StringUtil.unindexed((String)propertyName), name.length()) : new NameIterator(StringUtil.unindexed((String)propertyName));
                key.next();
                mapKeys.put(StringUtil.unindexed((String)key.getPreviousSegment()), StringUtil.unindexed((String)propertyName.substring(0, key.getPosition())));
            }
            return mapKeys;
        }

        private <G> boolean createRequired(Class<G> groupType, String path) {
            Set<PropertyName> names = ConfigMappingContext.this.names.get(groupType.getName(), path);
            if (names == null) {
                return false;
            }
            for (String propertyName : ConfigMappingContext.this.config.getPropertyNames()) {
                if (!propertyName.startsWith(path) || !names.contains(new PropertyName(propertyName))) continue;
                return true;
            }
            return false;
        }

        private IntFunction<Collection<?>> createCollectionFactory(Class<?> type) {
            if (type == List.class) {
                return ArrayList::new;
            }
            if (type == Set.class) {
                return HashSet::new;
            }
            throw new IllegalArgumentException();
        }
    }
}

