/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class UniRunSubscribeOn<I>
extends UniOperator<I, I> {
    private final Executor executor;

    public UniRunSubscribeOn(Uni<? extends I> upstream, Executor executor) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    protected void subscribing(UniSubscriber<? super I> subscriber) {
        SubscribeOnUniSubscriber downstream = new SubscribeOnUniSubscriber(subscriber);
        try {
            this.executor.execute(downstream);
        }
        catch (Throwable e) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(e);
        }
    }

    class SubscribeOnUniSubscriber
    extends UniDelegatingSubscriber<I, I>
    implements Runnable,
    UniSubscriber<I>,
    UniSubscription {
        final AtomicReference<UniSubscription> subscription;

        SubscribeOnUniSubscriber(UniSubscriber<? super I> actual) {
            super(actual);
            this.subscription = new AtomicReference();
        }

        @Override
        public void run() {
            try {
                AbstractUni.subscribe(UniRunSubscribeOn.this.upstream(), this);
            }
            catch (Exception e) {
                super.onSubscribe(EmptyUniSubscription.CANCELLED);
                super.onFailure(e);
            }
        }

        @Override
        public void onSubscribe(UniSubscription s) {
            if (this.subscription.compareAndSet(null, s)) {
                super.onSubscribe(this);
            }
        }

        @Override
        public void cancel() {
            UniSubscription upstream = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (upstream != null && upstream != EmptyUniSubscription.CANCELLED) {
                upstream.cancel();
            }
        }
    }
}

