/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;

public class UniMemoizeOp<I>
extends UniOperator<I, I>
implements UniSubscriber<I>,
ContextSupport {
    private UniSubscription currentUpstreamSubscription;
    private Context currentContext = Context.empty();
    private final BooleanSupplier invalidationRequested;
    private State state = State.INIT;
    private final ReentrantLock internalLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<UniSubscriber<? super I>> awaiters = new ConcurrentLinkedQueue();
    private Object cachedResult = null;

    public UniMemoizeOp(Uni<? extends I> upstream) {
        this(upstream, () -> false);
    }

    public UniMemoizeOp(Uni<? extends I> upstream, BooleanSupplier invalidationRequested) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.invalidationRequested = invalidationRequested;
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        ParameterValidation.nonNull(subscriber, "subscriber");
        try {
            this.internalLock.lock();
            this.checkForInvalidation();
            switch (this.state) {
                case INIT: {
                    this.state = State.WAITING_FOR_UPSTREAM;
                    this.awaiters.add(subscriber);
                    this.currentContext = subscriber.context();
                    this.upstream().subscribe().withSubscriber(this);
                    break;
                }
                case WAITING_FOR_UPSTREAM: {
                    this.awaiters.add(subscriber);
                    break;
                }
                case CACHING: {
                    this.forwardTo(subscriber);
                }
            }
            subscriber.onSubscribe(new MemoizedSubscription(subscriber));
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private void checkForInvalidation() {
        if (this.invalidationRequested.getAsBoolean()) {
            this.state = State.INIT;
            if (this.currentUpstreamSubscription != null) {
                this.currentUpstreamSubscription.cancel();
                this.currentUpstreamSubscription = null;
            }
        }
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        this.currentUpstreamSubscription = subscription;
    }

    @Override
    public void onItem(I item) {
        try {
            this.internalLock.lock();
            if (this.state == State.WAITING_FOR_UPSTREAM) {
                this.state = State.CACHING;
                this.cachedResult = item;
                this.notifyAwaiters();
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        try {
            this.internalLock.lock();
            if (this.state == State.WAITING_FOR_UPSTREAM) {
                this.state = State.CACHING;
                this.cachedResult = failure;
                this.notifyAwaiters();
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private void forwardTo(UniSubscriber<? super I> subscriber) {
        if (this.cachedResult instanceof Throwable) {
            subscriber.onFailure((Throwable)this.cachedResult);
        } else {
            subscriber.onItem(this.cachedResult);
        }
    }

    @Override
    public Context context() {
        return this.currentContext;
    }

    private void notifyAwaiters() {
        UniSubscriber<? super I> awaiter;
        while ((awaiter = this.awaiters.poll()) != null) {
            this.forwardTo(awaiter);
        }
    }

    private class MemoizedSubscription
    implements UniSubscription {
        private final UniSubscriber<? super I> subscriber;

        MemoizedSubscription(UniSubscriber<? super I> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void cancel() {
            UniMemoizeOp.this.awaiters.remove(this.subscriber);
        }
    }

    private static enum State {
        INIT,
        WAITING_FOR_UPSTREAM,
        CACHING;

    }
}

