/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.builders.BaseMultiEmitter;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.nio.BufferOverflowException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferItemMultiEmitter<T>
extends BaseMultiEmitter<T> {
    private final Queue<T> queue;
    private Throwable failure;
    private volatile boolean done;
    private final AtomicInteger wip = new AtomicInteger();

    BufferItemMultiEmitter(MultiSubscriber<? super T> actual, Queue<T> queue) {
        super(actual);
        this.queue = queue;
    }

    @Override
    public MultiEmitter<T> emit(T t) {
        if (this.done || this.isCancelled()) {
            return this;
        }
        if (t == null) {
            this.fail(new NullPointerException("`emit` called with `null`."));
            return this;
        }
        if (this.queue.offer(t)) {
            this.drain();
        } else {
            this.fail(new EmitterBufferOverflowException());
        }
        return this;
    }

    @Override
    protected void cleanup() {
        this.queue.clear();
        super.cleanup();
    }

    @Override
    public void failed(Throwable failure) {
        if (this.done || this.isCancelled()) {
            return;
        }
        if (failure == null) {
            failure = new NullPointerException("onError called with null.");
        }
        this.failure = failure;
        this.done = true;
        this.drain();
    }

    @Override
    public void completion() {
        this.done = true;
        this.drain();
    }

    @Override
    void onRequested() {
        this.drain();
    }

    @Override
    void onUnsubscribed() {
        if (this.wip.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            boolean d;
            long e;
            long r = this.requested.get();
            for (e = 0L; e != r; ++e) {
                boolean empty;
                if (this.isCancelled()) {
                    q.clear();
                    return;
                }
                d = this.done;
                T o = q.poll();
                boolean bl = empty = o == null;
                if (d && empty) {
                    if (this.failure != null) {
                        super.failed(this.failure);
                    } else {
                        super.completion();
                    }
                    return;
                }
                if (empty) break;
                try {
                    this.downstream.onItem(o);
                    continue;
                }
                catch (Throwable x) {
                    this.cancel();
                }
            }
            if (e == r) {
                if (this.isCancelled()) {
                    q.clear();
                    return;
                }
                d = this.done;
                boolean empty = q.isEmpty();
                if (d && empty) {
                    if (this.failure != null) {
                        super.failed(this.failure);
                    } else {
                        super.completion();
                    }
                    return;
                }
            }
            if (e == 0L) continue;
            Subscriptions.produced(this.requested, e);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    public static class EmitterBufferOverflowException
    extends BufferOverflowException {
        @Override
        public String getMessage() {
            return "The buffer used by the emitter is full, because the downstream consumer did not request enough items.";
        }
    }
}

