/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.dns;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;

/**
 * Represent a Mail-Exchange-Record (MX) which was resolved for a domain.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.MxRecord original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.dns.MxRecord.class)
public class MxRecord {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MxRecord that = (MxRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<MxRecord> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new MxRecord((io.vertx.core.dns.MxRecord) obj),
    MxRecord::getDelegate
  );

  private final io.vertx.core.dns.MxRecord delegate;
  
  public MxRecord(io.vertx.core.dns.MxRecord delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MxRecord() {    this.delegate = null;
  }

  public io.vertx.core.dns.MxRecord getDelegate() {
    return delegate;
  }

  /**
   * The priority of the MX record.
   * @return 
   */
  public int priority() { 
    int ret = delegate.priority();
    return ret;
  }

  /**
   * The name of the MX record
   * @return 
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }


  public static  MxRecord newInstance(io.vertx.core.dns.MxRecord arg) {
    return arg != null ? new MxRecord(arg) : null;
  }
}
