/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.http;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.http.StreamPriority;
import javax.net.ssl.SSLSession;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a server-side HTTP request.
 * <p>
 * Instances are created for each request and passed to the user via a handler.
 * <p>
 * Each instance of this class is associated with a corresponding {@link io.vertx.axle.core.http.HttpServerResponse} instance via
 * {@link io.vertx.axle.core.http.HttpServerRequest#response}.<p>
 * It implements {@link io.vertx.axle.core.streams.ReadStream} so it can be used with
 * {@link io.vertx.axle.core.streams.Pump} to pump data with flow control.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerRequest original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.http.HttpServerRequest.class)
public class HttpServerRequest implements io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerRequest that = (HttpServerRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<HttpServerRequest> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new HttpServerRequest((io.vertx.core.http.HttpServerRequest) obj),
    HttpServerRequest::getDelegate
  );

  private final io.vertx.core.http.HttpServerRequest delegate;
  
  public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpServerRequest() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpServerRequest getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.buffer.Buffer> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  private io.vertx.axle.core.http.HttpServerRequest __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.http.HttpServerRequest exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.http.HttpServerRequest __handler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.http.HttpServerRequest handler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.core.http.HttpServerRequest pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.http.HttpServerRequest resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.http.HttpServerRequest fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.axle.core.http.HttpServerRequest __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.http.HttpServerRequest endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * @return the HTTP version of the request
   */
  public HttpVersion version() { 
    HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the HTTP method for the request.
   */
  public HttpMethod method() { 
    HttpMethod ret = delegate.method();
    return ret;
  }

  /**
   * @return the HTTP method as sent by the client
   */
  public String rawMethod() { 
    String ret = delegate.rawMethod();
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.axle.core.net.NetSocket} is encrypted via SSL/TLS
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * @return the scheme of the request
   */
  public String scheme() { 
    String ret = delegate.scheme();
    return ret;
  }

  /**
   * @return the URI of the request. This is usually a relative URI
   */
  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return The path part of the uri. For example /somepath/somemorepath/someresource.foo
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }

  /**
   * @return the query part of the uri. For example someparam=32&amp;someotherparam=x
   */
  public String query() { 
    String ret = delegate.query();
    return ret;
  }

  /**
   * @return the request host. For HTTP2 it returns the  pseudo header otherwise it returns the  header
   */
  public String host() { 
    String ret = delegate.host();
    return ret;
  }

  /**
   * @return the total number of bytes read for the body of the request.
   */
  public long bytesRead() { 
    long ret = delegate.bytesRead();
    return ret;
  }

  /**
   * @return the response. Each instance of this class has an {@link io.vertx.axle.core.http.HttpServerResponse} instance attached to it. This is used to send the response back to the client.
   */
  public io.vertx.axle.core.http.HttpServerResponse response() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.http.HttpServerResponse ret = io.vertx.axle.core.http.HttpServerResponse.newInstance(delegate.response());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the headers in the request.
   */
  public io.vertx.axle.core.MultiMap headers() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.MultiMap ret = io.vertx.axle.core.MultiMap.newInstance(delegate.headers());
    cached_1 = ret;
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return the query parameters in the request
   */
  public io.vertx.axle.core.MultiMap params() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.axle.core.MultiMap ret = io.vertx.axle.core.MultiMap.newInstance(delegate.params());
    cached_2 = ret;
    return ret;
  }

  /**
   * Return the first param value with the specified name
   * @param paramName the param name
   * @return the param value
   */
  public String getParam(String paramName) { 
    String ret = delegate.getParam(paramName);
    return ret;
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress remoteAddress() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress localAddress() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the absolute URI corresponding to the the HTTP request
   */
  public String absoluteURI() { 
    String ret = delegate.absoluteURI();
    return ret;
  }

  /**
   * Convenience method for receiving the entire request body in one piece.
   * <p>
   * This saves the user having to manually setting a data and end handler and append the chunks of the body until
   * the whole body received. Don't use this if your request body is large - you could potentially run out of RAM.
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  private io.vertx.axle.core.http.HttpServerRequest __bodyHandler(Handler<io.vertx.axle.core.buffer.Buffer> bodyHandler) { 
    delegate.bodyHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        bodyHandler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Convenience method for receiving the entire request body in one piece.
   * <p>
   * This saves the user having to manually setting a data and end handler and append the chunks of the body until
   * the whole body received. Don't use this if your request body is large - you could potentially run out of RAM.
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  public io.vertx.axle.core.http.HttpServerRequest bodyHandler(Consumer<io.vertx.axle.core.buffer.Buffer> bodyHandler) {
    return __bodyHandler(bodyHandler != null ? bodyHandler::accept : null);
  }

  /**
   * Get a net socket for the underlying connection of this request.
   * <p/>
   * This method must be called before the server response is ended.
   * <p/>
   * With <code>CONNECT</code> requests, a <code>200</code> response is sent with no <code>content-length</code> header set
   * before returning the socket.
   * <p/>
   * <pre>
   * server.requestHandler(req -> {
   *   if (req.method() == HttpMethod.CONNECT) {
   *     // Send a 200 response to accept the connect
   *     NetSocket socket = req.netSocket();
   *     socket.handler(buff -> {
   *       socket.write(buff);
   *     });
   *   }
   *   ...
   * });
   * </pre>
   * <p/>
   * For other HTTP/1 requests once you have called this method, you must handle writing to the connection yourself using
   * the net socket, the server request instance will no longer be usable as normal. USE THIS WITH CAUTION! Writing to the socket directly if you don't know what you're
   * doing can easily break the HTTP protocol.
   * <p/>
   * With HTTP/2, a <code>200</code> response is always sent with no <code>content-length</code> header set before returning the socket
   * like in the <code>CONNECT</code> case above.
   * <p/>
   * @return the net socket
   */
  public io.vertx.axle.core.net.NetSocket netSocket() { 
    if (cached_5 != null) {
      return cached_5;
    }
    io.vertx.axle.core.net.NetSocket ret = io.vertx.axle.core.net.NetSocket.newInstance(delegate.netSocket());
    cached_5 = ret;
    return ret;
  }

  /**
   * Call this with true if you are expecting a multi-part body to be submitted in the request.
   * This must be called before the body of the request has been received
   * @param expect true - if you are expecting a multi-part body
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpServerRequest setExpectMultipart(boolean expect) { 
    delegate.setExpectMultipart(expect);
    return this;
  }

  /**
   * @return true if we are expecting a multi-part body for this request. See {@link io.vertx.axle.core.http.HttpServerRequest#setExpectMultipart}.
   */
  public boolean isExpectMultipart() { 
    boolean ret = delegate.isExpectMultipart();
    return ret;
  }

  /**
   * Set an upload handler. The handler will get notified once a new file upload was received to allow you to deal
   * with the file upload.
   * @param uploadHandler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpServerRequest __uploadHandler(Handler<io.vertx.axle.core.http.HttpServerFileUpload> uploadHandler) { 
    delegate.uploadHandler(new Handler<io.vertx.core.http.HttpServerFileUpload>() {
      public void handle(io.vertx.core.http.HttpServerFileUpload event) {
        uploadHandler.handle(io.vertx.axle.core.http.HttpServerFileUpload.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set an upload handler. The handler will get notified once a new file upload was received to allow you to deal
   * with the file upload.
   * @param uploadHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpServerRequest uploadHandler(Consumer<io.vertx.axle.core.http.HttpServerFileUpload> uploadHandler) {
    return __uploadHandler(uploadHandler != null ? uploadHandler::accept : null);
  }

  /**
   * Returns a map of all form attributes in the request.
   * <p>
   * Be aware that the attributes will only be available after the whole body has been received, i.e. after
   * the request end handler has been called.
   * <p>
   * {@link io.vertx.axle.core.http.HttpServerRequest#setExpectMultipart} must be called first before trying to get the form attributes.
   * @return the form attributes
   */
  public io.vertx.axle.core.MultiMap formAttributes() { 
    if (cached_6 != null) {
      return cached_6;
    }
    io.vertx.axle.core.MultiMap ret = io.vertx.axle.core.MultiMap.newInstance(delegate.formAttributes());
    cached_6 = ret;
    return ret;
  }

  /**
   * Return the first form attribute value with the specified name
   * @param attributeName the attribute name
   * @return the attribute value
   */
  public String getFormAttribute(String attributeName) { 
    String ret = delegate.getFormAttribute(attributeName);
    return ret;
  }

  /**
   * Upgrade the connection to a WebSocket connection.
   * <p>
   * This is an alternative way of handling WebSockets and can only be used if no WebSocket handler is set on the
   * <code>HttpServer</code>, and can only be used during the upgrade request during the WebSocket handshake.
   * @return the WebSocket
   */
  public io.vertx.axle.core.http.ServerWebSocket upgrade() { 
    io.vertx.axle.core.http.ServerWebSocket ret = io.vertx.axle.core.http.ServerWebSocket.newInstance(delegate.upgrade());
    return ret;
  }

  /**
   * Has the request ended? I.e. has the entire request, including the body been read?
   * @return true if ended
   */
  public boolean isEnded() { 
    boolean ret = delegate.isEnded();
    return ret;
  }

  /**
   * Set a custom frame handler. The handler will get notified when the http stream receives an custom HTTP/2
   * frame. HTTP/2 permits extension of the protocol.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpServerRequest __customFrameHandler(Handler<io.vertx.axle.core.http.HttpFrame> handler) { 
    delegate.customFrameHandler(new Handler<io.vertx.core.http.HttpFrame>() {
      public void handle(io.vertx.core.http.HttpFrame event) {
        handler.handle(io.vertx.axle.core.http.HttpFrame.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a custom frame handler. The handler will get notified when the http stream receives an custom HTTP/2
   * frame. HTTP/2 permits extension of the protocol.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpServerRequest customFrameHandler(Consumer<io.vertx.axle.core.http.HttpFrame> handler) {
    return __customFrameHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the {@link io.vertx.axle.core.http.HttpConnection} associated with this request
   */
  public io.vertx.axle.core.http.HttpConnection connection() { 
    if (cached_7 != null) {
      return cached_7;
    }
    io.vertx.axle.core.http.HttpConnection ret = io.vertx.axle.core.http.HttpConnection.newInstance(delegate.connection());
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the priority of the associated HTTP/2 stream for HTTP/2 otherwise <code>null</code>
   */
  public StreamPriority streamPriority() { 
    StreamPriority ret = delegate.streamPriority();
    return ret;
  }

  /**
   * Set an handler for stream priority changes
   * <p>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when stream priority changes
   * @return 
   */
  private io.vertx.axle.core.http.HttpServerRequest __streamPriorityHandler(Handler<StreamPriority> handler) { 
    delegate.streamPriorityHandler(handler);
    return this;
  }

  /**
   * Set an handler for stream priority changes
   * <p>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when stream priority changes
   * @return 
   */
  public io.vertx.axle.core.http.HttpServerRequest streamPriorityHandler(Consumer<StreamPriority> handler) {
    return __streamPriorityHandler(handler != null ? handler::accept : null);
  }

  /**
   * Get the cookie with the specified name.
   * @param name the cookie name
   * @return the cookie
   */
  public io.vertx.axle.core.http.Cookie getCookie(String name) { 
    io.vertx.axle.core.http.Cookie ret = io.vertx.axle.core.http.Cookie.newInstance(delegate.getCookie(name));
    return ret;
  }

  /**
   * @return the number of cookieMap.
   */
  public int cookieCount() { 
    int ret = delegate.cookieCount();
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(CharSequence headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer>(o1 -> io.vertx.axle.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private io.vertx.axle.core.http.HttpServerResponse cached_0;
  private io.vertx.axle.core.MultiMap cached_1;
  private io.vertx.axle.core.MultiMap cached_2;
  private io.vertx.axle.core.net.SocketAddress cached_3;
  private io.vertx.axle.core.net.SocketAddress cached_4;
  private io.vertx.axle.core.net.NetSocket cached_5;
  private io.vertx.axle.core.MultiMap cached_6;
  private io.vertx.axle.core.http.HttpConnection cached_7;

  public static  HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
    return arg != null ? new HttpServerRequest(arg) : null;
  }
}
