/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.shareddata;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous map.
 * <p>
 * {@link io.vertx.axle.core.shareddata.AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<AsyncMap> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap<K,V> delegate;
  public final io.vertx.lang.axle.TypeArg<K> __typeArg_0;
  public final io.vertx.lang.axle.TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();    this.__typeArg_1 = io.vertx.lang.axle.TypeArg.unknown();  }

  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate, io.vertx.lang.axle.TypeArg<K> typeArg_0, io.vertx.lang.axle.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  AsyncMap() {    this.delegate = null;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();    this.__typeArg_1 = io.vertx.lang.axle.TypeArg.unknown();  }

  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later with the async result.
   */
  private void __get(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.get(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public CompletionStage<V> get(K k) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __get(k, handler);
    });
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @param completionHandler - this will be called some time later to signify the value has been put
   */
  private void __put(K k, V v, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), completionHandler);
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   */
  public CompletionStage<Void> put(K k, V v) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __put(k, v, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  private void __put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public CompletionStage<Void> put(K k, V v, long ttl) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __put(k, v, ttl, handler);
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @param completionHandler the handler
   */
  private void __putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   */
  public CompletionStage<V> putIfAbsent(K k, V v) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __putIfAbsent(k, v, handler);
    });
  }

  /**
   * Link {@link io.vertx.axle.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  private void __putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Link {@link io.vertx.axle.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public CompletionStage<V> putIfAbsent(K k, V v, long ttl) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __putIfAbsent(k, v, ttl, handler);
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  private void __remove(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.remove(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public CompletionStage<V> remove(K k) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __remove(k, handler);
    });
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  private void __removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.removeIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), resultHandler);
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   */
  public CompletionStage<Boolean> removeIfPresent(K k, V v) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __removeIfPresent(k, v, handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param resultHandler the result handler will be passed the previous value
   */
  private void __replace(K k, V v, Handler<AsyncResult<V>> resultHandler) { 
    delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   */
  public CompletionStage<V> replace(K k, V v) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __replace(k, v, handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param resultHandler the result handler
   */
  private void __replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), resultHandler);
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   */
  public CompletionStage<Boolean> replaceIfPresent(K k, V oldValue, V newValue) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __replaceIfPresent(k, oldValue, newValue, handler);
    });
  }

  /**
   * Clear all entries in the map
   * @param resultHandler called on completion
   */
  private void __clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

  /**
   * Clear all entries in the map
   * @return 
   */
  public CompletionStage<Void> clear() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __clear(handler);
    });
  }

  /**
   * Provide the number of entries in the map
   * @param resultHandler handler which will receive the number of entries
   */
  private void __size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

  /**
   * Provide the number of entries in the map
   * @return 
   */
  public CompletionStage<Integer> size() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __size(handler);
    });
  }


  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }

  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, io.vertx.lang.axle.TypeArg<K> __typeArg_K, io.vertx.lang.axle.TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }
}
