/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.shareddata;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.shareddata.Counter.class)
public class Counter {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Counter that = (Counter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<Counter> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Counter() {    this.delegate = null;
  }

  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }

  /**
   * Get the current value of the counter
   * @param resultHandler handler which will be passed the value
   */
  private void __get(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.get(resultHandler);
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public CompletionStage<Long> get() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __get(handler);
    });
  }

  /**
   * Increment the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  private void __incrementAndGet(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.incrementAndGet(resultHandler);
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public CompletionStage<Long> incrementAndGet() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __incrementAndGet(handler);
    });
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @param resultHandler handler which will be passed the value
   */
  private void __getAndIncrement(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.getAndIncrement(resultHandler);
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public CompletionStage<Long> getAndIncrement() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __getAndIncrement(handler);
    });
  }

  /**
   * Decrement the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  private void __decrementAndGet(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.decrementAndGet(resultHandler);
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public CompletionStage<Long> decrementAndGet() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __decrementAndGet(handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  private void __addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.addAndGet(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public CompletionStage<Long> addAndGet(long value) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __addAndGet(value, handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  private void __getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.getAndAdd(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public CompletionStage<Long> getAndAdd(long value) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __getAndAdd(value, handler);
    });
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @param resultHandler the handler will be passed true on success
   */
  private void __compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.compareAndSet(expected, value, resultHandler);
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public CompletionStage<Boolean> compareAndSet(long expected, long value) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __compareAndSet(expected, value, handler);
    });
  }


  public static  Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }
}
