package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An asynchronous WebSocket client.
 * <p>
 * It allows you to open WebSockets to servers.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebSocketClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient) obj),
    WebSocketClient::getDelegate
  );

  private final io.vertx.core.http.WebSocketClient delegate;
  
  public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
    this.delegate = delegate;
  }

  public WebSocketClient(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebSocketClient() {
    this.delegate = null;
  }

  public io.vertx.core.http.WebSocketClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketClient that = (WebSocketClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @return the client WebSocket
   */
  public io.vertx.mutiny.core.http.ClientWebSocket webSocket() { 
    io.vertx.mutiny.core.http.ClientWebSocket ret = io.vertx.mutiny.core.http.ClientWebSocket.newInstance((io.vertx.core.http.ClientWebSocket)delegate.webSocket());
    return ret;
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> connect(int port, String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.connect(port, host, requestURI, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(int,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket connectAndAwait(int port, String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) connect(port, host, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(int,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(int,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#connect(int,String,String)} but you don't need to compose it with other operations.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   */
  public void connectAndForget(int port, String host, String requestURI) { 
    connect(port, host, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket to the default client port and specified host and relative request URI.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> connect(String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.connect(host, requestURI, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param host the host
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket connectAndAwait(String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) connect(host, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String,String)} but you don't need to compose it with other operations.
   * @param host the host
   * @param requestURI the relative URI
   */
  public void connectAndForget(String host, String requestURI) { 
    connect(host, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket to the default client port, default client host and specified, relative request URI.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> connect(String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.connect(requestURI, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket connectAndAwait(String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) connect(requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#connect(String)} but you don't need to compose it with other operations.
   * @param requestURI the relative URI
   */
  public void connectAndForget(String requestURI) { 
    connect(requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket with the specified options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the request options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> connect(io.vertx.core.http.WebSocketConnectOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.connect(options, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(WebSocketConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the request options
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket connectAndAwait(io.vertx.core.http.WebSocketConnectOptions options) { 
    return (io.vertx.mutiny.core.http.WebSocket) connect(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(WebSocketConnectOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#connect(WebSocketConnectOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#connect(WebSocketConnectOptions)} but you don't need to compose it with other operations.
   * @param options the request options
   */
  public void connectAndForget(io.vertx.core.http.WebSocketConnectOptions options) { 
    connect(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the new SSL options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.updateSSLOptions(options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the new SSL options
   * @return the Boolean instance produced by the operation.
   */
  public Boolean updateSSLOptionsAndAwait(io.vertx.core.net.SSLOptions options) { 
    return (Boolean) updateSSLOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions)} but you don't need to compose it with other operations.
   * @param options the new SSL options
   */
  public void updateSSLOptionsAndForget(io.vertx.core.net.SSLOptions options) { 
    updateSSLOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.updateSSLOptions(options, force, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return the Boolean instance produced by the operation.
   */
  public Boolean updateSSLOptionsAndAwait(io.vertx.core.net.SSLOptions options, boolean force) { 
    return (Boolean) updateSSLOptions(options, force).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#updateSSLOptions(SSLOptions,boolean)} but you don't need to compose it with other operations.
   * @param options the new SSL options
   * @param force force the update when options are equals
   */
  public void updateSSLOptionsAndForget(io.vertx.core.net.SSLOptions options, boolean force) { 
    updateSSLOptions(options, force).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the client. Closing will close down any pooled connections.
   * Clients should always be closed after use.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
    return arg != null ? new WebSocketClient(arg) : null;
  }

}
