package io.vertx.mutiny.ext.web;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.RequestBody.class)
public class RequestBody {

  public static final io.smallrye.mutiny.vertx.TypeArg<RequestBody> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RequestBody((io.vertx.ext.web.RequestBody) obj),
    RequestBody::getDelegate
  );

  private final io.vertx.ext.web.RequestBody delegate;
  
  public RequestBody(io.vertx.ext.web.RequestBody delegate) {
    this.delegate = delegate;
  }

  public RequestBody(Object delegate) {
    this.delegate = (io.vertx.ext.web.RequestBody)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RequestBody() {
    this.delegate = null;
  }

  public io.vertx.ext.web.RequestBody getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestBody that = (RequestBody) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the entire HTTP request body as a string, assuming UTF-8 encoding if the request does not provide the content type charset attribute. If a charset is provided in the request that it shall be respected. The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated.
   */
  public String asString() { 
    String ret = delegate.asString();
    return ret;
  }

  /**
   * @param encoding the encoding, e.g. "UTF-16"
   * @return the body
   */
  public String asString(String encoding) { 
    String ret = delegate.asString(encoding);
    return ret;
  }

  /**
   * @param maxAllowedLength if the current buffer length is greater than the limit an {@link java.lang.IllegalStateException} is thrown. This can be used to avoid DDoS attacks on very long JSON payloads that could take over the CPU while attempting to parse the data.
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public JsonObject asJsonObject(int maxAllowedLength) { 
    JsonObject ret = delegate.asJsonObject(maxAllowedLength);
    return ret;
  }

  /**
   * @param maxAllowedLength if the current buffer length is greater than the limit an {@link java.lang.IllegalStateException} is thrown. This can be used to avoid DDoS attacks on very long JSON payloads that could take over the CPU while attempting to parse the data.
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public JsonArray asJsonArray(int maxAllowedLength) { 
    JsonArray ret = delegate.asJsonArray(maxAllowedLength);
    return ret;
  }

  /**
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public JsonObject asJsonObject() { 
    JsonObject ret = delegate.asJsonObject();
    return ret;
  }

  /**
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned.
   */
  public JsonArray asJsonArray() { 
    JsonArray ret = delegate.asJsonArray();
    return ret;
  }

  /**
   * @return Get the entire HTTP request body as a . The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated.
   */
  public io.vertx.mutiny.core.buffer.Buffer buffer() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.buffer());
    return ret;
  }

  /**
   * @param clazz 
   * @param maxAllowedLength if the current buffer length is greater than the limit an {@link java.lang.IllegalStateException} is thrown. This can be used to avoid DDoS attacks on very long JSON payloads that could take over the CPU while attempting to parse the data.
   * @return Get the entire HTTP request body as a POJO. The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned. <b>WARNING:</b> This feature requires jackson-databind. Or another JSON codec that implements POJO parsing
   */
  public <R> R asPojo(java.lang.Class<R> clazz, int maxAllowedLength) { 
    R ret = (R)io.smallrye.mutiny.vertx.TypeArg.of(clazz).wrap(delegate.asPojo(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(clazz), maxAllowedLength));
    return ret;
  }

  /**
   * @param clazz 
   * @return Get the entire HTTP request body as a POJO. The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.BodyHandler} for this to be populated. <br/> When the body is <code>null</code> or the <code>"null"</code> JSON literal then <code>null</code> is returned. <b>WARNING:</b> This feature requires jackson-databind. Or another JSON codec that implements POJO parsing
   */
  public <R> R asPojo(java.lang.Class<R> clazz) { 
    R ret = (R)io.smallrye.mutiny.vertx.TypeArg.of(clazz).wrap(delegate.asPojo(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(clazz)));
    return ret;
  }

  /**
   * @return length in bytes.
   */
  public int length() { 
    int ret = delegate.length();
    return ret;
  }

  /**
   * @return <code>true</code> if empty.
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @return <code>true</code> if body was parsed during the duration of the request.
   */
  public boolean available() { 
    boolean ret = delegate.available();
    return ret;
  }

  public static  RequestBody newInstance(io.vertx.ext.web.RequestBody arg) {
    return arg != null ? new RequestBody(arg) : null;
  }

}
